package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3956;
import net.minecraft.class_3972;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9696;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.*;
import java.util.List;
import java.util.Optional;

public record FanBlastingDisplay(EntryIngredient input, EntryIngredient output, Optional<class_2960> location) implements Display {
    public static final DisplaySerializer<FanBlastingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(FanBlastingDisplay::input),
            EntryIngredient.codec().fieldOf("output").forGetter(FanBlastingDisplay::output),
            class_2960.field_25139.optionalFieldOf("location").forGetter(FanBlastingDisplay::location)
        ).apply(instance, FanBlastingDisplay::new)), class_9139.method_56436(
            EntryIngredient.streamCodec(),
            FanBlastingDisplay::input,
            EntryIngredient.streamCodec(),
            FanBlastingDisplay::output,
            class_9135.method_56382(class_2960.field_48267),
            FanBlastingDisplay::location,
            FanBlastingDisplay::new
        )
    );

    public static Display of(class_8786<?> entry) {
        if (!AllRecipeTypes.CAN_BE_AUTOMATED.test(entry)) {
            return null;
        }
        class_3972 recipe = (class_3972) entry.comp_1933();
        class_1856 ingredient = recipe.method_64720();
        Optional<class_1799> firstInput = ingredient.field_9019.method_40239().findFirst().map(item -> item.comp_349().method_7854());
        if (firstInput.isEmpty()) {
            return null;
        }
        class_9696 input = new class_9696(firstInput.get());
        MinecraftServer server = Create.SERVER;
        class_3218 world = server.method_3847(class_1937.field_25179);
        class_1863 recipeManager = server.method_3772();
        if (recipe instanceof class_3861) {
            Optional<class_8786<class_3859>> blastingRecipe = recipeManager.method_8132(class_3956.field_17547, input, world)
                .filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (blastingRecipe.isPresent()) {
                return null;
            }
        }
        Optional<class_8786<class_3862>> smokingRecipe = recipeManager.method_8132(class_3956.field_17548, input, world)
            .filter(AllRecipeTypes.CAN_BE_AUTOMATED);
        if (smokingRecipe.isPresent()) {
            return null;
        }
        return new FanBlastingDisplay(
            EntryIngredients.ofIngredient(ingredient),
            EntryIngredients.of(recipe.method_64721()),
            Optional.of(entry.comp_1932().method_29177())
        );
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.FAN_BLASTING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
