package com.zurrtum.create.content.contraptions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllContraptionTypeTags;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.UniqueLinkedList;
import com.zurrtum.create.catnip.math.BBHelper;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.zurrtum.create.content.contraptions.actors.seat.SeatBlock;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.bearing.MechanicalBearingBlock;
import com.zurrtum.create.content.contraptions.bearing.StabilizedContraption;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlock;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import com.zurrtum.create.content.contraptions.chassis.ChassisBlockEntity;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.PistonState;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonHeadBlock;
import com.zurrtum.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlock.MagnetBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlock.RopeBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.logistics.crate.CreativeCrateBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.redstone.contact.RedstoneContactBlock;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2281;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2440;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2764;
import net.minecraft.class_2814;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4844;
import net.minecraft.class_6088;
import net.minecraft.class_7477;
import net.minecraft.class_7871;
import net.minecraft.class_8942;
import net.minecraft.core.*;
import net.minecraft.world.level.block.*;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

import static com.zurrtum.create.Create.LOGGER;
import static com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.isExtensionPole;
import static com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.isPistonHead;

public abstract class Contraption {
    public static final Codec<Map<UUID, Integer>> SEAT_MAP_CODEC = Codec.unboundedMap(class_4844.field_41525, Codec.INT);
    public static final Codec<Map<UUID, BlockFace>> SUB_CONTRAPTIONS_CODEC = Codec.unboundedMap(class_4844.field_41525, BlockFace.CODEC);

    public Optional<List<class_238>> simplifiedEntityColliders;
    public AbstractContraptionEntity entity;

    public class_238 bounds;
    public class_2338 anchor;
    public boolean stalled;
    public boolean hasUniversalCreativeCrate;
    public boolean disassembled;

    // TODO: SoA to reduce map lookups.
    protected Map<class_2338, class_3501> blocks;
    protected Map<class_2338, class_2487> updateTags;
    public Object2BooleanMap<class_2338> isLegacy;
    protected List<MutablePair<class_3501, MovementContext>> actors;
    protected Map<class_2338, MovingInteractionBehaviour> interactors;
    protected List<class_1799> disabledActors;

    protected List<class_238> superglue;
    protected List<class_2338> seats;
    protected Map<UUID, Integer> seatMapping;
    protected Map<UUID, BlockFace> stabilizedSubContraptions;
    protected MountedStorageManager storage;
    protected Multimap<class_2338, class_3501> capturedMultiblocks;

    private Set<SuperGlueEntity> glueToRemove;
    private Map<class_2338, class_1297> initialPassengers;
    private List<BlockFace> pendingSubContraptions;

    private CompletableFuture<Void> simplifiedEntityColliderProvider;

    /**
     * All client-only data should be encapsulated here.
     *
     * <p>This field must be atomic as it is lazily accessed from both
     * the render thread and flywheel executors.
     *
     * <h2>Client/Server Safety</h2>
     * <p>Wrapping in an AtomicReference also makes this field server-safe,
     * as type erasure means ClientContraption will not be class loaded when
     * Contraption is class loaded.
     * Even still, care must be taken to not call getOrCreateClientContraptionLazy()
     * from the server. The only references to that method should be in rendering code.
     * Additional utilities are provided to safely access and send signals to the ClientContraption,
     * without initializing it.
     */
    public final AtomicReference<?> clientContraption = new AtomicReference<>();
    // Thin server and client side level used for generating optimized collision shapes.
    protected ContraptionWorld collisionLevel;

    public Contraption() {
        blocks = new HashMap<>();
        updateTags = new HashMap<>();
        isLegacy = new Object2BooleanArrayMap<>();
        seats = new ArrayList<>();
        actors = new ArrayList<>();
        disabledActors = new ArrayList<>();
        interactors = new HashMap<>();
        superglue = new ArrayList<>();
        seatMapping = new HashMap<>();
        glueToRemove = new HashSet<>();
        initialPassengers = new HashMap<>();
        pendingSubContraptions = new ArrayList<>();
        stabilizedSubContraptions = new HashMap<>();
        simplifiedEntityColliders = Optional.empty();
        storage = new MountedStorageManager();
        capturedMultiblocks = ArrayListMultimap.create();
    }

    public ContraptionWorld getContraptionWorld() {
        if (collisionLevel == null)
            collisionLevel = new ContraptionWorld(entity.method_73183(), this);
        return collisionLevel;
    }

    public abstract boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException;

    public abstract boolean canBeStabilized(class_2350 facing, class_2338 localPos);

    public abstract ContraptionType getType();

    protected boolean customBlockPlacement(class_1936 world, class_2338 pos, class_2680 state) {
        return false;
    }

    protected boolean customBlockRemoval(class_1936 world, class_2338 pos, class_2680 state) {
        return false;
    }

    protected boolean addToInitialFrontier(class_1937 world, class_2338 pos, class_2350 forcedDirection, Queue<class_2338> frontier) throws AssemblyException {
        return true;
    }

    public static Contraption fromData(class_1937 world, class_11368 view, boolean spawnData) {
        ContraptionType type = view.method_71426("Type", ContraptionType.CODEC).orElseThrow();
        Contraption contraption = type.factory.get();
        contraption.read(world, view, spawnData);
        contraption.collisionLevel = new ContraptionWorld(world, contraption);
        contraption.gatherBBsOffThread();
        return contraption;
    }

    public boolean searchMovedStructure(class_1937 world, class_2338 pos, @Nullable class_2350 forcedDirection) throws AssemblyException {
        initialPassengers.clear();
        Queue<class_2338> frontier = new UniqueLinkedList<>();
        Set<class_2338> visited = new HashSet<>();
        anchor = pos;

        if (bounds == null)
            bounds = new class_238(class_2338.field_10980);

        if (!BlockMovementChecks.isBrittle(world.method_8320(pos)))
            frontier.add(pos);
        if (!addToInitialFrontier(world, pos, forcedDirection, frontier))
            return false;
        for (int limit = 100000; limit > 0; limit--) {
            if (frontier.isEmpty())
                return true;
            if (!moveBlock(world, forcedDirection, frontier, visited))
                return false;
        }
        throw AssemblyException.structureTooLarge();
    }

    public void onEntityCreated(AbstractContraptionEntity entity) {
        this.entity = entity;

        // Create subcontraptions
        for (BlockFace blockFace : pendingSubContraptions) {
            class_2350 face = blockFace.getFace();
            StabilizedContraption subContraption = new StabilizedContraption(face);
            class_1937 world = entity.method_73183();
            class_2338 pos = blockFace.getPos();
            try {
                if (!subContraption.assemble(world, pos))
                    continue;
            } catch (AssemblyException e) {
                continue;
            }
            subContraption.removeBlocksFromWorld(world, class_2338.field_10980);
            OrientedContraptionEntity movedContraption = OrientedContraptionEntity.create(world, subContraption, face);
            class_2338 anchor = blockFace.getConnectedPos();
            movedContraption.method_5814(anchor.method_10263() + .5f, anchor.method_10264(), anchor.method_10260() + .5f);
            world.method_8649(movedContraption);
            stabilizedSubContraptions.put(movedContraption.method_5667(), new BlockFace(toLocalPos(pos), face));
        }

        storage.initialize();
        gatherBBsOffThread();
    }

    public void onEntityRemoved(AbstractContraptionEntity entity) {
        if (simplifiedEntityColliderProvider != null) {
            simplifiedEntityColliderProvider.cancel(false);
            simplifiedEntityColliderProvider = null;
        }
    }

    public void onEntityInitialize(class_1937 world, AbstractContraptionEntity contraptionEntity) {
        if (world.method_8608())
            return;

        for (OrientedContraptionEntity orientedCE : world.method_18467(
            OrientedContraptionEntity.class,
            contraptionEntity.method_5829().method_1014(1)
        ))
            if (stabilizedSubContraptions.containsKey(orientedCE.method_5667()))
                orientedCE.method_5804(contraptionEntity);

        for (class_2338 seatPos : getSeats()) {
            class_1297 passenger = initialPassengers.get(seatPos);
            if (passenger == null)
                continue;
            int seatIndex = getSeats().indexOf(seatPos);
            if (seatIndex == -1)
                continue;
            contraptionEntity.addSittingPassenger(passenger, seatIndex);
        }
    }

    private boolean canStickTo(class_2680 state, class_2680 other) {
        class_2248 stateBlock = state.method_26204();
        if (stateBlock == class_2246.field_10030) {
            return other.method_26204() != class_2246.field_21211;
        } else if (stateBlock == class_2246.field_21211) {
            return other.method_26204() != class_2246.field_10030;
        } else {
            class_2248 otherBlock = other.method_26204();
            return otherBlock == class_2246.field_10030 || otherBlock == class_2246.field_21211;
        }
    }

    /**
     * move the first block in frontier queue
     */
    protected boolean moveBlock(
        class_1937 world,
        @Nullable class_2350 forcedDirection,
        Queue<class_2338> frontier,
        Set<class_2338> visited
    ) throws AssemblyException {
        class_2338 pos = frontier.poll();
        if (pos == null)
            return false;
        visited.add(pos);

        if (world.method_31606(pos))
            return true;
        if (!world.method_8477(pos))
            throw AssemblyException.unloadedChunk(pos);
        if (isAnchoringBlockAt(pos))
            return true;
        class_2680 state = world.method_8320(pos);
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos))
            return true;
        if (!movementAllowed(state, world, pos))
            throw AssemblyException.unmovableBlock(pos, state);
        if (state.method_26204() instanceof AbstractChassisBlock && !moveChassis(world, pos, forcedDirection, frontier, visited))
            return false;

        if (state.method_27852(AllBlocks.BELT))
            moveBelt(pos, frontier, visited, state);

        if (state.method_27852(AllBlocks.WINDMILL_BEARING) && world.method_8321(pos) instanceof WindmillBearingBlockEntity wbbe)
            wbbe.disassembleForMovement();

        if (state.method_27852(AllBlocks.GANTRY_CARRIAGE))
            moveGantryPinion(world, pos, frontier, visited, state);

        if (state.method_27852(AllBlocks.GANTRY_SHAFT))
            moveGantryShaft(world, pos, frontier, visited, state);

        if (state.method_27852(AllBlocks.STICKER) && state.method_11654(StickerBlock.EXTENDED)) {
            class_2350 offset = state.method_11654(StickerBlock.field_10927);
            class_2338 attached = pos.method_10093(offset);
            if (!visited.contains(attached) && !BlockMovementChecks.isNotSupportive(world.method_8320(attached), offset.method_10153()))
                frontier.add(attached);
        }

        if (world.method_8321(pos) instanceof ChainConveyorBlockEntity ccbe)
            ccbe.notifyConnectedToValidate();

        // Double Chest halves stick together
        if (state.method_28498(class_2281.field_10770) && state.method_28498(class_2281.field_10768) && state.method_11654(class_2281.field_10770) != class_2745.field_12569) {
            class_2350 offset = class_2281.method_9758(state);
            class_2338 attached = pos.method_10093(offset);
            if (!visited.contains(attached))
                frontier.add(attached);
        }

        // Bogeys tend to have sticky sides
        if (state.method_26204() instanceof AbstractBogeyBlock<?> bogey)
            for (class_2350 d : bogey.getStickySurfaces(world, pos, state))
                if (!visited.contains(pos.method_10093(d)))
                    frontier.add(pos.method_10093(d));

        // Bearings potentially create stabilized sub-contraptions
        if (state.method_27852(AllBlocks.MECHANICAL_BEARING))
            moveBearing(pos, frontier, visited, state);

        // WM Bearings attach their structure when moved
        if (state.method_27852(AllBlocks.WINDMILL_BEARING))
            moveWindmillBearing(pos, frontier, visited, state);

        // Seats transfer their passenger to the contraption
        if (state.method_26204() instanceof SeatBlock)
            moveSeat(world, pos);

        // Pulleys drag their rope and their attached structure
        if (state.method_26204() instanceof PulleyBlock)
            movePulley(world, pos, frontier, visited);

        // Pistons drag their attaches poles and extension
        if (state.method_26204() instanceof MechanicalPistonBlock)
            if (!moveMechanicalPiston(world, pos, frontier, visited, state))
                return false;
        if (isExtensionPole(state))
            movePistonPole(world, pos, frontier, visited, state);
        if (isPistonHead(state))
            movePistonHead(world, pos, frontier, visited, state);

        // Cart assemblers attach themselves
        class_2338 posDown = pos.method_10074();
        class_2680 stateBelow = world.method_8320(posDown);
        if (!visited.contains(posDown) && stateBelow.method_27852(AllBlocks.CART_ASSEMBLER))
            frontier.add(posDown);

        // Slime blocks and super glue drag adjacent blocks if possible
        for (class_2350 offset : Iterate.directions) {
            class_2338 offsetPos = pos.method_10093(offset);
            class_2680 blockState = world.method_8320(offsetPos);
            if (isAnchoringBlockAt(offsetPos))
                continue;
            if (!movementAllowed(blockState, world, offsetPos)) {
                if (offset == forcedDirection)
                    throw AssemblyException.unmovableBlock(pos, state);
                continue;
            }

            boolean wasVisited = visited.contains(offsetPos);
            boolean faceHasGlue = SuperGlueEntity.isGlued(world, pos, offset, glueToRemove);
            boolean blockAttachedTowardsFace = BlockMovementChecks.isBlockAttachedTowards(blockState, world, offsetPos, offset.method_10153());
            boolean brittle = BlockMovementChecks.isBrittle(blockState);
            boolean canStick = !brittle && canStickTo(state, blockState);
            if (canStick) {
                if (state.method_26223() == class_3619.field_15970 || blockState.method_26223() == class_3619.field_15970) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(state, offset)) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(blockState, offset.method_10153())) {
                    canStick = false;
                }
            }

            if (!wasVisited && (canStick || blockAttachedTowardsFace || faceHasGlue || (offset == forcedDirection && !BlockMovementChecks.isNotSupportive(state,
                forcedDirection
            ))))
                frontier.add(offsetPos);
        }

        addBlock(world, pos, capture(world, pos));
        if (blocks.size() <= AllConfigs.server().kinetics.maxBlocksMoved.get())
            return true;
        else
            throw AssemblyException.structureTooLarge();
    }

    protected void movePistonHead(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2350 direction = state.method_11654(MechanicalPistonHeadBlock.field_10927);
        class_2338 offset = pos.method_10093(direction.method_10153());
        if (!visited.contains(offset)) {
            class_2680 blockState = world.method_8320(offset);
            if (isExtensionPole(blockState) && blockState.method_11654(PistonExtensionPoleBlock.field_10927).method_10166() == direction.method_10166())
                frontier.add(offset);
            if (blockState.method_26204() instanceof MechanicalPistonBlock) {
                class_2350 pistonFacing = blockState.method_11654(MechanicalPistonBlock.FACING);
                if (pistonFacing == direction && blockState.method_11654(MechanicalPistonBlock.STATE) == PistonState.EXTENDED)
                    frontier.add(offset);
            }
        }
        if (state.method_11654(MechanicalPistonHeadBlock.TYPE) == class_2764.field_12634) {
            class_2338 attached = pos.method_10093(direction);
            if (!visited.contains(attached))
                frontier.add(attached);
        }
    }

    protected void movePistonPole(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        for (class_2350 d : Iterate.directionsInAxis(state.method_11654(PistonExtensionPoleBlock.field_10927).method_10166())) {
            class_2338 offset = pos.method_10093(d);
            if (!visited.contains(offset)) {
                class_2680 blockState = world.method_8320(offset);
                if (isExtensionPole(blockState) && blockState.method_11654(PistonExtensionPoleBlock.field_10927).method_10166() == d.method_10166())
                    frontier.add(offset);
                if (isPistonHead(blockState) && blockState.method_11654(MechanicalPistonHeadBlock.field_10927).method_10166() == d.method_10166())
                    frontier.add(offset);
                if (blockState.method_26204() instanceof MechanicalPistonBlock) {
                    class_2350 pistonFacing = blockState.method_11654(MechanicalPistonBlock.FACING);
                    if (pistonFacing == d || pistonFacing == d.method_10153() && blockState.method_11654(MechanicalPistonBlock.STATE) == PistonState.EXTENDED)
                        frontier.add(offset);
                }
            }
        }
    }

    protected void moveGantryPinion(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2338 offset = pos.method_10093(state.method_11654(GantryCarriageBlock.FACING));
        if (!visited.contains(offset))
            frontier.add(offset);
        class_2351 rotationAxis = ((IRotate) state.method_26204()).getRotationAxis(state);
        for (class_2350 d : Iterate.directionsInAxis(rotationAxis)) {
            offset = pos.method_10093(d);
            class_2680 offsetState = world.method_8320(offset);
            if (offsetState.method_27852(AllBlocks.GANTRY_SHAFT) && offsetState.method_11654(GantryShaftBlock.FACING).method_10166() == d.method_10166())
                if (!visited.contains(offset))
                    frontier.add(offset);
        }
    }

    protected void moveGantryShaft(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        for (class_2350 d : Iterate.directions) {
            class_2338 offset = pos.method_10093(d);
            if (!visited.contains(offset)) {
                class_2680 offsetState = world.method_8320(offset);
                class_2350 facing = state.method_11654(GantryShaftBlock.FACING);
                if (d.method_10166() == facing.method_10166() && offsetState.method_27852(AllBlocks.GANTRY_SHAFT) && offsetState.method_11654(GantryShaftBlock.FACING) == facing)
                    frontier.add(offset);
                else if (offsetState.method_27852(AllBlocks.GANTRY_CARRIAGE) && offsetState.method_11654(GantryCarriageBlock.FACING) == d)
                    frontier.add(offset);
            }
        }
    }

    private void moveWindmillBearing(class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2350 facing = state.method_11654(WindmillBearingBlock.FACING);
        class_2338 offset = pos.method_10093(facing);
        if (!visited.contains(offset))
            frontier.add(offset);
    }

    private void moveBearing(class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2350 facing = state.method_11654(MechanicalBearingBlock.FACING);
        if (!canBeStabilized(facing, pos.method_10059(anchor))) {
            class_2338 offset = pos.method_10093(facing);
            if (!visited.contains(offset))
                frontier.add(offset);
            return;
        }
        pendingSubContraptions.add(new BlockFace(pos, facing));
    }

    private void moveBelt(class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2338 nextPos = BeltBlock.nextSegmentPosition(state, pos, true);
        class_2338 prevPos = BeltBlock.nextSegmentPosition(state, pos, false);
        if (nextPos != null && !visited.contains(nextPos))
            frontier.add(nextPos);
        if (prevPos != null && !visited.contains(prevPos))
            frontier.add(prevPos);
    }

    private void moveSeat(class_1937 world, class_2338 pos) {
        class_2338 local = toLocalPos(pos);
        getSeats().add(local);
        List<SeatEntity> seatsEntities = world.method_18467(SeatEntity.class, new class_238(pos));
        if (!seatsEntities.isEmpty()) {
            SeatEntity seat = seatsEntities.getFirst();
            List<class_1297> passengers = seat.method_5685();
            if (!passengers.isEmpty())
                initialPassengers.put(local, passengers.getFirst());
        }
    }

    private void movePulley(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited) {
        int limit = AllConfigs.server().kinetics.maxRopeLength.get();
        class_2338 ropePos = pos;
        while (limit-- >= 0) {
            ropePos = ropePos.method_10074();
            if (!world.method_8477(ropePos))
                break;
            class_2680 ropeState = world.method_8320(ropePos);
            class_2248 block = ropeState.method_26204();
            if (!(block instanceof RopeBlock) && !(block instanceof MagnetBlock)) {
                if (!visited.contains(ropePos))
                    frontier.add(ropePos);
                break;
            }
            addBlock(world, ropePos, capture(world, ropePos));
        }
    }

    private boolean moveMechanicalPiston(
        class_1937 world,
        class_2338 pos,
        Queue<class_2338> frontier,
        Set<class_2338> visited,
        class_2680 state
    ) throws AssemblyException {
        class_2350 direction = state.method_11654(MechanicalPistonBlock.FACING);
        PistonState pistonState = state.method_11654(MechanicalPistonBlock.STATE);
        if (pistonState == PistonState.MOVING)
            return false;

        class_2338 offset = pos.method_10093(direction.method_10153());
        if (!visited.contains(offset)) {
            class_2680 poleState = world.method_8320(offset);
            if (poleState.method_27852(AllBlocks.PISTON_EXTENSION_POLE) && poleState.method_11654(PistonExtensionPoleBlock.field_10927).method_10166() == direction.method_10166())
                frontier.add(offset);
        }

        if (pistonState == PistonState.EXTENDED || MechanicalPistonBlock.isStickyPiston(state)) {
            offset = pos.method_10093(direction);
            if (!visited.contains(offset))
                frontier.add(offset);
        }

        return true;
    }

    private boolean moveChassis(class_1937 world, class_2338 pos, class_2350 movementDirection, Queue<class_2338> frontier, Set<class_2338> visited) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof ChassisBlockEntity chassis))
            return false;
        chassis.addAttachedChasses(frontier, visited);
        List<class_2338> includedBlockPositions = chassis.getIncludedBlockPositions(movementDirection, false);
        if (includedBlockPositions == null)
            return false;
        for (class_2338 blockPos : includedBlockPositions)
            if (!visited.contains(blockPos))
                frontier.add(blockPos);
        return true;
    }

    protected Pair<class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        class_2680 blockstate = world.method_8320(pos);
        if (blockstate.method_27852(AllBlocks.REDSTONE_CONTACT))
            blockstate = blockstate.method_11657(RedstoneContactBlock.POWERED, true);
        if (blockstate.method_27852(AllBlocks.POWERED_SHAFT))
            blockstate = BlockHelper.copyProperties(blockstate, AllBlocks.SHAFT.method_9564());
        if (blockstate.method_26204() instanceof ControlsBlock && getType().is(AllContraptionTypeTags.OPENS_CONTROLS))
            blockstate = blockstate.method_11657(ControlsBlock.OPEN, true);
        if (blockstate.method_28498(SlidingDoorBlock.VISIBLE))
            blockstate = blockstate.method_11657(SlidingDoorBlock.VISIBLE, false);
        if (blockstate.method_26204() instanceof class_2269) {
            blockstate = blockstate.method_11657(class_2269.field_10729, false);
            world.method_64310(pos, blockstate.method_26204(), -1);
        }
        if (blockstate.method_26204() instanceof class_2440) {
            blockstate = blockstate.method_11657(class_2440.field_11358, false);
            world.method_64310(pos, blockstate.method_26204(), -1);
        }
        class_2487 compoundnbt = getBlockEntityNBT(world, pos);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PoweredShaftBlockEntity)
            blockEntity = new BracketedKineticBlockEntity(pos, blockstate);
        if (blockEntity instanceof FactoryPanelBlockEntity fpbe) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), LOGGER)) {
                fpbe.writeSafe(new class_11362(logging, world.method_30349().method_57093(class_2509.field_11560), compoundnbt));
            }
        }

        return Pair.of(new class_3501(pos, blockstate, compoundnbt), blockEntity);
    }

    protected void addBlock(class_1937 level, class_2338 pos, Pair<class_3501, class_2586> pair) {
        class_3501 captured = pair.getKey();
        class_2338 localPos = pos.method_10059(anchor);
        class_2680 state = captured.comp_1342();
        class_3501 structureBlockInfo = new class_3501(localPos, state, captured.comp_1343());

        if (blocks.put(localPos, structureBlockInfo) != null)
            return;
        bounds = bounds.method_991(new class_238(localPos));

        class_2586 be = pair.getValue();

        if (be != null) {
            class_2487 updateTag = be.method_16887(level.method_30349());
            // empty tags are intentionally kept, see writeBlocksCompound
            // for testing, this line can be commented to emulate legacy behavior
            updateTags.put(localPos, updateTag);
        }

        storage.addBlock(level, state, pos, localPos, be);

        captureMultiblock(localPos, structureBlockInfo, be);

        if (MovementBehaviour.REGISTRY.get(state) != null)
            actors.add(MutablePair.of(structureBlockInfo, null));

        MovingInteractionBehaviour interactionBehaviour = MovingInteractionBehaviour.REGISTRY.get(state);
        if (interactionBehaviour != null)
            interactors.put(localPos, interactionBehaviour);

        if (be instanceof CreativeCrateBlockEntity crateBlockEntity && crateBlockEntity.getBehaviour(ServerFilteringBehaviour.TYPE).getFilter()
            .method_7960())
            hasUniversalCreativeCrate = true;
    }

    protected void captureMultiblock(class_2338 localPos, class_3501 structureBlockInfo, class_2586 be) {
        if (!(be instanceof IMultiBlockEntityContainer multiBlockBE))
            return;

        class_2487 nbt = structureBlockInfo.comp_1343();
        class_2338 controllerPos = nbt.method_67491("Controller", class_2338.field_25064).map(this::toLocalPos).orElse(localPos);
        nbt.method_67494("Controller", class_2338.field_25064, controllerPos);

        if (updateTags.containsKey(localPos))
            updateTags.get(localPos).method_67494("Controller", class_2338.field_25064, controllerPos);

        if (multiBlockBE.isController() && multiBlockBE.getHeight() <= 1 && multiBlockBE.getWidth() <= 1) {
            nbt.method_67494("LastKnownPos", class_2338.field_25064, class_2338.field_10980.method_10087(Integer.MAX_VALUE - 1));
            return;
        }

        nbt.method_10551("LastKnownPos");
        capturedMultiblocks.put(controllerPos, structureBlockInfo);
    }

    @Nullable
    protected class_2487 getBlockEntityNBT(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null)
            return null;
        class_2487 nbt = blockEntity.method_38242(world.method_30349());
        nbt.method_10551("x");
        nbt.method_10551("y");
        nbt.method_10551("z");

        return nbt;
    }

    protected class_2338 toLocalPos(class_2338 globalPos) {
        return globalPos.method_10059(anchor);
    }

    protected boolean movementAllowed(class_2680 state, class_1937 world, class_2338 pos) {
        return BlockMovementChecks.isMovementAllowed(state, world, pos);
    }

    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return pos.equals(anchor);
    }

    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        readBlocksCompound(view.method_71434("Blocks"), world);

        capturedMultiblocks.clear();
        view.method_71438("CapturedMultiblocks").forEach(c -> {
            class_2338 controllerPos = c.method_71426("Controller", class_2338.field_25064).orElseThrow();
            c.method_71426("Parts", CreateCodecs.BLOCK_POS_LIST_CODEC).orElseThrow().forEach(pos -> capturedMultiblocks.put(controllerPos, blocks.get(pos)));
        });

        storage.read(view, spawnData, this);

        actors.clear();
        view.method_71438("Actors").forEach(c -> {
            c.method_71426("Pos", class_2338.field_25064).ifPresent(pos -> {
                class_3501 info = blocks.get(pos);
                if (info == null)
                    return;
                MovementContext context = MovementContext.read(world, info, c, this);
                actors.add(MutablePair.of(info, context));
            });
        });

        disabledActors.clear();
        superglue.clear();
        seats.clear();
        seatMapping.clear();
        stabilizedSubContraptions.clear();
        view.method_71426("DisabledActors", CreateCodecs.ITEM_LIST_CODEC).ifPresent(list -> {
            disabledActors.addAll(list);
            for (class_1799 stack : disabledActors) {
                setActorsActive(stack, false);
            }
        });
        view.method_71426("Superglue", CreateCodecs.BOX_CODEC.listOf()).ifPresent(list -> superglue.addAll(list));
        view.method_71426("Seats", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresent(list -> seats.addAll(list));
        view.method_71426("Passengers", SEAT_MAP_CODEC).ifPresent(map -> seatMapping.putAll(map));
        view.method_71426("SubContraptions", SUB_CONTRAPTIONS_CODEC).ifPresent(map -> stabilizedSubContraptions.putAll(map));

        view.method_71426("Interactors", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresentOrElse(
            list -> list.forEach(pos -> {
                class_3501 structureBlockInfo = blocks.get(pos);
                if (structureBlockInfo == null)
                    return;
                MovingInteractionBehaviour behaviour = MovingInteractionBehaviour.REGISTRY.get(structureBlockInfo.comp_1342());
                if (behaviour != null)
                    interactors.put(pos, behaviour);
            }), interactors::clear
        );

        view.method_71426("BoundsFront", CreateCodecs.BOX_CODEC).ifPresent(box -> bounds = box);
        stalled = view.method_71433("Stalled", false);
        hasUniversalCreativeCrate = view.method_71433("BottomlessSupply", false);
        anchor = view.method_71426("Anchor", class_2338.field_25064).orElseThrow();
    }

    public void write(class_11372 view, boolean spawnPacket) {
        view.method_71468("Type", CreateRegistries.CONTRAPTION_TYPE.method_39673(), getType());

        writeBlocksCompound(view.method_71461("Blocks"), spawnPacket);

        class_11372.class_11374 multiblocks = view.method_71476("CapturedMultiblocks");
        capturedMultiblocks.keySet().forEach(controllerPos -> {
            class_11372 block = multiblocks.method_71480();
            block.method_71468("Controller", class_2338.field_25064, controllerPos);

            Collection<class_3501> multiblockParts = capturedMultiblocks.get(controllerPos);
            List<class_2338> list = multiblockParts.stream().map(class_3501::comp_1341).toList();
            block.method_71468("Parts", CreateCodecs.BLOCK_POS_LIST_CODEC, list);
        });

        class_11372.class_11374 actors = view.method_71476("Actors");
        for (MutablePair<class_3501, MovementContext> actor : getActors()) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get(actor.left.comp_1342());
            if (behaviour == null)
                continue;
            class_11372 item = actors.method_71480();
            item.method_71468("Pos", class_2338.field_25064, actor.left.comp_1341());
            behaviour.writeExtraData(actor.right);
            actor.right.write(item);
        }

        view.method_71468("DisabledActors", CreateCodecs.ITEM_LIST_CODEC, disabledActors);
        if (!spawnPacket) {
            view.method_71468("Superglue", CreateCodecs.BOX_CODEC.listOf(), superglue);
        }

        writeStorage(view, spawnPacket);

        view.method_71468("Interactors", CreateCodecs.BLOCK_POS_LIST_CODEC, interactors.keySet().stream().toList());
        view.method_71468("Seats", CreateCodecs.BLOCK_POS_LIST_CODEC, seats);
        view.method_71468("Passengers", SEAT_MAP_CODEC, seatMapping);
        view.method_71468("SubContraptions", SUB_CONTRAPTIONS_CODEC, stabilizedSubContraptions);
        view.method_71468("Anchor", class_2338.field_25064, anchor);
        view.method_71472("Stalled", stalled);
        view.method_71472("BottomlessSupply", hasUniversalCreativeCrate);

        if (bounds != null) {
            view.method_71468("BoundsFront", CreateCodecs.BOX_CODEC, bounds);
        }
    }

    public void writeStorage(class_11372 view, boolean spawnPacket) {
        storage.write(view, spawnPacket);
    }

    private void writeBlocksCompound(class_11372 view, boolean spawnPacket) {
        class_2814<class_2680> palette = new class_2814<>(16);
        class_11372.class_11374 blockList = view.method_71476("BlockList");

        boolean isClient = spawnPacket && entity.method_73183().method_8608();
        for (class_3501 block : this.blocks.values()) {
            int id = palette.method_12291(
                block.comp_1342(), (i, s) -> {
                    throw new IllegalStateException("Palette Map index exceeded maximum");
                }
            );
            class_2338 pos = block.comp_1341();
            class_11372 c = blockList.method_71480();
            c.method_71466("Pos", pos.method_10063());
            c.method_71465("State", id);

            class_2487 updateTag = updateTags.get(pos);
            if (spawnPacket) {
                // for client sync, treat the updateTag as the data
                if (updateTag != null) {
                    c.method_71468("Data", class_2487.field_25128, updateTag);
                } else if (block.comp_1343() != null) {
                    if (isClient) {
                        c.method_71468("UpdateTag", class_2487.field_25128, block.comp_1343());
                    } else {
                        // an updateTag is saved for all BlockEntities, even when empty.
                        // this case means that the contraption was assembled pre-updateTags.
                        // in this case, we need to use the full BlockEntity data.
                        c.method_71468("Data", class_2487.field_25128, block.comp_1343());
                        c.method_71472("Legacy", true);
                    }
                }
            } else {
                // otherwise, write actual data as the data, save updateTag on its own
                if (block.comp_1343() != null) {
                    c.method_71468("Data", class_2487.field_25128, block.comp_1343());
                }
                if (updateTag != null) {
                    c.method_71468("UpdateTag", class_2487.field_25128, updateTag);
                }
            }
        }

        int size = palette.method_12197();
        List<class_2680> paletteData = new ArrayList<>(size);
        for (int i = 0; i < size; i++) {
            paletteData.add(palette.method_12288(i));
        }
        view.method_71468("Palette", CreateCodecs.BLOCK_STATE_LIST_CODEC, paletteData);
    }

    private void readBlocksCompound(class_11368 view, class_1937 world) {
        blocks.clear();
        updateTags.clear();
        isLegacy.clear();

        class_2814<class_2680> palette = new class_2814<>(
            16,
            view.method_71426("Palette", CreateCodecs.BLOCK_STATE_LIST_CODEC).orElseGet(ArrayList::new)
        );

        view.method_71438("BlockList").forEach(c -> {
            class_3501 info = readStructureBlockInfo(c, palette);

            blocks.put(info.comp_1341(), info);

            // it's very important that empty tags are read here. see writeBlocksCompound
            c.method_71426("UpdateTag", class_2487.field_25128).ifPresent(updateTag -> updateTags.put(info.comp_1341(), updateTag));

            // Mark the pos if it has the legacy marker.
            // This will be used when creating BlockEntities for the ClientContraption.
            this.isLegacy.put(info.comp_1341(), c.method_71433("Legacy", false));
        });
        AllClientHandle.INSTANCE.resetClientContraption(this);
    }

    private static class_3501 readStructureBlockInfo(class_11368 view, class_2814<class_2680> palette) {
        return new class_3501(
            class_2338.method_10092(view.method_71425("Pos", 0)),
            Objects.requireNonNull(palette.method_12288(view.method_71424("State", 0))),
            view.method_71426("Data", class_2487.field_25128).orElse(null)
        );
    }

    private static class_3501 legacyReadStructureBlockInfo(class_2487 blockListEntry, class_7871<class_2248> holderGetter) {
        return new class_3501(
            NBTHelper.readBlockPos(blockListEntry, "Pos"),
            class_2512.method_10681(holderGetter, blockListEntry.method_68568("Block")),
            blockListEntry.method_10545("Data") ? blockListEntry.method_68568("Data") : null
        );
    }

    public void removeBlocksFromWorld(class_1937 world, class_2338 offset) {
        glueToRemove.forEach(glue -> {
            superglue.add(glue.method_5829().method_997(class_243.method_24954(offset.method_10081(anchor)).method_1021(-1)));
            glue.method_31472();
        });

        List<class_3341> minimisedGlue = new ArrayList<>();
        for (int i = 0; i < superglue.size(); i++)
            minimisedGlue.add(null);

        for (boolean brittles : Iterate.trueAndFalse) {
            for (Iterator<class_3501> iterator = blocks.values().iterator(); iterator.hasNext(); ) {
                class_3501 block = iterator.next();
                if (brittles != BlockMovementChecks.isBrittle(block.comp_1342()))
                    continue;

                for (int i = 0; i < superglue.size(); i++) {
                    class_238 aabb = superglue.get(i);
                    if (aabb == null || !aabb.method_1008(block.comp_1341().method_10263() + .5, block.comp_1341().method_10264() + .5, block.comp_1341().method_10260() + .5))
                        continue;
                    if (minimisedGlue.get(i) == null)
                        minimisedGlue.set(i, new class_3341(block.comp_1341()));
                    else
                        minimisedGlue.set(i, BBHelper.encapsulate(minimisedGlue.get(i), block.comp_1341()));
                }

                class_2338 add = block.comp_1341().method_10081(anchor).method_10081(offset);
                if (customBlockRemoval(world, add, block.comp_1342()))
                    continue;
                class_2680 oldState = world.method_8320(add);
                class_2248 blockIn = oldState.method_26204();
                boolean blockMismatch = block.comp_1342().method_26204() != blockIn;
                blockMismatch &= AllBlocks.POWERED_SHAFT != blockIn || !block.comp_1342().method_27852(AllBlocks.SHAFT);
                if (blockMismatch)
                    iterator.remove();
                world.method_8544(add);
                int flags = class_2248.field_31033 | class_2248.field_31032 | class_2248.field_31031 | class_2248.field_31028 | class_2248.field_31030;
                if (blockIn instanceof class_3737 && oldState.method_28498(class_2741.field_12508) && oldState.method_11654(
                    class_2741.field_12508)) {
                    world.method_8652(add, class_2246.field_10382.method_9564(), flags);
                    continue;
                }
                world.method_8652(add, class_2246.field_10124.method_9564(), flags);
            }
        }

        superglue.clear();
        for (class_3341 box : minimisedGlue) {
            if (box == null)
                continue;
            class_238 bb = new class_238(box.method_35415(), box.method_35416(), box.method_35417(), box.method_35418() + 1, box.method_35419() + 1, box.method_35420() + 1);
            if (bb.method_995() > 1.01)
                superglue.add(bb);
        }

        for (class_3501 block : blocks.values()) {
            class_2338 add = block.comp_1341().method_10081(anchor).method_10081(offset);
            //			if (!shouldUpdateAfterMovement(block))
            //				continue;

            int flags = class_2248.field_31033 | class_2248.field_31036;
            world.method_8413(add, block.comp_1342(), class_2246.field_10124.method_9564(), flags);

            // when the blockstate is set to air, the block's POI data is removed, but
            // markAndNotifyBlock tries to
            // remove it again, so to prevent an error from being logged by double-removal
            // we add the POI data back now
            // (code copied from ServerWorld.onBlockStateChange)
            class_3218 serverWorld = (class_3218) world;
            class_7477.method_43989(block.comp_1342()).ifPresent(poiType -> {
                world.method_8503().execute(() -> {
                    serverWorld.method_19494().method_19115(add, poiType);
                });
            });

            BlockHelper.markAndNotifyBlock(world, add, world.method_8500(add), block.comp_1342(), class_2246.field_10124.method_9564(), flags);
            block.comp_1342().method_30102(world, add, flags & -2);
        }
    }

    public void addBlocksToWorld(class_1937 world, StructureTransform transform) {
        if (disassembled)
            return;
        disassembled = true;

        boolean shouldDropBlocks = !AllConfigs.server().kinetics.noDropWhenContraptionReplaceBlocks.get();

        translateMultiblockControllers(transform);

        for (boolean nonBrittles : Iterate.trueAndFalse) {
            for (class_3501 block : blocks.values()) {
                if (nonBrittles == BlockMovementChecks.isBrittle(block.comp_1342()))
                    continue;

                class_2338 targetPos = transform.apply(block.comp_1341());
                class_2680 state = transform.apply(block.comp_1342());

                if (customBlockPlacement(world, targetPos, state))
                    continue;

                if (nonBrittles)
                    for (class_2350 face : Iterate.directions)
                        state = state.method_26191(
                            world,
                            world,
                            targetPos,
                            face,
                            targetPos.method_10093(face),
                            world.method_8320(targetPos.method_10093(face)),
                            world.field_9229
                        );

                class_2680 blockState = world.method_8320(targetPos);
                if (blockState.method_26214(world, targetPos) == -1 || (state.method_26220(world, targetPos)
                    .method_1110() && !blockState.method_26220(world, targetPos).method_1110())) {
                    if (targetPos.method_10264() == world.method_31607())
                        targetPos = targetPos.method_10084();
                    world.method_20290(class_6088.field_31144, targetPos, class_2248.method_9507(state));
                    if (shouldDropBlocks) {
                        class_2248.method_9610(state, world, targetPos, null);
                    }
                    continue;
                }
                if (state.method_26204() instanceof class_3737 && state.method_28498(class_2741.field_12508)) {
                    class_3610 FluidState = world.method_8316(targetPos);
                    state = state.method_11657(class_2741.field_12508, FluidState.method_15772() == class_3612.field_15910);
                }

                world.method_22352(targetPos, shouldDropBlocks);

                if (state.method_27852(AllBlocks.SHAFT))
                    state = ShaftBlock.pickCorrectShaftType(state, world, targetPos);
                if (state.method_28498(SlidingDoorBlock.VISIBLE))
                    state = state.method_11657(SlidingDoorBlock.VISIBLE, !state.method_11654(SlidingDoorBlock.field_10945))
                        .method_11657(SlidingDoorBlock.field_10940, false);
                // Stop Sculk shriekers from getting "stuck" if moved mid-shriek.
                if (state.method_27852(class_2246.field_37571)) {
                    state = class_2246.field_37571.method_9564();
                }

                world.method_8652(targetPos, state, class_2248.field_31033 | class_2248.field_31036);

                boolean verticalRotation = transform.rotationAxis == null || transform.rotationAxis.method_10179();
                verticalRotation = verticalRotation && transform.rotation != class_2470.field_11467;
                if (verticalRotation) {
                    if (state.method_26204() instanceof RopeBlock || state.method_26204() instanceof MagnetBlock || state.method_26204() instanceof class_2323)
                        world.method_22352(targetPos, shouldDropBlocks);
                }

                class_2586 blockEntity = world.method_8321(targetPos);

                class_2487 tag = block.comp_1343();

                // Temporary fix: Calling load(CompoundTag tag) on a Sculk sensor causes it to not react to vibrations.
                if (state.method_27852(class_2246.field_28108) || state.method_27852(class_2246.field_37571))
                    tag = null;

                if (blockEntity != null)
                    tag = NBTProcessors.process(state, blockEntity, tag, false);
                if (blockEntity != null && tag != null) {
                    tag.method_10569("x", targetPos.method_10263());
                    tag.method_10569("y", targetPos.method_10264());
                    tag.method_10569("z", targetPos.method_10260());

                    if (verticalRotation && blockEntity instanceof PulleyBlockEntity) {
                        tag.method_10551("Offset");
                        tag.method_10551("InitialOffset");
                    }

                    if (blockEntity instanceof IMultiBlockEntityContainer) {
                        if (tag.method_10545("LastKnownPos") || capturedMultiblocks.isEmpty()) {
                            tag.method_67494("LastKnownPos", class_2338.field_25064, class_2338.field_10980.method_10087(Integer.MAX_VALUE - 1));
                            tag.method_10551("Controller");
                        }
                    }

                    try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), LOGGER)) {
                        blockEntity.method_58690(class_11352.method_71417(logging, world.method_30349(), tag));
                    }
                }

                storage.unmount(world, block, targetPos, blockEntity);

                if (blockEntity != null) {
                    transform.apply(blockEntity);
                }
            }
        }

        for (class_3501 block : blocks.values()) {
            if (!shouldUpdateAfterMovement(block))
                continue;
            class_2338 targetPos = transform.apply(block.comp_1341());
            BlockHelper.markAndNotifyBlock(
                world,
                targetPos,
                world.method_8500(targetPos),
                block.comp_1342(),
                block.comp_1342(),
                class_2248.field_31033 | class_2248.field_31036
            );
        }

        for (class_238 box : superglue) {
            box = new class_238(transform.apply(new class_243(box.field_1323, box.field_1322, box.field_1321)), transform.apply(new class_243(box.field_1320, box.field_1325, box.field_1324)));
            if (!world.method_8608())
                world.method_8649(new SuperGlueEntity(world, box));
        }
    }

    protected void translateMultiblockControllers(StructureTransform transform) {
        if (transform.rotationAxis != null && transform.rotationAxis != class_2351.field_11052 && transform.rotation != class_2470.field_11467) {
            capturedMultiblocks.values().forEach(info -> {
                info.comp_1343().method_67494("LastKnownPos", class_2338.field_25064, class_2338.field_10980.method_10087(Integer.MAX_VALUE - 1));
            });
            return;
        }

        capturedMultiblocks.keySet().forEach(controllerPos -> {
            Collection<class_3501> multiblockParts = capturedMultiblocks.get(controllerPos);
            Optional<class_3341> optionalBoundingBox = class_3341.method_35411(multiblockParts.stream()
                .map(info -> transform.apply(info.comp_1341())).toList());
            if (optionalBoundingBox.isEmpty())
                return;

            class_3341 boundingBox = optionalBoundingBox.get();
            class_2338 newControllerPos = new class_2338(boundingBox.method_35415(), boundingBox.method_35416(), boundingBox.method_35417());
            class_2338 otherPos = transform.unapply(newControllerPos);

            multiblockParts.forEach(info -> info.comp_1343().method_67494("Controller", class_2338.field_25064, newControllerPos));

            if (controllerPos.equals(otherPos))
                return;

            // swap nbt data to the new controller position
            class_3501 prevControllerInfo = blocks.get(controllerPos);
            class_3501 newControllerInfo = blocks.get(otherPos);
            if (prevControllerInfo == null || newControllerInfo == null)
                return;

            blocks.put(otherPos, new class_3501(newControllerInfo.comp_1341(), newControllerInfo.comp_1342(), prevControllerInfo.comp_1343()));
            blocks.put(controllerPos, new class_3501(prevControllerInfo.comp_1341(), prevControllerInfo.comp_1342(), newControllerInfo.comp_1343()));
        });
    }

    public void addPassengersToWorld(class_1937 world, StructureTransform transform, List<class_1297> seatedEntities) {
        for (class_1297 seatedEntity : seatedEntities) {
            if (getSeatMapping().isEmpty())
                continue;
            Integer seatIndex = getSeatMapping().get(seatedEntity.method_5667());
            if (seatIndex == null)
                continue;
            class_2338 seatPos = getSeats().get(seatIndex);
            seatPos = transform.apply(seatPos);
            if (!(world.method_8320(seatPos).method_26204() instanceof SeatBlock))
                continue;
            if (SeatBlock.isSeatOccupied(world, seatPos))
                continue;
            SeatBlock.sitDown(world, seatPos, seatedEntity);
        }
    }

    public void startMoving(class_1937 world) {
        disabledActors.clear();

        for (MutablePair<class_3501, MovementContext> pair : actors) {
            MovementContext context = new MovementContext(world, pair.left, this);
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get(pair.left.comp_1342());
            if (behaviour != null)
                behaviour.startMoving(context);
            pair.setRight(context);
            if (behaviour instanceof ContraptionControlsMovement)
                disableActorOnStart(context);
        }

        for (class_1799 stack : disabledActors)
            setActorsActive(stack, false);
    }

    protected void disableActorOnStart(MovementContext context) {
        if (!ContraptionControlsMovement.isDisabledInitially(context))
            return;
        class_1799 filter = ContraptionControlsMovement.getFilter(context);
        if (filter == null)
            return;
        if (isActorTypeDisabled(filter))
            return;
        disabledActors.add(filter);
    }

    public boolean isActorTypeDisabled(class_1799 filter) {
        return disabledActors.stream().anyMatch(i -> ContraptionControlsMovement.isSameFilter(i, filter));
    }

    public void setActorsActive(class_1799 referenceStack, boolean enable) {
        for (MutablePair<class_3501, MovementContext> pair : actors) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get(pair.left.comp_1342());
            if (behaviour == null)
                continue;
            class_1799 behaviourStack = behaviour.canBeDisabledVia(pair.right);
            if (behaviourStack == null)
                continue;
            if (!referenceStack.method_7960() && !ContraptionControlsMovement.isSameFilter(referenceStack, behaviourStack))
                continue;
            pair.right.disabled = !enable;
            if (!enable)
                behaviour.onDisabledByControls(pair.right);
        }
    }

    public List<class_1799> getDisabledActors() {
        return disabledActors;
    }

    public void stop(class_1937 world) {
        forEachActor(
            world, (behaviour, ctx) -> {
                behaviour.stopMoving(ctx);
                ctx.position = null;
                ctx.motion = class_243.field_1353;
                ctx.relativeMotion = class_243.field_1353;
                ctx.rotation = v -> v;
            }
        );
    }

    public void forEachActor(class_1937 world, BiConsumer<MovementBehaviour, MovementContext> callBack) {
        for (MutablePair<class_3501, MovementContext> pair : actors) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get(pair.getLeft().comp_1342());
            if (behaviour == null)
                continue;
            callBack.accept(behaviour, pair.getRight());
        }
    }

    protected boolean shouldUpdateAfterMovement(class_3501 info) {
        if (class_7477.method_43989(info.comp_1342()).isPresent())
            return false;
        if (info.comp_1342().method_26204() instanceof SlidingDoorBlock)
            return false;
        return true;
    }

    public void expandBoundsAroundAxis(class_2351 axis) {
        Set<class_2338> blocks = getBlocks().keySet();

        int radius = (int) (Math.ceil(getRadius(blocks, axis)));

        int maxX = radius + 2;
        int maxY = radius + 2;
        int maxZ = radius + 2;
        int minX = -radius - 1;
        int minY = -radius - 1;
        int minZ = -radius - 1;

        if (axis == class_2351.field_11048) {
            maxX = (int) bounds.field_1320;
            minX = (int) bounds.field_1323;
        } else if (axis == class_2351.field_11052) {
            maxY = (int) bounds.field_1325;
            minY = (int) bounds.field_1322;
        } else if (axis == class_2351.field_11051) {
            maxZ = (int) bounds.field_1324;
            minZ = (int) bounds.field_1321;
        }

        bounds = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Map<UUID, Integer> getSeatMapping() {
        return seatMapping;
    }

    public class_2338 getSeatOf(UUID entityId) {
        if (!getSeatMapping().containsKey(entityId))
            return null;
        int seatIndex = getSeatMapping().get(entityId);
        if (seatIndex >= getSeats().size())
            return null;
        return getSeats().get(seatIndex);
    }

    public class_2338 getBearingPosOf(UUID subContraptionEntityId) {
        if (stabilizedSubContraptions.containsKey(subContraptionEntityId))
            return stabilizedSubContraptions.get(subContraptionEntityId).getConnectedPos();
        return null;
    }

    public void setSeatMapping(Map<UUID, Integer> seatMapping) {
        this.seatMapping = seatMapping;
    }

    public List<class_2338> getSeats() {
        return seats;
    }

    public Map<class_2338, class_3501> getBlocks() {
        return blocks;
    }

    public Object2BooleanMap<class_2338> getIsLegacy() {
        return isLegacy;
    }

    public List<MutablePair<class_3501, MovementContext>> getActors() {
        return actors;
    }

    @Nullable
    public MutablePair<class_3501, MovementContext> getActorAt(class_2338 localPos) {
        for (MutablePair<class_3501, MovementContext> pair : actors)
            if (localPos.equals(pair.left.comp_1341()))
                return pair;
        return null;
    }

    public Map<class_2338, MovingInteractionBehaviour> getInteractors() {
        return interactors;
    }

    public void invalidateColliders() {
        simplifiedEntityColliders = Optional.empty();
        gatherBBsOffThread();
    }

    private void gatherBBsOffThread() {
        getContraptionWorld();
        if (simplifiedEntityColliderProvider != null) {
            simplifiedEntityColliderProvider.cancel(false);
        }
        simplifiedEntityColliderProvider = CompletableFuture.supplyAsync(() -> {
            class_265 combinedShape = class_259.method_1073();
            for (Map.Entry<class_2338, class_3501> entry : blocks.entrySet()) {
                class_3501 info = entry.getValue();
                class_2338 localPos = entry.getKey();
                class_265 collisionShape = info.comp_1342().method_26194(collisionLevel, localPos, class_3726.method_16194());
                if (collisionShape.method_1110())
                    continue;
                combinedShape = class_259.method_1082(
                    combinedShape,
                    collisionShape.method_1096(localPos.method_10263(), localPos.method_10264(), localPos.method_10260()),
                    class_247.field_1366
                );
            }
            return combinedShape.method_1097().method_1090();
        }).thenAccept(r -> {
            simplifiedEntityColliders = Optional.of(r);
        });
    }

    public static double getRadius(Iterable<? extends class_2382> blocks, class_2351 axis) {
        class_2351 axisA;
        class_2351 axisB;

        switch (axis) {
            case field_11048 -> {
                axisA = class_2351.field_11052;
                axisB = class_2351.field_11051;
            }
            case field_11052 -> {
                axisA = class_2351.field_11048;
                axisB = class_2351.field_11051;
            }
            case field_11051 -> {
                axisA = class_2351.field_11048;
                axisB = class_2351.field_11052;
            }
            default -> throw new IllegalStateException("Unexpected value: " + axis);
        }

        int maxDistSq = 0;
        for (class_2382 vec : blocks) {
            int a = vec.method_30558(axisA);
            int b = vec.method_30558(axisB);

            int distSq = a * a + b * b;

            if (distSq > maxDistSq)
                maxDistSq = distSq;
        }

        return Math.sqrt(maxDistSq);
    }

    public MountedStorageManager getStorage() {
        return this.storage;
    }

    public boolean isHiddenInPortal(class_2338 localPos) {
        return false;
    }

    public Optional<List<class_238>> getSimplifiedEntityColliders() {
        return simplifiedEntityColliders;
    }

    public void tickStorage(AbstractContraptionEntity entity) {
        getStorage().tick(entity);
    }

    public boolean containsBlockBreakers() {
        for (MutablePair<class_3501, MovementContext> pair : actors) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get(pair.getLeft().comp_1342());
            if (behaviour instanceof BlockBreakingMovementBehaviour || behaviour instanceof HarvesterMovementBehaviour)
                return true;
        }
        return false;
    }
}
