package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.api.contraption.transformable.MovedBlockTransformerRegistries;
import com.zurrtum.create.api.contraption.transformable.MovedBlockTransformerRegistries.BlockEntityTransformer;
import com.zurrtum.create.api.contraption.transformable.MovedBlockTransformerRegistries.BlockTransformer;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecs;
import com.zurrtum.create.catnip.math.VecHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_3709;
import net.minecraft.class_3867;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.state.properties.*;

import static net.minecraft.class_2741.*;

public class StructureTransform {
    public static final class_9139<class_2540, StructureTransform> STREAM_CODEC = class_9139.method_56906(
        class_2338.field_48404,
        i -> i.offset,
        class_9135.field_49675,
        i -> i.angle,
        CatnipStreamCodecBuilders.nullable(CatnipStreamCodecs.AXIS),
        i -> i.rotationAxis,
        CatnipStreamCodecBuilders.nullable(class_2470.field_55987),
        i -> i.rotation,
        CatnipStreamCodecBuilders.nullable(CatnipStreamCodecs.MIRROR),
        i -> i.mirror,
        StructureTransform::new
    );

    // Assuming structures cannot be rotated around multiple axes at once
    public class_2351 rotationAxis;
    public class_2338 offset;
    public int angle;
    public class_2470 rotation;
    public class_2415 mirror;

    private StructureTransform(class_2338 offset, int angle, class_2351 axis, class_2470 rotation, class_2415 mirror) {
        this.offset = offset;
        this.angle = angle;
        rotationAxis = axis;
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public StructureTransform(class_2338 offset, class_2351 axis, class_2470 rotation, class_2415 mirror) {
        this(offset, rotation == class_2470.field_11467 ? 0 : (4 - rotation.ordinal()) * 90, axis, rotation, mirror);
    }

    public StructureTransform(class_2338 offset, float xRotation, float yRotation, float zRotation) {
        this.offset = offset;
        if (xRotation != 0) {
            rotationAxis = class_2351.field_11048;
            angle = Math.round(xRotation / 90) * 90;
        }
        if (yRotation != 0) {
            rotationAxis = class_2351.field_11052;
            angle = Math.round(yRotation / 90) * 90;
        }
        if (zRotation != 0) {
            rotationAxis = class_2351.field_11051;
            angle = Math.round(zRotation / 90) * 90;
        }

        angle %= 360;
        if (angle < -90)
            angle += 360;

        this.rotation = class_2470.field_11467;
        if (angle == -90 || angle == 270)
            this.rotation = class_2470.field_11463;
        if (angle == 90)
            this.rotation = class_2470.field_11465;
        if (angle == 180)
            this.rotation = class_2470.field_11464;

        mirror = class_2415.field_11302;
    }

    public class_243 applyWithoutOffsetUncentered(class_243 localVec) {
        class_243 vec = localVec;
        if (mirror != null)
            vec = VecHelper.mirror(vec, mirror);
        if (rotationAxis != null)
            vec = VecHelper.rotate(vec, angle, rotationAxis);
        return vec;
    }

    public class_243 applyWithoutOffset(class_243 localVec) {
        class_243 vec = localVec;
        if (mirror != null)
            vec = VecHelper.mirrorCentered(vec, mirror);
        if (rotationAxis != null)
            vec = VecHelper.rotateCentered(vec, angle, rotationAxis);
        return vec;
    }

    public class_243 unapplyWithoutOffset(class_243 globalVec) {
        class_243 vec = globalVec;
        if (rotationAxis != null)
            vec = VecHelper.rotateCentered(vec, -angle, rotationAxis);
        if (mirror != null)
            vec = VecHelper.mirrorCentered(vec, mirror);

        return vec;
    }

    public class_243 apply(class_243 localVec) {
        return applyWithoutOffset(localVec).method_1019(class_243.method_24954(offset));
    }

    public class_2338 applyWithoutOffset(class_2338 localPos) {
        return class_2338.method_49638(applyWithoutOffset(VecHelper.getCenterOf(localPos)));
    }

    public class_2338 apply(class_2338 localPos) {
        return applyWithoutOffset(localPos).method_10081(offset);
    }

    public class_2338 unapply(class_2338 globalPos) {
        return unapplyWithoutOffset(globalPos.method_10059(offset));
    }

    public class_2338 unapplyWithoutOffset(class_2338 globalPos) {
        return class_2338.method_49638(unapplyWithoutOffset(VecHelper.getCenterOf(globalPos)));
    }

    public void apply(class_2586 be) {
        BlockEntityTransformer transformer = MovedBlockTransformerRegistries.BLOCK_ENTITY_TRANSFORMERS.get(be.method_11017());
        if (transformer != null) {
            transformer.transform(be, this);
        } else if (be instanceof TransformableBlockEntity itbe) {
            itbe.transform(be, this);
        }
    }

    /**
     * Vanilla does not support block state rotation around axes other than Y. Add
     * specific cases here for vanilla block states so that they can react to rotations
     * around horizontal axes. For Create blocks, implement ITransformableBlock.
     */
    public class_2680 apply(class_2680 state) {
        class_2248 block = state.method_26204();
        BlockTransformer transformer = MovedBlockTransformerRegistries.BLOCK_TRANSFORMERS.get(block);
        if (transformer != null) {
            return transformer.transform(state, this);
        } else if (block instanceof TransformableBlock transformable) {
            return transformable.transform(state, this);
        }

        if (mirror != null)
            state = state.method_26185(mirror);

        if (rotationAxis == class_2351.field_11052) {
            if (block instanceof class_3709) {
                if (state.method_11654(class_2741.field_17104) == class_3867.field_17101)
                    state = state.method_11657(class_2741.field_17104, class_3867.field_17100);
                return state.method_11657(class_3709.field_16324, rotation.method_10503(state.method_11654(class_3709.field_16324)));
            }

            return state.method_26186(rotation);
        }

        if (block instanceof class_2341) {
            class_2754<class_2350> facingProperty = class_2341.field_11177;
            class_2754<class_2738> faceProperty = class_2341.field_11007;
            class_2350 stateFacing = state.method_11654(facingProperty);
            class_2738 stateFace = state.method_11654(faceProperty);
            boolean z = rotationAxis == class_2351.field_11051;
            class_2350 forcedAxis = z ? class_2350.field_11039 : class_2350.field_11035;

            if (stateFacing.method_10166() == rotationAxis && stateFace == class_2738.field_12471)
                return state;

            for (int i = 0; i < rotation.ordinal(); i++) {
                stateFace = state.method_11654(faceProperty);
                stateFacing = state.method_11654(facingProperty);

                boolean b = state.method_11654(faceProperty) == class_2738.field_12473;
                state = state.method_11657(facingProperty, b ? forcedAxis : forcedAxis.method_10153());

                if (stateFace != class_2738.field_12471) {
                    state = state.method_11657(faceProperty, class_2738.field_12471);
                    continue;
                }

                if (stateFacing.method_10171() == (z ? class_2352.field_11060 : class_2352.field_11056)) {
                    state = state.method_11657(faceProperty, class_2738.field_12475);
                    continue;
                }
                state = state.method_11657(faceProperty, class_2738.field_12473);
            }

            return state;
        }

        boolean halfTurn = rotation == class_2470.field_11464;
        if (block instanceof class_2510) {
            state = transformStairs(state, halfTurn);
            return state;
        }

        if (state.method_28498(field_12525)) {
            state = state.method_11657(field_12525, rotateFacing(state.method_11654(field_12525)));
        } else if (state.method_28498(field_12496)) {
            state = state.method_11657(field_12496, rotateAxis(state.method_11654(field_12496)));
        } else if (halfTurn) {
            if (state.method_28498(field_12481)) {
                class_2350 stateFacing = state.method_11654(field_12481);
                if (stateFacing.method_10166() == rotationAxis)
                    return state;
            }

            state = state.method_26186(rotation);

            if (state.method_28498(class_2482.field_11501) && state.method_11654(class_2482.field_11501) != class_2771.field_12682)
                state = state.method_11657(class_2482.field_11501, state.method_11654(class_2482.field_11501) == class_2771.field_12681 ? class_2771.field_12679 : class_2771.field_12681);
        }

        return state;
    }

    protected class_2680 transformStairs(class_2680 state, boolean halfTurn) {
        if (state.method_11654(class_2510.field_11571).method_10166() != rotationAxis) {
            for (int i = 0; i < rotation.ordinal(); i++) {
                class_2350 direction = state.method_11654(class_2510.field_11571);
                class_2760 half = state.method_11654(class_2510.field_11572);
                if (direction.method_10171() == class_2352.field_11056 ^ half == class_2760.field_12617 ^ direction.method_10166() == class_2351.field_11051)
                    state = state.method_28493(class_2510.field_11572);
                else
                    state = state.method_11657(class_2510.field_11571, direction.method_10153());
            }
        } else {
            if (halfTurn) {
                state = state.method_28493(class_2510.field_11572);
            }
        }
        return state;
    }

    public class_2350 mirrorFacing(class_2350 facing) {
        if (mirror != null)
            return mirror.method_10343(facing);
        return facing;
    }

    public class_2351 rotateAxis(class_2351 axis) {
        class_2350 facing = class_2350.method_10156(class_2352.field_11056, axis);
        return rotateFacing(facing).method_10166();
    }

    public class_2350 rotateFacing(class_2350 facing) {
        for (int i = 0; i < rotation.ordinal(); i++)
            facing = facing.method_35833(rotationAxis);
        return facing;
    }
}
