package com.zurrtum.create.content.contraptions.actors.contraptionControls;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5250;

public class ContraptionControlsBlockEntity extends SmartBlockEntity {

    public ServerFilteringBehaviour filtering;
    public boolean disabled;
    public boolean powered;

    public LerpedFloat indicator;
    public LerpedFloat button;

    public ContraptionControlsBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CONTRAPTION_CONTROLS, pos, state);
        indicator = LerpedFloat.angular().startWithValue(0);
        button = LerpedFloat.linear().startWithValue(0).chase(0, 0.125f, Chaser.EXP);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(filtering = new ServerFilteringBehaviour(this));
        filtering.withPredicate(stack -> stack.method_31573(AllItemTags.CONTRAPTION_CONTROLLED));
    }

    public void pressButton() {
        button.setValue(1);
    }

    public void updatePoweredState() {
        if (field_11863.method_8608())
            return;
        boolean powered = field_11863.method_49803(field_11867);
        if (this.powered == powered)
            return;
        this.powered = powered;
        this.disabled = powered;
        notifyUpdate();
    }

    @Override
    public void initialize() {
        super.initialize();
        updatePoweredState();
    }

    @Override
    public void tick() {
        super.tick();
        if (!field_11863.method_8608())
            return;
        tickAnimations();
        int value = disabled ? 4 * 45 : 0;
        indicator.setValue(value);
        indicator.updateChaseTarget(value);
    }

    public void tickAnimations() {
        button.tickChaser();
        indicator.tickChaser();
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        disabled = view.method_71433("Disabled", false);
        powered = view.method_71433("Powered", false);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71472("Disabled", disabled);
        view.method_71472("Powered", powered);
    }

    public static void sendStatus(class_1657 player, class_1799 filter, boolean enabled) {
        class_5250 state = class_2561.method_43471("create.contraption.controls.actor_toggle." + (enabled ? "on" : "off"))
            .method_54663(enabled ? 0xA3DF55 : 0xEE9246);

        if (filter.method_7960()) {
            player.method_7353(class_2561.method_43469("create.contraption.controls.all_actor_toggle", state), true);
            return;
        }

        player.method_7353(
            class_2561.method_43469(
                "create.contraption.controls.specific_actor_toggle",
                filter.method_7964().getString(),
                state
            ), true
        );
    }
}