package com.zurrtum.create.content.contraptions.actors.psi;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortableItemInterfaceBlockEntity extends PortableStorageInterfaceBlockEntity {

    public final class_1263 capability;

    public PortableItemInterfaceBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.PORTABLE_STORAGE_INTERFACE, pos, state);
        capability = new InterfaceItemHandler();
    }

    @Override
    public void startTransferringTo(Contraption contraption, float distance) {
        ((InterfaceItemHandler) capability).setInventory(contraption.getStorage().getAllItems());
        if (field_11863 != null && !field_11863.method_8608()) {
            field_11863.method_8408(field_11867, method_11010().method_26204());
        }
        super.startTransferringTo(contraption, distance);
    }

    @Override
    protected void stopTransferring() {
        ((InterfaceItemHandler) capability).setEmpty();
        if (field_11863 != null && !field_11863.method_8608()) {
            field_11863.method_8408(field_11867, method_11010().method_26204());
        }
        super.stopTransferring();
    }

    class InterfaceItemHandler implements SidedItemInventory {
        private static final class_1263 EMPTY = new ItemStackHandler(0);

        private int[] slots = SlotRangeCache.EMPTY;
        private class_1263 wrapped = EMPTY;
        private boolean mark = false;

        @Override
        public int[] method_5494(class_2350 side) {
            return slots;
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            if (wrapped == EMPTY) {
                return false;
            }
            return ((class_1278) wrapped).method_5493(slot, stack, dir);
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            if (wrapped == EMPTY) {
                return false;
            }
            return ((class_1278) wrapped).method_5492(slot, stack, dir);
        }

        public void setInventory(CombinedInvWrapper wrapped) {
            this.wrapped = wrapped;
            slots = wrapped.method_5494(null);
        }

        public void setEmpty() {
            wrapped = EMPTY;
            slots = SlotRangeCache.EMPTY;
        }

        @Override
        public int method_5439() {
            return slots.length;
        }

        @Override
        public int method_5444() {
            return wrapped.method_5444();
        }

        @Override
        public int method_58350(class_1799 stack) {
            return wrapped.method_58350(stack);
        }

        @Override
        public class_1799 method_5438(int slot) {
            mark = true;
            return wrapped.method_5438(slot);
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            mark = true;
            wrapped.method_5447(slot, stack);
        }

        @Override
        public int insert(class_1799 stack, int maxAmount, class_2350 side) {
            int insert = wrapped.insert(stack, maxAmount, side);
            if (insert != 0) {
                method_5431();
            }
            return insert;
        }

        @Override
        public int extract(class_1799 stack, int maxAmount, class_2350 side) {
            int extract = wrapped.extract(stack, maxAmount, side);
            if (extract != 0) {
                method_5431();
            }
            return extract;
        }

        @Override
        public void method_5431() {
            onContentTransferred();
            if (mark) {
                mark = false;
                wrapped.method_5431();
            }
        }

        @Override
        public @NotNull java.util.Iterator<class_1799> iterator(class_2350 side) {
            return wrapped.iterator(side);
        }
    }

}
