package com.zurrtum.create.content.decoration;

import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.infrastructure.config.AllConfigs;

import java.util.function.Predicate;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2399;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class MetalLadderBlock extends class_2399 implements IWrenchable {

    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public MetalLadderBlock(class_2251 p_54345_) {
        super(p_54345_);
    }

    //TODO
    //    public boolean supportsExternalFaceHiding(BlockState state) {
    //        return false;
    //    }

    @Override
    public boolean method_9522(class_2680 pState, class_2680 pAdjacentBlockState, class_2350 pDirection) {
        if (pDirection != null && pDirection.method_10166().method_10179())
            return pAdjacentBlockState.method_26215() || !pAdjacentBlockState.method_51366();
        return pDirection == class_2350.field_11036 && pAdjacentBlockState.method_26204() instanceof class_2399;
    }

    @Override
    public class_265 method_9571(class_2680 pState) {
        return AllShapes.SIX_VOXEL_POLE.get(class_2351.field_11052);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pFacing,
        class_2338 pFacingPos,
        class_2680 pFacingState,
        class_5819 random
    ) {
        if (!pState.method_26184(pLevel, pCurrentPos))
            return class_2246.field_10124.method_9564();
        return super.method_9559(pState, pLevel, tickView, pCurrentPos, pFacing, pFacingPos, pFacingState, random);
    }

    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        class_2680 otherState = pLevel.method_8320(pPos.method_10093(class_2350.field_11036));
        return super.method_9558(pState, pLevel, pPos) || (otherState.method_27852(this) && pState.method_11654(field_11253).equals(otherState.method_11654(field_11253)));
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player.method_5715() || !player.method_7294())
            return class_1269.field_52423;
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(stack))
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);
        return class_1269.field_52423;
    }

    private static class PlacementHelper implements IPlacementHelper {

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return i -> i.method_7909() instanceof class_1747 item && item.method_7711() instanceof MetalLadderBlock;
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return s -> s.method_26204() instanceof class_2399;
        }

        public int attachedLadders(class_1937 world, class_2338 pos, class_2350 direction) {
            class_2338 checkPos = pos.method_10093(direction);
            class_2680 state = world.method_8320(checkPos);
            int count = 0;
            while (getStatePredicate().test(state)) {
                count++;
                checkPos = checkPos.method_10093(direction);
                state = world.method_8320(checkPos);
            }
            return count;
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350 dir = player.method_36455() < 0 ? class_2350.field_11036 : class_2350.field_11033;

            int range = AllConfigs.server().equipment.placementAssistRange.get();
            if (player != null) {
                class_1324 reach = player.method_5996(class_5134.field_47758);
                if (reach != null && reach.method_6196(ExtendoGripItem.singleRangeAttributeModifier.comp_2447()))
                    range += 4;
            }

            int ladders = attachedLadders(world, pos, dir);
            if (ladders >= range)
                return PlacementOffset.fail();

            class_2338 newPos = pos.method_10079(dir, ladders + 1);
            class_2680 newState = world.method_8320(newPos);

            if (!state.method_26184(world, newPos))
                return PlacementOffset.fail();

            if (newState.method_45474())
                return PlacementOffset.success(newPos, bState -> bState.method_11657(field_11253, state.method_11654(field_11253)));
            return PlacementOffset.fail();
        }

    }

}
