package com.zurrtum.create.content.decoration.slidingDoor;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.contraptions.ContraptionWorld;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8177;
import net.minecraft.class_9904;
import net.minecraft.world.level.*;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;

public class SlidingDoorBlock extends class_2323 implements IWrenchable, IBE<SlidingDoorBlockEntity> {

    public static final Supplier<class_8177> TRAIN_SET_TYPE = () -> new class_8177(
        "create:train",
        true,
        true,
        true,
        class_8177.class_2441.field_11361,
        class_2498.field_22150,
        class_3417.field_14819,
        class_3417.field_14567,
        class_3417.field_15131,
        class_3417.field_15082,
        class_3417.field_15100,
        class_3417.field_14988,
        class_3417.field_14954,
        class_3417.field_14791
    );

    public static final Supplier<class_8177> GLASS_SET_TYPE = () -> new class_8177(
        "create:glass",
        true,
        true,
        true,
        class_8177.class_2441.field_11361,
        class_2498.field_11537,
        class_3417.field_14819,
        class_3417.field_14567,
        class_3417.field_15131,
        class_3417.field_15082,
        class_3417.field_15100,
        class_3417.field_14988,
        class_3417.field_14954,
        class_3417.field_14791
    );
    public static final Supplier<class_8177> STONE_SET_TYPE = () -> new class_8177(
        "create:stone",
        true,
        true,
        true,
        class_8177.class_2441.field_11361,
        class_2498.field_11544,
        class_3417.field_14819,
        class_3417.field_14567,
        class_3417.field_15131,
        class_3417.field_15082,
        class_3417.field_15100,
        class_3417.field_14988,
        class_3417.field_14954,
        class_3417.field_14791
    );

    public static final class_2746 VISIBLE = class_2746.method_11825("visible");
    private final boolean folds;

    public static SlidingDoorBlock metal_fold(class_2251 settings) {
        return new SlidingDoorBlock(settings, TRAIN_SET_TYPE.get(), true);
    }

    public static SlidingDoorBlock metal_slide(class_2251 settings) {
        return new SlidingDoorBlock(settings, TRAIN_SET_TYPE.get(), false);
    }

    public static SlidingDoorBlock glass_slide(class_2251 settings) {
        return new SlidingDoorBlock(settings, GLASS_SET_TYPE.get(), false);
    }

    public static SlidingDoorBlock stone_fold(class_2251 settings) {
        return new SlidingDoorBlock(settings, STONE_SET_TYPE.get(), true);
    }

    public static SlidingDoorBlock stone_slide(class_2251 settings) {
        return new SlidingDoorBlock(settings, STONE_SET_TYPE.get(), false);
    }

    public SlidingDoorBlock(class_2251 properties, class_8177 type, boolean folds) {
        super(type, properties);
        this.folds = folds;
    }

    public boolean isFoldingDoor() {
        return folds;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(VISIBLE));
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        if (!pState.method_11654(field_10945) && (pState.method_11654(VISIBLE) || pLevel instanceof ContraptionWorld))
            return super.method_9530(pState, pLevel, pPos, pContext);

        class_2350 direction = pState.method_11654(field_10938);
        boolean hinge = pState.method_11654(field_10941) == class_2750.field_12586;
        return SlidingDoorShapes.get(direction, hinge, isFoldingDoor());
    }

    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return pState.method_11654(field_10946) == class_2756.field_12607 || pLevel.method_8320(pPos.method_10074()).method_27852(this);
    }

    @Override
    public class_265 method_9584(class_2680 pState, class_1922 pLevel, class_2338 pPos) {
        return method_9530(pState, pLevel, pPos, class_3726.method_16194());
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 stateForPlacement = super.method_9605(pContext);
        if (stateForPlacement != null && stateForPlacement.method_11654(field_10945))
            return stateForPlacement.method_11657(field_10945, false).method_11657(field_10940, false);
        return stateForPlacement;
    }

    @Override
    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        if (!pOldState.method_27852(this))
            deferUpdate(pLevel, pPos);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pFacing,
        class_2338 pFacingPos,
        class_2680 pFacingState,
        class_5819 random
    ) {
        class_2680 blockState = super.method_9559(pState, pLevel, tickView, pCurrentPos, pFacing, pFacingPos, pFacingState, random);
        if (blockState.method_26215())
            return blockState;
        class_2756 doubleblockhalf = blockState.method_11654(field_10946);
        if (pFacing.method_10166() == class_2350.class_2351.field_11052 && doubleblockhalf == class_2756.field_12607 == (pFacing == class_2350.field_11036)) {
            return pFacingState.method_27852(this) && pFacingState.method_11654(field_10946) != doubleblockhalf ? blockState.method_11657(
                VISIBLE,
                pFacingState.method_11654(VISIBLE)
            ) : class_2246.field_10124.method_9564();
        }
        return blockState;
    }

    @Override
    public void method_10033(@Nullable class_1297 entity, class_1937 level, class_2680 state, class_2338 pos, boolean open) {
        if (!state.method_27852(this))
            return;
        if (state.method_11654(field_10945) == open)
            return;
        class_2680 changedState = state.method_11657(field_10945, open);
        if (open)
            changedState = changedState.method_11657(VISIBLE, false);
        level.method_8652(pos, changedState, class_2248.field_31028 | class_2248.field_31030);

        class_2750 hinge = changedState.method_11654(field_10941);
        class_2350 facing = changedState.method_11654(field_10938);
        class_2338 otherPos = pos.method_10093(hinge == class_2750.field_12588 ? facing.method_10170() : facing.method_10160());
        class_2680 otherDoor = level.method_8320(otherPos);
        if (isDoubleDoor(changedState, hinge, facing, otherDoor))
            method_10033(entity, level, otherDoor, otherPos, open);

        this.method_10036(entity, level, pos, open);
        level.method_33596(entity, open ? class_5712.field_28168 : class_5712.field_28169, pos);
    }

    @Override
    public void method_9612(
        class_2680 pState,
        class_1937 pLevel,
        class_2338 pPos,
        class_2248 pBlock,
        @Nullable class_9904 wireOrientation,
        boolean pIsMoving
    ) {
        boolean lower = pState.method_11654(field_10946) == class_2756.field_12607;
        boolean isPowered = isDoorPowered(pLevel, pPos, pState);
        if (method_9564().method_27852(pBlock))
            return;
        if (isPowered == pState.method_11654(field_10940))
            return;

        SlidingDoorBlockEntity be = getBlockEntity(pLevel, lower ? pPos : pPos.method_10074());
        if (be != null && be.deferUpdate)
            return;

        class_2680 changedState = pState.method_11657(field_10940, isPowered).method_11657(field_10945, isPowered);
        if (isPowered)
            changedState = changedState.method_11657(VISIBLE, false);

        if (isPowered != pState.method_11654(field_10945)) {
            this.method_10036(null, pLevel, pPos, isPowered);
            pLevel.method_33596(null, isPowered ? class_5712.field_28168 : class_5712.field_28169, pPos);

            class_2750 hinge = changedState.method_11654(field_10941);
            class_2350 facing = changedState.method_11654(field_10938);
            class_2338 otherPos = pPos.method_10093(hinge == class_2750.field_12588 ? facing.method_10170() : facing.method_10160());
            class_2680 otherDoor = pLevel.method_8320(otherPos);

            if (isDoubleDoor(changedState, hinge, facing, otherDoor)) {
                otherDoor = otherDoor.method_11657(field_10940, isPowered).method_11657(field_10945, isPowered);
                if (isPowered)
                    otherDoor = otherDoor.method_11657(VISIBLE, false);
                pLevel.method_8652(otherPos, otherDoor, class_2248.field_31028);
            }
        }

        pLevel.method_8652(pPos, changedState, class_2248.field_31028);
    }

    public static boolean isDoorPowered(class_1937 pLevel, class_2338 pPos, class_2680 state) {
        boolean lower = state.method_11654(field_10946) == class_2756.field_12607;
        class_2750 hinge = state.method_11654(field_10941);
        class_2350 facing = state.method_11654(field_10938);
        class_2338 otherPos = pPos.method_10093(hinge == class_2750.field_12588 ? facing.method_10170() : facing.method_10160());
        class_2680 otherDoor = pLevel.method_8320(otherPos);

        if (isDoubleDoor(
            state.method_28493(field_10945),
            hinge,
            facing,
            otherDoor
        ) && (pLevel.method_49803(otherPos) || pLevel.method_49803(otherPos.method_10093(lower ? class_2350.field_11036 : class_2350.field_11033))))
            return true;

        return pLevel.method_49803(pPos) || pLevel.method_49803(pPos.method_10093(lower ? class_2350.field_11036 : class_2350.field_11033));
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        state = state.method_28493(field_10945);
        boolean isOpen = state.method_11654(field_10945);
        if (isOpen)
            state = state.method_11657(VISIBLE, false);
        level.method_8652(pos, state, class_2248.field_31028 | class_2248.field_31030);
        level.method_33596(player, method_30841(state) ? class_5712.field_28168 : class_5712.field_28169, pos);

        class_2750 hinge = state.method_11654(field_10941);
        class_2350 facing = state.method_11654(field_10938);
        class_2338 otherPos = pos.method_10093(hinge == class_2750.field_12588 ? facing.method_10170() : facing.method_10160());
        class_2680 otherDoor = level.method_8320(otherPos);
        if (isDoubleDoor(state, hinge, facing, otherDoor))
            method_55766(otherDoor, level, otherPos, player, hitResult);
        else if (isOpen) {
            this.method_10036(player, level, pos, true);
            level.method_33596(player, class_5712.field_28168, pos);
        }

        return class_1269.field_5812;
    }

    public void deferUpdate(class_1936 level, class_2338 pos) {
        withBlockEntityDo(level, pos, sdte -> sdte.deferUpdate = true);
    }

    public static boolean isDoubleDoor(class_2680 pState, class_2750 hinge, class_2350 facing, class_2680 otherDoor) {
        return otherDoor.method_26204() == pState.method_26204() && otherDoor.method_11654(field_10941) != hinge && otherDoor.method_11654(field_10938) == facing && otherDoor.method_11654(
            field_10945) != pState.method_11654(field_10945) && otherDoor.method_11654(field_10946) == pState.method_11654(field_10946);
    }

    @Override
    public class_2464 method_9604(class_2680 pState) {
        return pState.method_11654(VISIBLE) ? class_2464.field_11458 : class_2464.field_11455;
    }

    private void method_10036(@Nullable class_1297 pSource, class_1937 pLevel, class_2338 pPos, boolean pIsOpening) {
        pLevel.method_8396(
            pSource,
            pPos,
            pIsOpening ? class_3417.field_14567 : class_3417.field_14819,
            class_3419.field_15245,
            1.0F,
            pLevel.method_8409().method_43057() * 0.1F + 0.9F
        );
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(field_10946) == class_2756.field_12609)
            return null;
        return IBE.super.method_10123(pos, state);
    }

    @Override
    public Class<SlidingDoorBlockEntity> getBlockEntityClass() {
        return SlidingDoorBlockEntity.class;
    }

    @Override
    public class_2591<? extends SlidingDoorBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.SLIDING_DOOR;
    }

}
