package com.zurrtum.create.content.equipment.armor;

import com.zurrtum.create.*;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import it.unimi.dsi.fastutil.objects.Object2IntMap.Entry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9304;

public class BacktankUtil {

    private static final List<Function<class_1309, List<class_1799>>> BACKTANK_SUPPLIERS = new ArrayList<>();

    static {
        addBacktankSupplier(entity -> {
            List<class_1799> stacks = new ArrayList<>();
            for (class_1304 equipmentSlot : class_9274.field_49224) {
                if (equipmentSlot == class_1304.field_48824) {
                    continue;
                }
                class_1799 stack = entity.method_6118(equipmentSlot);
                if (stack.method_41409().method_40220(AllItemTags.PRESSURIZED_AIR_SOURCES)) {
                    stacks.add(stack);
                }
            }
            return stacks;
        });
    }

    public static List<class_1799> getAllWithAir(class_1309 entity) {
        List<class_1799> all = new ArrayList<>();

        for (Function<class_1309, List<class_1799>> supplier : BACKTANK_SUPPLIERS) {
            List<class_1799> result = supplier.apply(entity);

            for (class_1799 stack : result)
                if (hasAirRemaining(stack))
                    all.add(stack);
        }

        // Sort with ascending order (we want to prioritize the most empty so things actually run out)
        all.sort((a, b) -> Float.compare(getAir(a), getAir(b)));

        return all;
    }

    public static boolean hasAirRemaining(class_1799 backtank) {
        return getAir(backtank) > 0;
    }

    public static int getAir(class_1799 backtank) {
        return Math.min(backtank.method_58695(AllDataComponents.BACKTANK_AIR, 0), maxAir(backtank));
    }

    public static void consumeAir(class_1309 entity, class_1799 backtank, int i) {
        int maxAir = maxAir(backtank);
        int air = getAir(backtank);
        int newAir = Math.max(air - i, 0);
        backtank.method_57379(AllDataComponents.BACKTANK_AIR, Math.min(newAir, maxAir));

        if (!(entity instanceof class_3222 player))
            return;

        sendWarning(player, air, newAir, maxAir / 10f);
        sendWarning(player, air, newAir, 1);
    }

    private static void sendWarning(class_3222 player, float air, float newAir, float threshold) {
        if (newAir > threshold)
            return;
        if (air <= threshold)
            return;

        boolean depleted = threshold == 1;
        class_5250 component = class_2561.method_43471(depleted ? "create.backtank.depleted" : "create.backtank.low");

        AllSoundEvents.DENY.play(player.method_51469(), null, player.method_24515(), 1, 1.25f);
        AllSoundEvents.STEAM.play(player.method_51469(), null, player.method_24515(), .5f, .5f);

        player.field_13987.method_14364(new class_5905(10, 40, 10));
        player.field_13987.method_14364(new class_5903(class_2561.method_43470("\u26A0 ")
            .method_27692(depleted ? class_124.field_1061 : class_124.field_1065).method_10852(component.method_27692(class_124.field_1080))));
        player.field_13987.method_14364(new class_5904(class_5244.field_39003));
    }

    public static int maxAir(class_1799 backtank) {
        int enchantLevel = 0;
        class_9304 enchants = backtank.method_58657();
        for (Entry<class_6880<class_1887>> entry : enchants.method_57539()) {
            if (entry.getKey().method_40225(AllEnchantments.CAPACITY)) {
                enchantLevel = entry.getIntValue();
                break;
            }
        }
        return maxAir(enchantLevel);
    }

    public static int maxAir(int enchantLevel) {
        return AllConfigs.server().equipment.airInBacktank.get() + AllConfigs.server().equipment.enchantedBacktankCapacity.get() * enchantLevel;
    }

    public static int maxAirWithoutEnchants() {
        return AllConfigs.server().equipment.airInBacktank.get();
    }

    public static boolean canAbsorbDamage(class_1309 entity, int usesPerTank) {
        if (usesPerTank == 0)
            return true;
        if (entity instanceof class_1657 playerEntity && playerEntity.method_68878())
            return true;
        List<class_1799> backtanks = getAllWithAir(entity);
        if (backtanks.isEmpty())
            return false;
        int cost = Math.max(maxAirWithoutEnchants() / usesPerTank, 1);
        consumeAir(entity, backtanks.getFirst(), cost);
        return true;
    }

    // For Air-using tools

    public static boolean isBarVisible(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0)
            return false;
        class_1657 player = AllClientHandle.INSTANCE.getPlayer();
        if (player == null)
            return false;
        List<class_1799> backtanks = getAllWithAir(player);
        if (backtanks.isEmpty())
            return stack.method_7986();
        return true;
    }

    public static int getBarWidth(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0)
            return 13;
        class_1657 player = AllClientHandle.INSTANCE.getPlayer();
        if (player == null)
            return 13;

        List<class_1799> backtanks = getAllWithAir(player);

        if (backtanks.isEmpty())
            return Math.round(13.0F - (float) stack.method_7919() / stack.method_7936() * 13.0F);

        if (backtanks.size() == 1)
            return backtanks.getFirst().method_7909().method_31569(backtanks.getFirst());

        // If there is more than one backtank, average the bar widths.
        int sumBarWidth = backtanks.stream().map(backtank -> backtank.method_7909().method_31569(backtank)).reduce(0, Integer::sum);

        return Math.round((float) sumBarWidth / backtanks.size());
    }

    public static int getBarColor(class_1799 stack, int usesPerTank) {
        if (usesPerTank == 0)
            return 0;
        class_1657 player = AllClientHandle.INSTANCE.getPlayer();
        if (player == null)
            return 0;
        List<class_1799> backtanks = getAllWithAir(player);

        // Fallback colour
        if (backtanks.isEmpty())
            return class_3532.method_15369(Math.max(0.0F, 1.0F - (float) stack.method_7919() / stack.method_7936()) / 3.0F, 1.0F, 1.0F);

        // Just return the "first" backtank for the bar color since that's the one we are consuming from
        return backtanks.getFirst().method_7909().method_31571(backtanks.getFirst());
    }

    /**
     * Use this method to add custom entry points to the backtank item stack supplier, e.g. getting them from custom
     * slots or items.
     */
    public static void addBacktankSupplier(Function<class_1309, List<class_1799>> supplier) {
        BACKTANK_SUPPLIERS.add(supplier);
    }
}
