package com.zurrtum.create.content.equipment.blueprint;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity.BlueprintSection;
import com.zurrtum.create.foundation.gui.menu.GhostItemMenu;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;

import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2653;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9694;

public class BlueprintMenu extends GhostItemMenu<BlueprintSection> {
    public BlueprintMenu(int id, class_1661 inv, BlueprintSection section) {
        super(AllMenuTypes.CRAFTING_BLUEPRINT, id, inv, section);
    }

    @Override
    protected boolean allowRepeats() {
        return true;
    }

    @Override
    protected void addSlots() {
        addPlayerSlots(8, 131);

        int x = 29;
        int y = 21;
        int index = 0;
        for (int row = 0; row < 3; ++row)
            for (int col = 0; col < 3; ++col)
                this.method_7621(new BlueprintCraftSlot(ghostInventory, index++, x + col * 18, y + row * 18));

        method_7621(new BlueprintCraftSlot(ghostInventory, index++, 123, 40));
        method_7621(new class_1735(ghostInventory, index++, 135, 57));
    }

    public void onCraftMatrixChanged() {
        class_1937 level = contentHolder.getBlueprintWorld();
        if (level.method_8608())
            return;

        class_3222 serverplayerentity = (class_3222) player;
        class_9694 input = class_9694.method_59986(3, 3, ghostInventory.getStacks().subList(0, 9));
        Optional<class_8786<class_3955>> optional = ((class_3218) level).method_64577().method_8132(class_3956.field_17545, input, level);

        if (optional.isEmpty()) {
            if (ghostInventory.method_5438(9).method_7960())
                return;
            if (!contentHolder.inferredIcon)
                return;

            ghostInventory.method_5447(9, class_1799.field_8037);
            serverplayerentity.field_13987.method_14364(new class_2653(field_7763, method_37422(), 45, class_1799.field_8037));
            contentHolder.inferredIcon = false;
            return;
        }

        class_3955 icraftingrecipe = optional.get().comp_1933();
        class_1799 itemstack = icraftingrecipe.method_8116(input, level.method_30349());
        ghostInventory.method_5447(9, itemstack);
        contentHolder.inferredIcon = true;
        class_1799 toSend = itemstack.method_7972();
        toSend.method_57379(AllDataComponents.INFERRED_FROM_RECIPE, true);
        serverplayerentity.field_13987.method_14364(new class_2653(field_7763, method_37422(), 45, toSend));
    }

    @Override
    public void method_7619(int slotId, int stateId, class_1799 stack) {
        if (slotId == 45) {
            contentHolder.inferredIcon = stack.method_58695(AllDataComponents.INFERRED_FROM_RECIPE, false);
            stack.method_57381(AllDataComponents.INFERRED_FROM_RECIPE);
        }
        super.method_7619(slotId, stateId, stack);
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return contentHolder.getItems();
    }

    @Override
    protected void initAndReadInventory(BlueprintSection contentHolder) {
        super.initAndReadInventory(contentHolder);
    }

    @Override
    protected void saveData(BlueprintSection contentHolder) {
        contentHolder.save(ghostInventory);
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return contentHolder != null && contentHolder.canPlayerUse(player);
    }

    class BlueprintCraftSlot extends class_1735 {
        public BlueprintCraftSlot(class_1263 itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        @Override
        public void method_7668() {
            super.method_7668();
            int index = method_34266();
            if (index == 9) {
                if (method_7681() && !contentHolder.getBlueprintWorld().method_8608()) {
                    contentHolder.inferredIcon = false;
                    class_3222 serverplayerentity = (class_3222) player;
                    serverplayerentity.field_13987.method_14364(new class_2653(field_7763, method_37422(), 45, method_7677()));
                }
            } else if (index < 9) {
                onCraftMatrixChanged();
            }
        }

    }

}
