package com.zurrtum.create.content.equipment.clipboard;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4844;
import net.minecraft.class_9323;

public class ClipboardBlockEntity extends SmartBlockEntity {
    private UUID lastEdit;

    public ClipboardBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CLIPBOARD, pos, state);
    }

    @Override
    public void initialize() {
        super.initialize();
        updateWrittenState();
    }

    public void onEditedBy(class_1657 player) {
        lastEdit = player.method_5667();
        notifyUpdate();
        updateWrittenState();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (field_11863.method_8608())
            AllClientHandle.INSTANCE.advertiseToAddressHelper(this);
    }

    public void updateWrittenState() {
        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.CLIPBOARD))
            return;
        if (field_11863.method_8608())
            return;
        boolean isWritten = blockState.method_11654(ClipboardBlock.WRITTEN);
        boolean shouldBeWritten = method_58693().method_57832(AllDataComponents.CLIPBOARD_CONTENT);
        if (isWritten == shouldBeWritten)
            return;
        field_11863.method_8501(field_11867, blockState.method_11657(ClipboardBlock.WRITTEN, shouldBeWritten));
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket) {
            view.method_71468("components", class_9323.field_50234, method_58693());
        }
        if (lastEdit != null)
            view.method_71468("LastEdit", class_4844.field_25122, lastEdit);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            view.method_71426("components", class_9323.field_50234).ifPresent(this::method_58684);
            UUID lastEdit = view.method_71426("LastEdit", class_4844.field_25122).orElse(null);
            AllClientHandle.INSTANCE.updateClipboardScreen(
                lastEdit,
                field_11867,
                method_58693().method_58695(AllDataComponents.CLIPBOARD_CONTENT, ClipboardContent.EMPTY)
            );
        }
    }
}
