package com.zurrtum.create.content.equipment.potatoCannon;

import com.zurrtum.create.*;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoCannonProjectileType;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.zurrtum.create.api.registry.CreateRegistryKeys;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes.StuckToEntity;
import com.zurrtum.create.infrastructure.packet.s2c.NbtSpawnPacket;
import com.zurrtum.create.infrastructure.particle.AirParticleData;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2668;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8942;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotatoProjectileEntity extends class_1668 {

    protected PotatoCannonProjectileType type;
    protected class_1799 stack = class_1799.field_8037;

    protected class_1297 stuckEntity;
    protected class_243 stuckOffset;
    protected PotatoProjectileRenderMode stuckRenderer;
    protected double stuckFallSpeed;

    protected float additionalDamageMult = 1;
    protected float additionalKnockback = 0;
    protected float recoveryChance = 0;

    public PotatoProjectileEntity(class_1299<? extends class_1668> type, class_1937 level) {
        super(type, level);
    }

    public void setItem(class_1799 stack) {
        this.stack = stack;
        class_5455 registryManager = method_56673();
        type = PotatoCannonProjectileType.getTypeForItem(registryManager, stack.method_7909())
            .orElseGet(() -> registryManager.method_30530(CreateRegistryKeys.POTATO_PROJECTILE_TYPE).method_46747(AllPotatoProjectileTypes.FALLBACK))
            .comp_349();
    }

    public void setEnchantmentEffectsFromCannon(class_1799 cannon) {
        class_2378<class_1887> enchantmentRegistry = method_56673().method_30530(class_7924.field_41265);

        int recovery = cannon.method_58657().method_57536(enchantmentRegistry.method_46747(AllEnchantments.POTATO_RECOVERY));

        if (recovery > 0)
            recoveryChance = .125f + recovery * .125f;
    }

    public class_1799 getItem() {
        return stack;
    }

    @Nullable
    public PotatoCannonProjectileType getProjectileType() {
        return type;
    }

    @Override
    public void method_5749(class_11368 view) {
        setItem(view.method_71426("Item", class_1799.field_24671).orElse(class_1799.field_8037));
        additionalDamageMult = view.method_71423("AdditionalDamage", 0);
        additionalKnockback = view.method_71423("AdditionalKnockback", 0);
        recoveryChance = view.method_71423("Recovery", 0);
        super.method_5749(view);
    }

    @Override
    public void method_5652(class_11372 view) {
        if (!stack.method_7960()) {
            view.method_71468("Item", class_1799.field_24671, stack);
        }
        view.method_71464("AdditionalDamage", additionalDamageMult);
        view.method_71464("AdditionalKnockback", additionalKnockback);
        view.method_71464("Recovery", recoveryChance);
        super.method_5652(view);
    }

    @Nullable
    public class_1297 getStuckEntity() {
        if (stuckEntity == null)
            return null;
        if (!stuckEntity.method_5805())
            return null;
        return stuckEntity;
    }

    public void setStuckEntity(class_1297 stuckEntity) {
        this.stuckEntity = stuckEntity;
        this.stuckOffset = method_73189().method_1020(stuckEntity.method_73189());
        this.stuckRenderer = new StuckToEntity(stuckOffset);
        this.stuckFallSpeed = 0.0;
        method_18799(class_243.field_1353);
    }

    public PotatoProjectileRenderMode getRenderMode() {
        if (getStuckEntity() != null)
            return stuckRenderer;

        return type.renderMode();
    }

    @Override
    public void method_5773() {
        class_1297 stuckEntity = getStuckEntity();
        if (stuckEntity != null) {
            if (method_23318() < stuckEntity.method_23318() - 0.1) {
                pop(method_73189());
                if (method_73183() instanceof class_3218 serverWorld) {
                    method_5768(serverWorld);
                }
            } else {
                stuckFallSpeed += 0.007 * type.gravityMultiplier();
                stuckOffset = stuckOffset.method_1031(0, -stuckFallSpeed, 0);
                class_243 pos = stuckEntity.method_73189().method_1019(stuckOffset);
                method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            }
        } else {
            method_18799(method_18798().method_1031(0, -0.05 * type.gravityMultiplier(), 0).method_1021(type.drag()));
        }

        super.method_5773();
    }

    @Override
    protected float method_7466() {
        return 1;
    }

    @Override
    protected class_2394 method_7467() {
        return new AirParticleData(1, 10);
    }

    @Override
    protected boolean method_7468() {
        return false;
    }

    @Override
    public boolean method_5863() {
        return true;
    }

    @Override
    protected void method_7454(class_3966 ray) {
        super.method_7454(ray);

        if (getStuckEntity() != null)
            return;

        class_243 hit = ray.method_17784();
        class_1297 target = ray.method_17782();
        float damage = type.damage() * additionalDamageMult;
        float knockback = type.knockback() + additionalKnockback;
        class_1297 owner = this.method_24921();

        if (!target.method_5805())
            return;
        if (owner instanceof class_1309 entity)
            entity.method_6114(target);

        if (target instanceof PotatoProjectileEntity ppe) {
            if (field_6012 < 10 && target.field_6012 < 10)
                return;
            if (ppe.getProjectileType() != getProjectileType()) {
                if (owner instanceof class_3222 p)
                    AllAdvancements.POTATO_CANNON_COLLIDE.trigger(p);
                if (ppe.method_24921() instanceof class_3222 p)
                    AllAdvancements.POTATO_CANNON_COLLIDE.trigger(p);
            }
        }

        pop(hit);

        if (target instanceof class_1528 wither && wither.method_6872())
            return;
        if (type.preEntityHit(stack, ray))
            return;

        boolean targetIsEnderman = target.method_5864() == class_1299.field_6091;
        int k = target.method_20802();
        if (this.method_5809() && !targetIsEnderman)
            target.method_5639(5);

        class_1937 world = method_73183();
        boolean onServer = !world.method_8608();
        class_1282 damageSource = causePotatoDamage();
        if (onServer && !target.method_64397((class_3218) world, damageSource, damage)) {
            target.method_20803(k);
            method_5768((class_3218) world);
            return;
        }

        if (targetIsEnderman)
            return;

        if (!type.onEntityHit(stack, ray) && onServer) {
            if (field_5974.method_43058() <= recoveryChance) {
                recoverItem();
            } else {
                method_5775((class_3218) world, type.dropStack());
            }
        }

        if (!(target instanceof class_1309 livingentity)) {
            playHitSound(world, method_73189());
            if (onServer) {
                method_5768((class_3218) world);
            }
            return;
        }

        if (type.reloadTicks() < 10)
            livingentity.field_6008 = type.reloadTicks() + 10;

        if (onServer && knockback > 0) {
            class_243 appliedMotion = method_18798().method_18805(1.0D, 0.0D, 1.0D).method_1029();
            if (appliedMotion.method_1027() > 0.0D)
                livingentity.method_6005(knockback * 0.6, -appliedMotion.field_1352, -appliedMotion.field_1350);
        }

        if (onServer && owner instanceof class_1309) {
            class_1890.method_60107((class_3218) world, livingentity, damageSource);
        }

        if (livingentity != owner && livingentity instanceof class_1657 && owner instanceof class_3222 serverPlayer && !this.method_5701()) {
            serverPlayer.field_13987.method_14364(new class_2668(
                class_2668.field_25651,
                class_2668.field_33328
            ));
        }

        if (onServer && owner instanceof class_3222 serverplayerentity) {
            if (!target.method_5805() && target.method_5864().method_5891() == class_1311.field_6302 || (target instanceof class_1657 && target != owner))
                AllAdvancements.POTATO_CANNON.trigger(serverplayerentity);
        }

        if (type.sticky() && target.method_5805()) {
            setStuckEntity(target);
        } else if (onServer) {
            method_5768((class_3218) world);
        }

    }

    private void recoverItem() {
        if (!stack.method_7960() && method_73183() instanceof class_3218 serverWorld)
            method_5775(serverWorld, stack.method_46651(1));
    }

    public static void playHitSound(class_1937 world, class_243 location) {
        AllSoundEvents.POTATO_HIT.playOnServer(world, class_2338.method_49638(location));
    }

    public static void playLaunchSound(class_1937 world, class_243 location, float pitch) {
        AllSoundEvents.FWOOMP.playAt(world, location, 1, pitch, true);
    }

    @Override
    protected void method_24920(class_3965 ray) {
        class_243 hit = ray.method_17784();
        pop(hit);
        class_1937 world = method_73183();
        if (!type.onBlockHit(world, stack, ray) && !world.method_8608()) {
            if (field_5974.method_43058() <= recoveryChance) {
                recoverItem();
            } else {
                method_5775((class_3218) world, getProjectileType().dropStack());
            }
        }

        super.method_24920(ray);
        if (world instanceof class_3218 serverWorld) {
            method_5768(serverWorld);
        }
    }

    @Override
    public boolean method_64397(class_3218 world, @NotNull class_1282 source, float amt) {
        if (source.method_48789(class_8103.field_42246))
            return false;
        if (method_64421(source))
            return false;
        pop(method_73189());
        method_5768(world);
        return true;
    }

    private void pop(class_243 hit) {
        if (!stack.method_7960()) {
            for (int i = 0; i < 7; i++) {
                class_243 m = VecHelper.offsetRandomly(class_243.field_1353, this.field_5974, .25f);
                method_73183().method_8406(new class_2392(class_2398.field_11218, stack), hit.field_1352, hit.field_1351, hit.field_1350, m.field_1352, m.field_1351, m.field_1350);
            }
        }
        if (!method_73183().method_8608())
            playHitSound(method_73183(), method_73189());
    }

    private class_1282 causePotatoDamage() {
        return AllDamageSources.get(method_73183()).potatoCannon(this, method_24921());
    }

    @Override
    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(method_71370(), Create.LOGGER)) {
            class_11362 view = class_11362.method_71459(logging, method_56673());
            method_5652(view);
            return new NbtSpawnPacket(this, entityTrackerEntry, view.method_71475());
        }
    }

    @Override
    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        class_2487 nbt = ((NbtSpawnPacket) packet).getNbt();
        if (nbt == null) {
            return;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(method_71370(), Create.LOGGER)) {
            method_5749(class_11352.method_71417(logging, method_56673(), nbt));
        }
    }
}
