package com.zurrtum.create.content.equipment.wrench;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VoxelShaper;
import com.zurrtum.create.content.kinetics.base.*;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public interface IWrenchable {

    static void playRemoveSound(class_1937 level, class_2338 pos) {
        AllSoundEvents.WRENCH_REMOVE.playOnServer(level, pos, 1, level.field_9229.method_43057() * .5f + .5f);
    }

    static void playRotateSound(class_1937 level, class_2338 pos) {
        AllSoundEvents.WRENCH_ROTATE.playOnServer(level, pos, 1, level.field_9229.method_43057() + .5f);
    }

    default class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 rotated = getRotatedBlockState(state, context.method_8038());
        if (!rotated.method_26184(level, context.method_8037()))
            return class_1269.field_5811;

        KineticBlockEntity.switchToBlockState(level, pos, updateAfterWrenched(rotated, context));

        if (level.method_8320(pos) != state)
            playRotateSound(level, pos);

        return class_1269.field_5812;
    }

    default class_2680 updateAfterWrenched(class_2680 newState, class_1838 context) {
        //		return newState;
        return class_2248.method_9510(newState, context.method_8045(), context.method_8037());
    }

    default class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();

        if (!(world instanceof class_3218 serverLevel))
            return class_1269.field_5812;

        class_2586 be = world.method_8321(pos);
        //TODO
        //        boolean shouldBreak = PlayerBlockBreakEvents.BEFORE.invoker().beforeBlockBreak(world, player, pos, state, be);
        //        if (!shouldBreak) {
        //            PlayerBlockBreakEvents.CANCELED.invoker().onBlockBreakCanceled(world, player, pos, state, be);
        //            return ActionResult.SUCCESS;
        //        }

        if (player != null && !player.method_68878()) {
            class_2248.method_9609(state, serverLevel, pos, world.method_8321(pos), player, context.method_8041()).forEach(itemStack -> {
                player.method_31548().method_7398(itemStack);
            });
        }

        state.method_26180(serverLevel, pos, class_1799.field_8037, true);
        world.method_22352(pos, false);
        playRemoveSound(world, pos);
        //        PlayerBlockBreakEvents.AFTER.invoker().afterBlockBreak(world, player, pos, state, be);
        return class_1269.field_5812;
    }

    default class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        class_2680 newState = originalState;

        if (targetedFace.method_10166() == class_2350.class_2351.field_11052) {
            if (originalState.method_28498(HorizontalAxisKineticBlock.HORIZONTAL_AXIS))
                return originalState.method_11657(
                    HorizontalAxisKineticBlock.HORIZONTAL_AXIS,
                    VoxelShaper.axisAsFace(originalState.method_11654(HorizontalAxisKineticBlock.HORIZONTAL_AXIS)).method_35833(targetedFace.method_10166())
                        .method_10166()
                );
            if (originalState.method_28498(HorizontalKineticBlock.HORIZONTAL_FACING))
                return originalState.method_11657(
                    HorizontalKineticBlock.HORIZONTAL_FACING,
                    originalState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING).method_35833(targetedFace.method_10166())
                );
        }

        if (originalState.method_28498(RotatedPillarKineticBlock.AXIS))
            return originalState.method_11657(
                RotatedPillarKineticBlock.AXIS,
                VoxelShaper.axisAsFace(originalState.method_11654(RotatedPillarKineticBlock.AXIS)).method_35833(targetedFace.method_10166()).method_10166()
            );

        if (!originalState.method_28498(DirectionalKineticBlock.FACING))
            return originalState;

        class_2350 stateFacing = originalState.method_11654(DirectionalKineticBlock.FACING);

        if (stateFacing.method_10166().equals(targetedFace.method_10166())) {
            if (originalState.method_28498(DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE))
                return originalState.method_28493(DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            else
                return originalState;
        } else {
            do {
                newState = newState.method_11657(
                    DirectionalKineticBlock.FACING,
                    newState.method_11654(DirectionalKineticBlock.FACING).method_35833(targetedFace.method_10166())
                );
                if (targetedFace.method_10166() == class_2350.class_2351.field_11052 && newState.method_28498(DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE))
                    newState = newState.method_28493(DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            } while (newState.method_11654(DirectionalKineticBlock.FACING).method_10166().equals(targetedFace.method_10166()));
        }
        return newState;
    }
}
