package com.zurrtum.create.content.equipment.zapper;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.foundation.utility.BlockHelper;

import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2778;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;

public class ZapperInteractionHandler {
    public static boolean leftClickingBlocksWithTheZapperSelectsTheBlock(class_3222 player, class_1799 heldItem) {
        return heldItem.method_7909() instanceof ZapperItem && trySelect(heldItem, player);
    }

    public static boolean trySelect(class_1799 stack, class_1657 player) {
        if (player.method_5715())
            return false;

        class_1937 world = player.method_73183();
        class_243 start = player.method_73189().method_1031(0, player.method_5751(), 0);
        class_243 range = player.method_5720().method_1021(getRange(stack));
        class_3965 raytrace = world.method_17742(new class_3959(start, start.method_1019(range), class_3960.field_17559, class_242.field_1348, player));
        class_2338 pos = raytrace.method_17777();
        if (pos == null)
            return false;

        world.method_8517(player.method_5628(), pos, -1);
        class_2680 newState = world.method_8320(pos);

        if (BlockHelper.getRequiredItem(newState).method_7960())
            return false;
        if (newState.method_31709() && !newState.method_26164(AllBlockTags.SAFE_NBT))
            return false;
        if (newState.method_28498(class_2741.field_12533))
            return false;
        if (newState.method_28498(class_2741.field_12493))
            return false;
        if (newState.method_28498(class_2741.field_16561))
            return false;
        if (newState.method_28498(class_2741.field_12483))
            return false;
        if (newState.method_28498(class_2741.field_12503))
            newState = newState.method_11657(class_2741.field_12503, class_2778.field_12710);
        if (newState.method_28498(class_2741.field_12514))
            newState = newState.method_11657(class_2741.field_12514, true);
        if (newState.method_28498(class_2741.field_12508))
            newState = newState.method_11657(class_2741.field_12508, false);

        class_2487 data = null;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null) {
            data = blockEntity.method_38242(world.method_30349());
            data.method_10551("x");
            data.method_10551("y");
            data.method_10551("z");
            data.method_10551("id");
        }

        if (stack.method_57826(AllDataComponents.SHAPER_BLOCK_USED) && stack.method_58694(AllDataComponents.SHAPER_BLOCK_USED) == newState && Objects.equals(
            data,
            stack.method_58694(AllDataComponents.SHAPER_BLOCK_DATA)
        )) {
            return false;
        }

        stack.method_57379(AllDataComponents.SHAPER_BLOCK_USED, newState);
        if (data == null)
            stack.method_57381(AllDataComponents.SHAPER_BLOCK_DATA);
        else
            stack.method_57379(AllDataComponents.SHAPER_BLOCK_DATA, data);

        AllSoundEvents.CONFIRM.playOnServer(world, player.method_24515());
        return true;
    }

    public static int getRange(class_1799 stack) {
        if (stack.method_7909() instanceof ZapperItem)
            return ((ZapperItem) stack.method_7909()).getZappingRange(stack);
        return 0;
    }
}