package com.zurrtum.create.content.equipment.zapper.terrainzapper;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.infrastructure.component.PlacementOptions;
import org.apache.commons.lang3.tuple.Pair;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;

public class CylinderBrush extends ShapedBrush {

    public static final int MAX_RADIUS = 8;
    public static final int MAX_HEIGHT = 8;
    private final Map<Pair<Integer, Integer>, List<class_2338>> cachedBrushes;

    public CylinderBrush() {
        super(2);

        cachedBrushes = new HashMap<>();
        for (int i = 0; i <= MAX_RADIUS; i++) {
            int radius = i;
            List<class_2338> positions = class_2338.method_20437(class_2338.field_10980.method_10069(-i - 1, 0, -i - 1), class_2338.field_10980.method_10069(i + 1, 0, i + 1))
                .map(class_2338::new).filter(p -> VecHelper.getCenterOf(p).method_1022(VecHelper.getCenterOf(class_2338.field_10980)) < radius + .42f).toList();
            for (int h = 0; h <= MAX_HEIGHT; h++) {
                List<class_2338> stackedPositions = new ArrayList<>();
                for (int layer = 0; layer < h; layer++) {
                    int yOffset = layer - h / 2;
                    for (class_2338 p : positions)
                        stackedPositions.add(p.method_10086(yOffset));
                }
                cachedBrushes.put(Pair.of(i, h), stackedPositions);
            }
        }
    }

    @Override
    public class_2338 getOffset(class_243 ray, class_2350 face, PlacementOptions option) {
        if (option == PlacementOptions.Merged)
            return class_2338.field_10980;

        int offset = option == PlacementOptions.Attached ? 0 : -1;
        boolean negative = face.method_10171() == class_2352.field_11060;
        int yOffset = option == PlacementOptions.Attached ? negative ? 1 : 2 : negative ? 0 : -1;
        int r = (param0 + 1 + offset);
        int y = (param1 + (param1 == 0 ? 0 : yOffset)) / 2;

        return class_2338.field_10980.method_10079(face, (face.method_10166().method_10178() ? y : r) * (option == PlacementOptions.Attached ? 1 : -1));
    }

    @Override
    public int getMax(int paramIndex) {
        return paramIndex == 0 ? MAX_RADIUS : MAX_HEIGHT;
    }

    @Override
    public int getMin(int paramIndex) {
        return paramIndex == 0 ? 0 : 1;
    }

    @Override
    public List<class_2338> getIncludedPositions() {
        return cachedBrushes.get(Pair.of(param0, param1));
    }

}
