package com.zurrtum.create.content.fluids.hosePulley;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.fluids.transfer.FluidDrainingBehaviour;
import com.zurrtum.create.content.fluids.transfer.FluidFillingBehaviour;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;

public class HosePulleyBlockEntity extends KineticBlockEntity {

    LerpedFloat offset;
    boolean isMoving;

    private FluidDrainingBehaviour drainer;
    private FluidFillingBehaviour filler;
    public HosePulleyFluidHandler handler;
    public boolean infinite;

    public HosePulleyBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.HOSE_PULLEY, pos, state);
        offset = LerpedFloat.linear().startWithValue(0);
        isMoving = true;
        handler = new HosePulleyFluidHandler(this, filler, drainer, () -> pos.method_10087((int) Math.ceil(offset.getValue())), () -> !this.isMoving);
    }

    @Override
    public void sendData() {
        infinite = filler.isInfinite() || drainer.isInfinite();
        super.sendData();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        drainer = new FluidDrainingBehaviour(this);
        filler = new FluidFillingBehaviour(this);
        behaviours.add(drainer);
        behaviours.add(filler);
        super.addBehaviours(behaviours);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.HOSE_PULLEY, AllAdvancements.HOSE_PULLEY_LAVA);
    }

    protected void onTankContentsChanged(FluidStack contents) {
        method_5431();
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        isMoving = true;
        if (getSpeed() == 0) {
            offset.forceNextSync();
            offset.setValue(Math.round(offset.getValue()));
            isMoving = false;
        }

        if (isMoving) {
            float newOffset = offset.getValue() + getMovementSpeed();
            if (newOffset < 0)
                isMoving = false;
            if (!field_11863.method_8320(field_11867.method_10087((int) Math.ceil(newOffset))).method_45474()) {
                isMoving = false;
            }
            if (isMoving) {
                drainer.reset();
                filler.reset();
            }
        }

        super.onSpeedChanged(previousSpeed);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1012(0, -offset.getValue(), 0);
    }

    @Override
    public void tick() {
        super.tick();
        float newOffset = offset.getValue() + getMovementSpeed();
        if (newOffset < 0) {
            newOffset = 0;
            isMoving = false;
        }
        if (!field_11863.method_8320(field_11867.method_10087((int) Math.ceil(newOffset))).method_45474()) {
            newOffset = (int) newOffset;
            isMoving = false;
        }
        if (getSpeed() == 0)
            isMoving = false;

        offset.setValue(newOffset);
        invalidateRenderBoundingBox();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (field_11863.method_8608())
            return;
        if (isMoving)
            return;

        int ceil = (int) Math.ceil(offset.getValue() + getMovementSpeed());
        if (getMovementSpeed() > 0 && field_11863.method_8320(field_11867.method_10087(ceil)).method_45474()) {
            isMoving = true;
            drainer.reset();
            filler.reset();
            return;
        }

        sendData();
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        if (clientPacket)
            offset.forceNextSync();
        offset.write(view.method_71461("Offset"));
        handler.write(view);
        super.write(view, clientPacket);
        if (clientPacket)
            view.method_71472("Infinite", infinite);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        offset.read(view.method_71434("Offset"), clientPacket);
        handler.read(view);
        super.read(view, clientPacket);
        if (clientPacket)
            infinite = view.method_71433("Infinite", false);
    }

    public float getMovementSpeed() {
        float movementSpeed = convertToLinear(getSpeed());
        if (field_11863.method_8608())
            movementSpeed *= AllClientHandle.INSTANCE.getServerSpeed();
        return movementSpeed;
    }

    public float getInterpolatedOffset(float pt) {
        return Math.max(offset.getValue(pt), 3 / 16f);
    }
}
