package com.zurrtum.create.content.kinetics.belt.behaviour;

import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock.Shape;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

/**
 * Behaviour for BlockEntities to which belts can transfer items directly in a
 * backup-friendly manner. Example uses: Basin, Saw, Depot
 */
public class DirectBeltInputBehaviour extends BlockEntityBehaviour<SmartBlockEntity> {

    public static final BehaviourType<DirectBeltInputBehaviour> TYPE = new BehaviourType<>();

    private InsertionCallback tryInsert;
    private OccupiedPredicate isOccupied;
    private AvailabilityPredicate canInsert;
    private Supplier<Boolean> supportsBeltFunnels;

    public DirectBeltInputBehaviour(SmartBlockEntity be) {
        super(be);
        tryInsert = this::defaultInsertionCallback;
        canInsert = d -> true;
        isOccupied = d -> false;
        supportsBeltFunnels = () -> false;
    }

    public DirectBeltInputBehaviour allowingBeltFunnelsWhen(Supplier<Boolean> pred) {
        supportsBeltFunnels = pred;
        return this;
    }

    public DirectBeltInputBehaviour allowingBeltFunnels() {
        supportsBeltFunnels = () -> true;
        return this;
    }

    public DirectBeltInputBehaviour onlyInsertWhen(AvailabilityPredicate pred) {
        canInsert = pred;
        return this;
    }

    public DirectBeltInputBehaviour considerOccupiedWhen(OccupiedPredicate pred) {
        isOccupied = pred;
        return this;
    }

    public DirectBeltInputBehaviour setInsertionHandler(InsertionCallback callback) {
        tryInsert = callback;
        return this;
    }

    private class_1799 defaultInsertionCallback(TransportedItemStack inserted, class_2350 side, boolean simulate) {
        class_1263 lazy = ItemHelper.getInventory(blockEntity.method_10997(), blockEntity.method_11016(), null, blockEntity, side);
        if (lazy == null)
            return inserted.stack;
        int count = inserted.stack.method_7947();
        int insert;
        if (simulate) {
            insert = lazy.countSpace(inserted.stack, count, side);
        } else {
            insert = lazy.insertExist(inserted.stack, side);
        }
        if (insert == 0) {
            return inserted.stack;
        }
        if (insert == count) {
            return class_1799.field_8037;
        }
        return inserted.stack.method_46651(count - insert);
    }

    // TODO: verify that this side is consistent across all calls
    public boolean canInsertFromSide(class_2350 side) {
        return canInsert.test(side);
    }

    public boolean isOccupied(class_2350 side) {
        return isOccupied.test(side);
    }

    public class_1799 handleInsertion(class_1799 stack, class_2350 side, boolean simulate) {
        return handleInsertion(new TransportedItemStack(stack), side, simulate);
    }

    public class_1799 handleInsertion(TransportedItemStack stack, class_2350 side, boolean simulate) {
        return tryInsert.apply(stack, side, simulate);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @FunctionalInterface
    public interface InsertionCallback {
        class_1799 apply(TransportedItemStack stack, class_2350 side, boolean simulate);
    }

    @FunctionalInterface
    public interface OccupiedPredicate {
        boolean test(class_2350 side);
    }

    @FunctionalInterface
    public interface AvailabilityPredicate {
        boolean test(class_2350 side);
    }

    @Nullable
    public class_1799 tryExportingToBeltFunnel(class_1799 stack, @Nullable class_2350 side, boolean simulate) {
        class_2338 funnelPos = blockEntity.method_11016().method_10084();
        class_1937 world = getLevel();
        class_2680 funnelState = world.method_8320(funnelPos);
        if (!(funnelState.method_26204() instanceof BeltFunnelBlock))
            return null;
        if (funnelState.method_11654(BeltFunnelBlock.SHAPE) != Shape.PULLING)
            return null;
        if (side != null && FunnelBlock.getFunnelFacing(funnelState) != side)
            return null;
        class_2586 be = world.method_8321(funnelPos);
        if (!(be instanceof FunnelBlockEntity))
            return null;
        if (funnelState.method_11654(BeltFunnelBlock.POWERED))
            return null;
        class_1799 insert = FunnelBlock.tryInsert(world, funnelPos, stack, simulate);
        if (insert.method_7947() != stack.method_7947() && !simulate)
            ((FunnelBlockEntity) be).flap(true);
        return insert;
    }

    public boolean canSupportBeltFunnels() {
        return supportsBeltFunnels.get();
    }

}
