package com.zurrtum.create.content.kinetics.clock;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937.class_7867;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3542;

public class CuckooClockBlockEntity extends KineticBlockEntity {
    public LerpedFloat animationProgress = LerpedFloat.linear();
    public Animation animationType;
    private boolean sendAnimationUpdate;

    public enum Animation implements class_3542 {
        PIG,
        CREEPER,
        SURPRISE,
        NONE;
        public static final Codec<Animation> CODEC = class_3542.method_28140(Animation::values);

        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public CuckooClockBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CUCKOO_CLOCK, pos, state);
        animationType = Animation.NONE;
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CUCKOO_CLOCK);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            view.method_71426("Animation", Animation.CODEC).ifPresent(animation -> {
                animationType = animation;
                animationProgress.startWithValue(0);
            });
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (clientPacket && sendAnimationUpdate)
            view.method_71468("Animation", Animation.CODEC, animationType);
        sendAnimationUpdate = false;
        super.write(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (field_11863.method_8608() || getSpeed() == 0)
            return;

        if (animationType == Animation.NONE) {
            int dayTime = (int) (field_11863.method_8532() % 24000);
            int hours = (dayTime / 1000 + 6) % 24;
            int minutes = (dayTime % 1000) * 60 / 1000;
            if (hours == 12 && minutes < 5)
                startAnimation(Animation.PIG);
            if (hours == 18 && minutes < 36 && minutes > 31)
                startAnimation(Animation.CREEPER);
        } else {
            float value = getAndIncrementProgress();
            if (value > 100)
                animationType = Animation.NONE;

            if (animationType == Animation.SURPRISE && class_3532.method_15347(animationProgress.getValue(), 50)) {
                class_243 center = VecHelper.getCenterOf(field_11867);
                field_11863.method_22352(field_11867, false);
                field_11863.method_55117(
                    null,
                    AllDamageSources.get(field_11863).cuckoo_surprise,
                    null,
                    center.field_1352,
                    center.field_1351,
                    center.field_1350,
                    3,
                    false,
                    class_7867.field_40889
                );
            }
        }
    }

    public float getAndIncrementProgress() {
        float value = animationProgress.getValue();
        animationProgress.setValue(value + 1);
        return value;
    }

    public void startAnimation(Animation animation) {
        animationType = animation;
        if (animation != null && CuckooClockBlock.containsSurprise(method_11010()))
            animationType = Animation.SURPRISE;
        animationProgress.startWithValue(0);
        sendAnimationUpdate = true;

        if (animation == Animation.CREEPER)
            awardIfNear(AllAdvancements.CUCKOO_CLOCK, 32);

        sendData();
    }
}
