package com.zurrtum.create.content.kinetics.fan;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.decoration.copycat.CopycatBlock;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour.TransportedResult;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessing;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class AirCurrent {

    public final IAirCurrentSource source;
    public class_238 bounds = new class_238(0, 0, 0, 0, 0, 0);
    public List<AirCurrentSegment> segments = new ArrayList<>();
    public class_2350 direction;
    public boolean pushing;
    public float maxDistance;

    protected List<Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>> affectedItemHandlers = new ArrayList<>();
    protected List<class_1297> caughtEntities = new ArrayList<>();

    public AirCurrent(IAirCurrentSource source) {
        this.source = source;
    }

    public void tick() {
        if (direction == null)
            rebuild();
        class_1937 world = source.getAirCurrentWorld();
        if (world != null && world.method_8608()) {
            float offset = pushing ? 0.5f : maxDistance + .5f;
            class_243 pos = VecHelper.getCenterOf(source.getAirCurrentPos()).method_1019(class_243.method_24954(direction.method_62675()).method_1021(offset));
            AllClientHandle.INSTANCE.addAirFlowParticle(world, source.getAirCurrentPos(), pos.field_1352, pos.field_1351, pos.field_1350);
        }

        tickAffectedEntities(world);
        tickAffectedHandlers();
    }

    protected void tickAffectedEntities(class_1937 world) {
        for (Iterator<class_1297> iterator = caughtEntities.iterator(); iterator.hasNext(); ) {
            class_1297 entity = iterator.next();
            if (!entity.method_5805() || !entity.method_5829().method_994(bounds) || isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }

            class_2382 flow = (pushing ? direction : direction.method_10153()).method_62675();
            float speed = Math.abs(source.getSpeed());
            float sneakModifier = entity.method_5715() ? 4096f : 512f;
            double entityDistance = VecHelper.alignedDistanceToFace(entity.method_73189(), source.getAirCurrentPos(), direction);
            // entityDistanceOld should be removed eventually. Remember that entityDistanceOld cannot be 0 while entityDistance can,
            // so division by 0 must be avoided.
            double entityDistanceOld = entity.method_73189().method_1022(VecHelper.getCenterOf(source.getAirCurrentPos()));
            float acceleration = (float) (speed / sneakModifier / (entityDistanceOld / maxDistance));
            class_243 previousMotion = entity.method_18798();
            float maxAcceleration = 5;

            double xIn = class_3532.method_15350(flow.method_10263() * acceleration - previousMotion.field_1352, -maxAcceleration, maxAcceleration);
            double yIn = class_3532.method_15350(flow.method_10264() * acceleration - previousMotion.field_1351, -maxAcceleration, maxAcceleration);
            double zIn = class_3532.method_15350(flow.method_10260() * acceleration - previousMotion.field_1350, -maxAcceleration, maxAcceleration);

            entity.method_18799(previousMotion.method_1019(new class_243(xIn, yIn, zIn).method_1021(1 / 8f)));
            entity.field_6017 = 0;
            if (world != null && world.method_8608()) {
                AllClientHandle.INSTANCE.enableClientPlayerSound(entity, class_3532.method_15363(speed / 128f * .4f, 0.01f, .4f));
            }

            if (entity instanceof class_3222 serverPlayer)
                serverPlayer.field_13987.field_14138 = 0;

            FanProcessingType processingType = getTypeAt((float) entityDistance);

            if (processingType == null)
                continue;

            if (entity instanceof class_1542 itemEntity) {
                if (world != null && world.method_8608()) {
                    processingType.spawnProcessingParticles(world, entity.method_73189());
                    continue;
                }
                if (FanProcessing.canProcess(itemEntity, processingType))
                    if (FanProcessing.applyProcessing(itemEntity, processingType) && source instanceof EncasedFanBlockEntity fan)
                        fan.award(AllAdvancements.FAN_PROCESSING);
                continue;
            }

            if (world != null)
                processingType.affectEntity(entity, world);
        }
    }

    public static boolean isPlayerCreativeFlying(class_1297 entity) {
        if (entity instanceof class_1657 player) {
            return player.method_68878() && player.method_31549().field_7479;
        }
        return false;
    }

    public void tickAffectedHandlers() {
        for (Pair<TransportedItemStackHandlerBehaviour, FanProcessingType> pair : affectedItemHandlers) {
            TransportedItemStackHandlerBehaviour handler = pair.getKey();
            class_1937 world = handler.getLevel();
            FanProcessingType processingType = pair.getRight();
            if (processingType == null)
                continue;

            handler.handleProcessingOnAllItems(transported -> {
                if (world.method_8608()) {
                    processingType.spawnProcessingParticles(world, handler.getWorldPositionOf(transported));
                    return TransportedResult.doNothing();
                }
                TransportedResult applyProcessing = FanProcessing.applyProcessing(transported, world, processingType);
                if (!applyProcessing.doesNothing() && source instanceof EncasedFanBlockEntity fan)
                    fan.award(AllAdvancements.FAN_PROCESSING);
                return applyProcessing;
            });
        }
    }

    public void rebuild() {
        if (source.getSpeed() == 0) {
            maxDistance = 0;
            segments.clear();
            bounds = new class_238(0, 0, 0, 0, 0, 0);
            return;
        }

        direction = source.getAirflowOriginSide();
        pushing = source.getAirFlowDirection() == direction;
        maxDistance = source.getMaxDistance();

        class_1937 world = source.getAirCurrentWorld();
        class_2338 start = source.getAirCurrentPos();
        float max = this.maxDistance;
        class_2350 facing = direction;
        class_243 directionVec = class_243.method_24954(facing.method_62675());
        maxDistance = getFlowLimit(world, start, max, facing);

        // Determine segments with transported fluids/gases
        segments.clear();
        AirCurrentSegment currentSegment = null;
        FanProcessingType type = null;

        int limit = getLimit();
        int searchStart = pushing ? 1 : limit;
        int searchEnd = pushing ? limit : 1;
        int searchStep = pushing ? 1 : -1;
        int toOffset = pushing ? -1 : 0;

        for (int i = searchStart; i * searchStep <= searchEnd * searchStep; i += searchStep) {
            class_2338 currentPos = start.method_10079(direction, i);
            FanProcessingType newType = FanProcessingType.getAt(world, currentPos);
            if (newType != null) {
                type = newType;
            }
            if (currentSegment == null) {
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i + toOffset;
                currentSegment.type = type;
            } else if (currentSegment.type != type) {
                currentSegment.endOffset = i + toOffset;
                segments.add(currentSegment);
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i + toOffset;
                currentSegment.type = type;
            }
        }
        if (currentSegment != null) {
            currentSegment.endOffset = searchEnd + searchStep + toOffset;
            segments.add(currentSegment);
        }

        // Build Bounding Box
        if (maxDistance < 0.25f)
            bounds = new class_238(0, 0, 0, 0, 0, 0);
        else {
            float factor = maxDistance - 1;
            class_243 scale = directionVec.method_1021(factor);
            if (factor > 0)
                bounds = new class_238(start.method_10093(direction)).method_18804(scale);
            else {
                bounds = new class_238(start.method_10093(direction)).method_1002(scale.field_1352, scale.field_1351, scale.field_1350).method_997(scale);
            }
        }

        findAffectedHandlers();
    }

    public static float getFlowLimit(class_1937 world, class_2338 start, float max, class_2350 facing) {
        for (int i = 0; i < max; i++) {
            class_2338 currentPos = start.method_10079(facing, i + 1);
            if (!world.method_8477(currentPos)) {
                return i;
            }

            class_2680 state = world.method_8320(currentPos);
            class_2680 copycatState = CopycatBlock.getMaterial(world, currentPos);
            if (shouldAlwaysPass(copycatState.method_26215() ? state : copycatState)) {
                continue;
            }

            class_265 shape = state.method_26220(world, currentPos);
            if (shape.method_1110()) {
                continue;
            }
            if (shape == class_259.method_1077()) {
                return i;
            }
            double shapeDepth = findMaxDepth(shape, facing);
            if (shapeDepth == Double.POSITIVE_INFINITY) {
                continue;
            }
            return Math.min((float) (i + shapeDepth + 1 / 32d), max);
        }

        return max;
    }

    private static final double[][] DEPTH_TEST_COORDINATES = {{0.25, 0.25}, {0.25, 0.75}, {0.5, 0.5}, {0.75, 0.25}, {0.75, 0.75}};

    // Finds the maximum depth of the shape when traveling in the given direction.
    // The result is always positive.
    // If there is a hole, the result will be Double.POSITIVE_INFINITY.
    private static double findMaxDepth(class_265 shape, class_2350 direction) {
        class_2350.class_2351 axis = direction.method_10166();
        class_2350.class_2352 axisDirection = direction.method_10171();
        double maxDepth = 0;

        for (double[] coordinates : DEPTH_TEST_COORDINATES) {
            double depth;
            if (axisDirection == class_2350.class_2352.field_11056) {
                double min = shape.method_35593(axis, coordinates[0], coordinates[1]);
                if (min == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                depth = min;
            } else {
                double max = shape.method_1102(axis, coordinates[0], coordinates[1]);
                if (max == Double.NEGATIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                depth = 1 - max;
            }

            if (depth > maxDepth) {
                maxDepth = depth;
            }
        }

        return maxDepth;
    }

    private static boolean shouldAlwaysPass(class_2680 state) {
        return state.method_26164(AllBlockTags.FAN_TRANSPARENT);
    }

    private int getLimit() {
        if ((float) (int) maxDistance == maxDistance) {
            return (int) maxDistance;
        } else {
            return (int) maxDistance + 1;
        }
    }

    public void findAffectedHandlers() {
        class_1937 world = source.getAirCurrentWorld();
        class_2338 start = source.getAirCurrentPos();
        affectedItemHandlers.clear();
        int limit = getLimit();
        for (int i = 1; i <= limit; i++) {
            FanProcessingType segmentType = getTypeAt(i - 1);
            for (int offset : Iterate.zeroAndOne) {
                class_2338 pos = start.method_10079(direction, i).method_10087(offset);
                TransportedItemStackHandlerBehaviour behaviour = BlockEntityBehaviour.get(world, pos, TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour != null) {
                    FanProcessingType type = FanProcessingType.getAt(world, pos);
                    if (type == null)
                        type = segmentType;
                    affectedItemHandlers.add(Pair.of(behaviour, type));
                }
                if (direction.method_10166().method_10178())
                    break;
            }
        }
    }

    public void findEntities() {
        caughtEntities.clear();
        caughtEntities = source.getAirCurrentWorld().method_8335(null, bounds);
    }

    @Nullable
    public FanProcessingType getTypeAt(float offset) {
        if (offset >= 0 && offset <= maxDistance) {
            if (pushing) {
                for (AirCurrentSegment airCurrentSegment : segments) {
                    if (offset <= airCurrentSegment.endOffset) {
                        return airCurrentSegment.type;
                    }
                }
            } else {
                for (AirCurrentSegment airCurrentSegment : segments) {
                    if (offset >= airCurrentSegment.endOffset) {
                        return airCurrentSegment.type;
                    }
                }
            }
        }
        return null;
    }

    public static class AirCurrentSegment {
        @Nullable
        private FanProcessingType type;
        private int startOffset;
        private int endOffset;
    }
}