package com.zurrtum.create.content.kinetics.fan.processing;

import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour.TransportedResult;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.infrastructure.config.AllConfigs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class FanProcessing {
    public static boolean canProcess(class_1542 entity, FanProcessingType type) {
        String itemType = AllSynchedDatas.ITEM_TYPE.get(entity);
        if (!itemType.isEmpty()) {
            if (FanProcessingType.parse(itemType) != type) {
                return type.canProcess(entity.method_6983(), entity.method_73183());
            } else {
                return AllSynchedDatas.ITEM_TIME.get(entity) != -1;
            }
        }
        return type.canProcess(entity.method_6983(), entity.method_73183());
    }

    public static boolean applyProcessing(class_1542 entity, FanProcessingType type) {
        if (decrementProcessingTime(entity, type) != 0)
            return false;
        List<class_1799> stacks = type.process(entity.method_6983(), entity.method_73183());
        if (stacks == null)
            return false;
        if (stacks.isEmpty()) {
            entity.method_31472();
            return false;
        }
        entity.method_6979(stacks.removeFirst());
        for (class_1799 additional : stacks) {
            class_1542 entityIn = new class_1542(entity.method_73183(), entity.method_23317(), entity.method_23318(), entity.method_23321(), additional);
            entityIn.method_18799(entity.method_18798());
            entity.method_73183().method_8649(entityIn);
        }
        return true;
    }

    public static TransportedResult applyProcessing(TransportedItemStack transported, class_1937 world, FanProcessingType type) {
        TransportedResult ignore = TransportedResult.doNothing();
        if (transported.processedBy != type) {
            transported.processedBy = type;
            int timeModifierForStackSize = ((transported.stack.method_7947() - 1) / 16) + 1;
            transported.processingTime = (AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize) + 1;
            if (!type.canProcess(transported.stack, world))
                transported.processingTime = -1;
            return ignore;
        }
        if (transported.processingTime == -1)
            return ignore;
        if (transported.processingTime-- > 0)
            return ignore;

        List<class_1799> stacks = type.process(transported.stack, world);
        if (stacks == null)
            return ignore;

        List<TransportedItemStack> transportedStacks = new ArrayList<>();
        for (class_1799 additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.method_7972();
            transportedStacks.add(newTransported);
        }
        return TransportedResult.convertTo(transportedStacks);
    }

    private static int decrementProcessingTime(class_1542 entity, FanProcessingType type) {
        String itemType = AllSynchedDatas.ITEM_TYPE.get(entity);
        int time;
        if (itemType.isEmpty() || FanProcessingType.parse(itemType) != type) {
            class_2960 key = CreateRegistries.FAN_PROCESSING_TYPE.method_10221(type);
            if (key == null)
                throw new IllegalArgumentException("Could not get id for FanProcessingType " + type + "!");
            AllSynchedDatas.ITEM_TYPE.set(entity, key.toString());
            int timeModifierForStackSize = ((entity.method_6983().method_7947() - 1) / 16) + 1;
            time = (AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize);
        } else {
            time = AllSynchedDatas.ITEM_TIME.get(entity) - 1;
        }

        AllSynchedDatas.ITEM_TIME.set(entity, time);
        return time;
    }
}