package com.zurrtum.create.content.kinetics.fan.processing;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import com.zurrtum.create.foundation.recipe.CreateSingleStackRollableRecipe;

import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_3956;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record SplashingRecipe(List<ChanceOutput> results, class_1856 ingredient) implements CreateSingleStackRollableRecipe {
    @Override
    public class_1865<SplashingRecipe> method_8119() {
        return AllRecipeSerializers.SPLASHING;
    }

    @Override
    public class_3956<SplashingRecipe> method_17716() {
        return AllRecipeTypes.SPLASHING;
    }

    public static class Serializer implements class_1865<SplashingRecipe> {
        public static final MapCodec<SplashingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            ChanceOutput.CODEC.listOf(1, 2).fieldOf("results").forGetter(SplashingRecipe::results),
            class_1856.field_46095.fieldOf("ingredient").forGetter(SplashingRecipe::ingredient)
        ).apply(instance, SplashingRecipe::new));

        public static final class_9139<class_9129, SplashingRecipe> PACKET_CODEC = class_9139.method_56435(
            ChanceOutput.PACKET_CODEC.method_56433(class_9135.method_56363()),
            SplashingRecipe::results,
            class_1856.field_48355,
            SplashingRecipe::ingredient,
            SplashingRecipe::new
        );

        @Override
        public MapCodec<SplashingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, SplashingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}
