package com.zurrtum.create.content.kinetics.gantry;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.placement.PoleHelper;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;

public class GantryShaftBlock extends DirectionalKineticBlock implements IBE<GantryShaftBlockEntity> {

    public static final class_2754<Part> PART = class_2754.method_11850("part", Part.class);
    public static final class_2746 POWERED = class_2741.field_12484;

    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public enum Part implements class_3542 {
        START,
        MIDDLE,
        END,
        SINGLE;

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(PART, POWERED));
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!placementHelper.matchesItem(stack))
            return class_1269.field_52423;

        return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, ((class_1747) stack.method_7909()), player, hand);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return AllShapes.EIGHT_VOXEL_POLE.get(state.method_11654(FACING).method_10166());
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbour,
        class_5819 random
    ) {
        class_2350 facing = state.method_11654(FACING);
        class_2351 axis = facing.method_10166();
        if (direction.method_10166() != axis)
            return state;
        boolean connect = neighbour.method_27852(AllBlocks.GANTRY_SHAFT) && neighbour.method_11654(FACING) == facing;

        Part part = state.method_11654(PART);
        if (direction.method_10171() == facing.method_10171()) {
            if (connect) {
                if (part == Part.END)
                    part = Part.MIDDLE;
                if (part == Part.SINGLE)
                    part = Part.START;
            } else {
                if (part == Part.MIDDLE)
                    part = Part.END;
                if (part == Part.START)
                    part = Part.SINGLE;
            }
        } else {
            if (connect) {
                if (part == Part.START)
                    part = Part.MIDDLE;
                if (part == Part.SINGLE)
                    part = Part.END;
            } else {
                if (part == Part.MIDDLE)
                    part = Part.START;
                if (part == Part.END)
                    part = Part.SINGLE;
            }
        }

        return state.method_11657(PART, part);
    }

    public GantryShaftBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(POWERED, false).method_11657(PART, Part.SINGLE));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        class_2338 pos = context.method_8037();
        class_1937 world = context.method_8045();
        class_2350 face = context.method_8038();

        class_2680 neighbour = world.method_8320(pos.method_10093(state.method_11654(FACING).method_10153()));

        class_2680 clickedState = neighbour.method_27852(AllBlocks.GANTRY_SHAFT) ? neighbour : world.method_8320(pos.method_10093(face.method_10153()));

        if (clickedState.method_27852(AllBlocks.GANTRY_SHAFT) && clickedState.method_11654(FACING).method_10166() == state.method_11654(FACING).method_10166()) {
            class_2350 facing = clickedState.method_11654(FACING);
            state = state.method_11657(FACING, context.method_8036() == null || !context.method_8036().method_5715() ? facing : facing.method_10153());
        }

        return state.method_11657(POWERED, shouldBePowered(state, world, pos));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1269 onWrenched = super.onWrenched(state, context);
        if (onWrenched.method_23665()) {
            class_2338 pos = context.method_8037();
            class_1937 world = context.method_8045();
            method_9612(world.method_8320(pos), world, pos, state.method_26204(), null, false);
        }
        return onWrenched;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, worldIn, pos, oldState, isMoving);

        if (!worldIn.method_8608() && oldState.method_27852(AllBlocks.GANTRY_SHAFT)) {
            Part oldPart = oldState.method_11654(PART), part = state.method_11654(PART);
            if ((oldPart != Part.MIDDLE && part == Part.MIDDLE) || (oldPart == Part.SINGLE && part != Part.SINGLE)) {
                class_2586 be = worldIn.method_8321(pos);
                if (be instanceof GantryShaftBlockEntity)
                    ((GantryShaftBlockEntity) be).checkAttachedCarriageBlocks();
            }
        }
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 worldIn,
        class_2338 pos,
        class_2248 p_220069_4_,
        @Nullable class_9904 wireOrientation,
        boolean p_220069_6_
    ) {
        if (worldIn.method_8608())
            return;
        boolean previouslyPowered = state.method_11654(POWERED);
        boolean shouldPower = worldIn.method_49803(pos); // shouldBePowered(state, worldIn, pos);

        if (!previouslyPowered && !shouldPower && shouldBePowered(state, worldIn, pos)) {
            worldIn.method_8652(pos, state.method_11657(POWERED, true), class_2248.field_31036);
            return;
        }

        if (previouslyPowered == shouldPower)
            return;

        // Collect affected gantry shafts
        List<class_2338> toUpdate = new ArrayList<>();
        class_2350 facing = state.method_11654(FACING);
        class_2351 axis = facing.method_10166();
        for (class_2350 d : Iterate.directionsInAxis(axis)) {
            class_2338 currentPos = pos.method_10093(d);
            while (true) {
                if (!worldIn.method_8477(currentPos))
                    break;
                class_2680 currentState = worldIn.method_8320(currentPos);
                if (!(currentState.method_26204() instanceof GantryShaftBlock))
                    break;
                if (currentState.method_11654(FACING) != facing)
                    break;
                if (!shouldPower && currentState.method_11654(POWERED) && worldIn.method_49803(currentPos))
                    return;
                if (currentState.method_11654(POWERED) == shouldPower)
                    break;
                toUpdate.add(currentPos);
                currentPos = currentPos.method_10093(d);
            }
        }

        toUpdate.add(pos);
        for (class_2338 blockPos : toUpdate) {
            class_2680 blockState = worldIn.method_8320(blockPos);
            class_2586 be = worldIn.method_8321(blockPos);
            if (be instanceof KineticBlockEntity)
                ((KineticBlockEntity) be).detachKinetics();
            if (blockState.method_26204() instanceof GantryShaftBlock)
                worldIn.method_8652(blockPos, blockState.method_11657(POWERED, shouldPower), class_2248.field_31028);
        }
    }

    protected boolean shouldBePowered(class_2680 state, class_1937 worldIn, class_2338 pos) {
        boolean shouldPower = worldIn.method_49803(pos);

        class_2350 facing = state.method_11654(FACING);
        for (class_2350 d : Iterate.directionsInAxis(facing.method_10166())) {
            class_2338 neighbourPos = pos.method_10093(d);
            if (!worldIn.method_8477(neighbourPos))
                continue;
            class_2680 neighbourState = worldIn.method_8320(neighbourPos);
            if (!(neighbourState.method_26204() instanceof GantryShaftBlock))
                continue;
            if (neighbourState.method_11654(FACING) != facing)
                continue;
            shouldPower |= neighbourState.method_11654(POWERED);
        }

        return shouldPower;
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == state.method_11654(FACING).method_10166();
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(FACING).method_10166();
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(class_2680 oldState, class_2680 newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.method_11654(POWERED) == newState.method_11654(POWERED);
    }

    @Override
    public float getParticleTargetRadius() {
        return .35f;
    }

    @Override
    public float getParticleInitialRadius() {
        return .25f;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public static class PlacementHelper extends PoleHelper<class_2350> {

        public PlacementHelper() {
            super(state -> state.method_27852(AllBlocks.GANTRY_SHAFT), s -> s.method_11654(FACING).method_10166(), FACING);
        }

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return stack -> stack.method_31574(AllItems.GANTRY_SHAFT);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            offset.withTransform(offset.getTransform().andThen(s -> s.method_11657(POWERED, state.method_11654(POWERED))));
            return offset;
        }
    }

    @Override
    public Class<GantryShaftBlockEntity> getBlockEntityClass() {
        return GantryShaftBlockEntity.class;
    }

    @Override
    public class_2591<? extends GantryShaftBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.GANTRY_SHAFT;
    }

}
