package com.zurrtum.create.content.kinetics.millstone;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;

import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_3956;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record MillingRecipe(int time, List<ChanceOutput> results, class_1856 ingredient) implements AbstractCrushingRecipe {
    @Override
    public class_1865<MillingRecipe> method_8119() {
        return AllRecipeSerializers.MILLING;
    }

    @Override
    public class_3956<MillingRecipe> method_17716() {
        return AllRecipeTypes.MILLING;
    }

    public static class Serializer implements class_1865<MillingRecipe> {
        public static final MapCodec<MillingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            Codec.INT.fieldOf("processing_time").forGetter(MillingRecipe::time),
            ChanceOutput.CODEC.listOf(1, 3).fieldOf("results").forGetter(MillingRecipe::results),
            class_1856.field_46095.fieldOf("ingredient").forGetter(MillingRecipe::ingredient)
        ).apply(instance, MillingRecipe::new));

        public static final class_9139<class_9129, MillingRecipe> PACKET_CODEC = class_9139.method_56436(
            class_9135.field_49675,
            MillingRecipe::time,
            ChanceOutput.PACKET_CODEC.method_56433(class_9135.method_56363()),
            MillingRecipe::results,
            class_1856.field_48355,
            MillingRecipe::ingredient,
            MillingRecipe::new
        );

        @Override
        public MapCodec<MillingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, MillingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}
