package com.zurrtum.create.content.kinetics.mixer;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder.Instance;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record CompactingRecipe(
    class_1799 result, @Nullable FluidIngredient fluidIngredient, List<SizedIngredient> ingredients
) implements BasinRecipe {
    @Override
    public int getIngredientSize() {
        return (fluidIngredient == null ? 0 : 1) + ingredients.size();
    }

    @Override
    public List<SizedIngredient> getIngredients() {
        return ingredients;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return fluidIngredient == null ? List.of() : List.of(fluidIngredient);
    }

    @Override
    public boolean matches(BasinInput input, class_1937 world) {
        ServerFilteringBehaviour filter = input.filter();
        if (filter == null) {
            return false;
        }
        if (!filter.test(result)) {
            return false;
        }
        List<class_1799> outputs = BasinRecipe.tryCraft(input, ingredients);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.matchFluidIngredient(input, fluidIngredient)) {
            return false;
        }
        outputs.add(result);
        return input.acceptOutputs(outputs, List.of(), true);
    }

    @Override
    public boolean apply(BasinInput input) {
        Deque<Runnable> changes = new ArrayDeque<>();
        List<class_1799> outputs = BasinRecipe.prepareCraft(input, ingredients, changes);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.prepareFluidCraft(input, fluidIngredient, changes)) {
            return false;
        }
        outputs.add(result);
        if (!input.acceptOutputs(outputs, List.of(), true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, List.of(), false);
    }

    @Override
    public class_1865<CompactingRecipe> method_8119() {
        return AllRecipeSerializers.COMPACTING;
    }

    @Override
    public class_3956<CompactingRecipe> method_17716() {
        return AllRecipeTypes.COMPACTING;
    }

    public static class Serializer implements class_1865<CompactingRecipe> {
        public static final MapCodec<CompactingRecipe> CODEC = RecordCodecBuilder.mapCodec((Instance<CompactingRecipe> instance) -> instance.group(
            class_1799.field_24671.fieldOf("result").forGetter(CompactingRecipe::result),
            FluidIngredient.CODEC.optionalFieldOf("fluid_ingredient").forGetter(Serializer::getOptionalFluidIngredient),
            SizedIngredient.getListCodec(1, 9).optionalFieldOf("ingredients", List.of()).forGetter(CompactingRecipe::ingredients)
        ).apply(instance, Serializer::createRecipe)).validate(recipe -> {
            if (recipe.fluidIngredient == null && recipe.ingredients.isEmpty()) {
                return DataResult.error(() -> "MixingRecipe must have a ingredient or a fluid ingredient");
            }
            return DataResult.success(recipe);
        });
        public static final class_9139<class_9129, CompactingRecipe> PACKET_CODEC = class_9139.method_56436(
            class_1799.field_48349,
            CompactingRecipe::result,
            FluidIngredient.PACKET_CODEC.method_56433(class_9135::method_56382),
            Serializer::getOptionalFluidIngredient,
            SizedIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()),
            CompactingRecipe::ingredients,
            Serializer::createRecipe
        );

        private static Optional<FluidIngredient> getOptionalFluidIngredient(CompactingRecipe recipe) {
            return Optional.ofNullable(recipe.fluidIngredient);
        }

        @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
        private static CompactingRecipe createRecipe(class_1799 result, Optional<FluidIngredient> fluidIngredient, List<SizedIngredient> ingredients) {
            return new CompactingRecipe(result, fluidIngredient.orElse(null), ingredients);
        }

        @Override
        public MapCodec<CompactingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, CompactingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}
