package com.zurrtum.create.content.kinetics.saw;

import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public class SawMovementBehaviour extends BlockBreakingMovementBehaviour {

    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(
            context.relativeMotion,
            context.state.method_11654(SawBlock.FACING).method_10153()
        );
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954(context.state.method_11654(SawBlock.FACING).method_62675()).method_1021(.65f);
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        super.visitNewPosition(context, pos);
        class_243 facingVec = class_243.method_24954(context.state.method_11654(SawBlock.FACING).method_62675());
        facingVec = context.rotation.apply(facingVec);

        class_2350 closestToFacing = class_2350.method_10142(facingVec.field_1352, facingVec.field_1351, facingVec.field_1350);
        if (closestToFacing.method_10166().method_10178() && context.data.method_10545("BreakingPos")) {
            context.data.method_10551("BreakingPos");
            context.stall = false;
        }
    }

    @Override
    public boolean canBreak(class_1937 world, class_2338 breakingPos, class_2680 state) {
        return super.canBreak(world, breakingPos, state) && SawBlockEntity.isSawable(state);
    }

    @Override
    protected void onBlockBroken(MovementContext context, class_2338 pos, class_2680 brokenState) {
        if (brokenState.method_26164(class_3481.field_15503))
            return;

        //TODO
        //        Optional<AbstractBlockBreakQueue> dynamicTree = TreeCutter.findDynamicTree(brokenState.getBlock(), pos);
        //        if (dynamicTree.isPresent()) {
        //            dynamicTree.get().destroyBlocks(context.world, null, (stack, dropPos) -> dropItemFromCutTree(context, stack, dropPos));
        //            return;
        //        }

        TreeCutter.findTree(context.world, pos, brokenState)
            .destroyBlocks(context.world, null, (stack, dropPos) -> dropItemFromCutTree(context, stack, dropPos));
    }

    public void dropItemFromCutTree(MovementContext context, class_2338 pos, class_1799 stack) {
        class_1263 inventory = context.contraption.getStorage().getAllItems();
        int count = stack.method_7947();
        int insert = inventory.insert(stack);
        if (insert == count)
            return;

        class_1937 world = context.world;
        class_243 dropPos = VecHelper.getCenterOf(pos);
        float distance = context.position == null ? 1 : (float) dropPos.method_1022(context.position);
        stack.method_7939(count - insert);
        class_1542 entity = new class_1542(world, dropPos.field_1352, dropPos.field_1351, dropPos.field_1350, stack);
        entity.method_18799(context.relativeMotion.method_1021(distance / 20f));
        world.method_8649(entity);
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    protected boolean shouldDestroyStartBlock(class_2680 stateToBreak) {
        //TODO
        //        return !TreeCutter.canDynamicTreeCutFrom(stateToBreak.getBlock());
        return true;
    }

    @Override
    protected class_1282 getDamageSource(class_1937 level) {
        return AllDamageSources.get(level).saw;
    }
}
