package com.zurrtum.create.content.kinetics.simpleRelays;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class SimpleKineticBlockEntity extends KineticBlockEntity {

    public SimpleKineticBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static SimpleKineticBlockEntity small(class_2338 pos, class_2680 state) {
        return new SimpleKineticBlockEntity(AllBlockEntityTypes.ENCASED_COGWHEEL, pos, state);
    }

    public static SimpleKineticBlockEntity large(class_2338 pos, class_2680 state) {
        return new SimpleKineticBlockEntity(AllBlockEntityTypes.ENCASED_LARGE_COGWHEEL, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(field_11867).method_1014(1);
    }

    @Override
    public List<class_2338> addPropagationLocations(IRotate block, class_2680 state, List<class_2338> neighbours) {
        if (!ICogWheel.isLargeCog(state))
            return super.addPropagationLocations(block, state, neighbours);

        class_2338.method_20437(new class_2338(-1, -1, -1), new class_2338(1, 1, 1)).forEach(offset -> {
            if (offset.method_10262(class_2338.field_10980) == 2)
                neighbours.add(field_11867.method_10081(offset));
        });
        return neighbours;
    }

    @Override
    public boolean isNoisy() {
        return false;
    }

}
