package com.zurrtum.create.content.kinetics.simpleRelays.encased;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VoxelShaper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.decoration.encasing.EncasedBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_6088;

public class EncasedCogwheelBlock extends RotatedPillarKineticBlock implements ICogWheel, IBE<SimpleKineticBlockEntity>, SpecialBlockItemRequirement, TransformableBlock, EncasedBlock {

    public static final class_2746 TOP_SHAFT = class_2746.method_11825("top_shaft");
    public static final class_2746 BOTTOM_SHAFT = class_2746.method_11825("bottom_shaft");

    protected final boolean isLarge;
    private final class_2248 casing;

    public EncasedCogwheelBlock(class_2251 properties, boolean large, class_2248 casing) {
        super(properties);
        isLarge = large;
        this.casing = casing;
        method_9590(method_9564().method_11657(TOP_SHAFT, false).method_11657(BOTTOM_SHAFT, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(TOP_SHAFT, BOTTOM_SHAFT));
    }

    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return casing.method_8389().method_7854();
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 placedOn = context.method_8045().method_8320(context.method_8037().method_10093(context.method_8038().method_10153()));
        class_2680 stateForPlacement = super.method_9605(context);
        if (ICogWheel.isSmallCog(placedOn))
            stateForPlacement = stateForPlacement.method_11657(AXIS, ((IRotate) placedOn.method_26204()).getRotationAxis(placedOn));
        return stateForPlacement;
    }

    @Override
    public boolean method_9522(class_2680 pState, class_2680 pAdjacentBlockState, class_2350 pDirection) {
        return pState.method_26204() == pAdjacentBlockState.method_26204() && pState.method_11654(AXIS) == pAdjacentBlockState.method_11654(AXIS);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (context.method_8038().method_10166() != state.method_11654(AXIS))
            return super.onWrenched(state, context);

        class_1937 level = context.method_8045();
        if (level.method_8608())
            return class_1269.field_5812;

        class_2338 pos = context.method_8037();
        KineticBlockEntity.switchToBlockState(
            level,
            pos,
            state.method_28493(context.method_8038().method_10171() == class_2352.field_11056 ? TOP_SHAFT : BOTTOM_SHAFT)
        );
        IWrenchable.playRotateSound(level, pos);
        return class_1269.field_5812;
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        originalState = swapShaftsForRotation(originalState, class_2470.field_11463, targetedFace.method_10166());
        return originalState.method_11657(
            RotatedPillarKineticBlock.AXIS,
            VoxelShaper.axisAsFace(originalState.method_11654(RotatedPillarKineticBlock.AXIS)).method_35833(targetedFace.method_10166()).method_10166()
        );
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        if (context.method_8045().method_8608())
            return class_1269.field_5812;
        context.method_8045().method_20290(class_6088.field_31144, context.method_8037(), class_2248.method_9507(state));
        KineticBlockEntity.switchToBlockState(
            context.method_8045(),
            context.method_8037(),
            (isLarge ? AllBlocks.LARGE_COGWHEEL : AllBlocks.COGWHEEL).method_9564().method_11657(AXIS, state.method_11654(AXIS))
        );
        return class_1269.field_5812;
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == state.method_11654(AXIS) && state.method_11654(face.method_10171() == class_2352.field_11056 ? TOP_SHAFT : BOTTOM_SHAFT);
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(class_2680 oldState, class_2680 newState) {
        if (newState.method_26204() instanceof EncasedCogwheelBlock && oldState.method_26204() instanceof EncasedCogwheelBlock) {
            if (newState.method_11654(TOP_SHAFT) != oldState.method_11654(TOP_SHAFT))
                return false;
            if (newState.method_11654(BOTTOM_SHAFT) != oldState.method_11654(BOTTOM_SHAFT))
                return false;
        }
        return super.areStatesKineticallyEquivalent(oldState, newState);
    }

    @Override
    public boolean isSmallCog() {
        return !isLarge;
    }

    @Override
    public boolean isLargeCog() {
        return isLarge;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        return CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), worldIn, pos, state.method_11654(AXIS));
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(AXIS);
    }

    public class_2680 swapShafts(class_2680 state) {
        boolean bottom = state.method_11654(BOTTOM_SHAFT);
        boolean top = state.method_11654(TOP_SHAFT);
        state = state.method_11657(BOTTOM_SHAFT, top);
        state = state.method_11657(TOP_SHAFT, bottom);
        return state;
    }

    public class_2680 swapShaftsForRotation(class_2680 state, class_2470 rotation, class_2350.class_2351 rotationAxis) {
        if (rotation == class_2470.field_11467) {
            return state;
        }

        class_2350.class_2351 axis = state.method_11654(AXIS);
        if (axis == rotationAxis) {
            return state;
        }

        if (rotation == class_2470.field_11464) {
            return swapShafts(state);
        }

        boolean clockwise = rotation == class_2470.field_11463;

        if (rotationAxis == class_2350.class_2351.field_11048) {
            if (axis == class_2350.class_2351.field_11051 && !clockwise || axis == class_2350.class_2351.field_11052 && clockwise) {
                return swapShafts(state);
            }
        } else if (rotationAxis == class_2350.class_2351.field_11052) {
            if (axis == class_2350.class_2351.field_11048 && !clockwise || axis == class_2350.class_2351.field_11051 && clockwise) {
                return swapShafts(state);
            }
        } else if (rotationAxis == class_2350.class_2351.field_11051) {
            if (axis == class_2350.class_2351.field_11052 && !clockwise || axis == class_2350.class_2351.field_11048 && clockwise) {
                return swapShafts(state);
            }
        }

        return state;
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        class_2350.class_2351 axis = state.method_11654(AXIS);
        if (axis == class_2350.class_2351.field_11048 && mirror == class_2415.field_11301 || axis == class_2350.class_2351.field_11051 && mirror == class_2415.field_11300) {
            return swapShafts(state);
        }
        return state;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        state = swapShaftsForRotation(state, rotation, class_2350.class_2351.field_11052);
        return super.method_9598(state, rotation);
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = method_9569(state, transform.mirror);
        }

        if (transform.rotationAxis == class_2350.class_2351.field_11052) {
            return method_9598(state, transform.rotation);
        }

        state = swapShaftsForRotation(state, transform.rotation, transform.rotationAxis);
        state = state.method_11657(AXIS, transform.rotateAxis(state.method_11654(AXIS)));
        return state;
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        return ItemRequirement.of(isLarge ? AllBlocks.LARGE_COGWHEEL.method_9564() : AllBlocks.COGWHEEL.method_9564(), be);
    }

    @Override
    public Class<SimpleKineticBlockEntity> getBlockEntityClass() {
        return SimpleKineticBlockEntity.class;
    }

    @Override
    public class_2591<? extends SimpleKineticBlockEntity> getBlockEntityType() {
        return isLarge ? AllBlockEntityTypes.ENCASED_LARGE_COGWHEEL : AllBlockEntityTypes.ENCASED_COGWHEEL;
    }

    @Override
    public class_2248 getCasing() {
        return casing;
    }

    @Override
    public void handleEncasing(
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1799 heldItem,
        class_1657 player,
        class_1268 hand,
        class_3965 ray
    ) {
        class_2680 encasedState = method_9564().method_11657(AXIS, state.method_11654(AXIS));

        for (class_2350 d : Iterate.directionsInAxis(state.method_11654(AXIS))) {
            class_2680 adjacentState = level.method_8320(pos.method_10093(d));
            if (!(adjacentState.method_26204() instanceof IRotate def))
                continue;
            if (!def.hasShaftTowards(level, pos.method_10093(d), adjacentState, d.method_10153()))
                continue;
            encasedState = encasedState.method_28493(d.method_10171() == class_2352.field_11056 ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT);
        }

        KineticBlockEntity.switchToBlockState(level, pos, encasedState);
    }
}
