package com.zurrtum.create.content.logistics.box;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.chute.ChuteBlock;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.PackageDestroyPacket;
import com.zurrtum.create.infrastructure.packet.s2c.PackageSpawnPacket;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.class_8942;
import net.minecraft.class_9334;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.Nullable;

import java.lang.ref.WeakReference;
import java.util.List;

public class PackageEntity extends class_1309 {

    private class_1297 originalEntity;
    public class_1799 box;

    public int insertionDelay;

    public class_243 vec2 = class_243.field_1353, vec3 = class_243.field_1353;

    public WeakReference<class_1657> tossedBy = new WeakReference<>(null);

    public PackageEntity(class_1299<? extends PackageEntity> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        box = class_1799.field_8037;
        method_36456(this.field_5974.method_43057() * 360.0F);
        method_5847(method_36454());
        field_5982 = method_36454();
        insertionDelay = 30;
    }

    public PackageEntity(class_1937 worldIn, double x, double y, double z) {
        this(AllEntityTypes.PACKAGE, worldIn);
        this.method_5814(x, y, z);
        this.method_18382();
    }

    @Override
    public void method_5784(class_1313 type, class_243 movement) {
        super.method_5784(type, movement);
        if (movement.method_1027() >= 0.01f) {
            field_64356 = true;
        }
    }

    public static PackageEntity fromDroppedItem(class_1937 world, class_1297 originalEntity, class_1799 itemstack) {
        PackageEntity packageEntity = new PackageEntity(AllEntityTypes.PACKAGE, world);

        class_243 position = originalEntity.method_73189();
        packageEntity.method_33574(position);
        packageEntity.setBox(itemstack);
        packageEntity.method_18799(originalEntity.method_18798().method_1021(1.5f));
        packageEntity.originalEntity = originalEntity;

        if (world != null && !world.method_8608())
            if (ChuteBlock.isChute(world.method_8320(class_2338.method_49637(position.field_1352, position.field_1351 + .5f, position.field_1350))))
                packageEntity.method_36456(((int) packageEntity.method_36454()) / 90 * 90);

        return packageEntity;
    }

    public static PackageEntity fromItemStack(class_1937 world, class_243 position, class_1799 itemstack) {
        PackageEntity packageEntity = new PackageEntity(AllEntityTypes.PACKAGE, world);
        packageEntity.method_33574(position);
        packageEntity.setBox(itemstack);
        return packageEntity;
    }

    @Override
    public class_1799 method_31480() {
        return box.method_7972();
    }

    public static class_5132.class_5133 createPackageAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 5f).method_26868(class_5134.field_23719, 1f);
    }

    @Override
    public boolean method_66249() {
        return true;
    }

    @Override
    public boolean method_6034() {
        return true;
    }

    @Override
    public void method_6091(class_243 p_213352_1_) {
        super.method_6091(p_213352_1_);

        if (!method_73183().method_8608())
            return;
        if (method_18798().method_1033() < 1 / 128f)
            return;
        if (field_6012 >= 20)
            return;

        class_243 motion = method_18798().method_1021(.75f);
        class_238 bb = method_5829();
        List<class_265> entityStream = method_73183().method_20743(this, bb.method_18804(motion));
        motion = method_20736(this, motion, bb, method_73183(), entityStream);

        class_243 clientPos = method_73189().method_1019(motion);
        if (method_66245())
            clientPos = VecHelper.lerp(Math.min(1, field_6012 / 20f), clientPos, method_66233().method_66265());
        if (field_6012 < 5)
            method_5814(clientPos.field_1352, clientPos.field_1351, clientPos.field_1350);
        if (field_6012 < 20)
            method_66233().method_66267(clientPos, method_36454(), method_36455());
    }

    @Override
    public void method_5750(class_243 clientVelocity) {
        method_18799(method_18798().method_1019(clientVelocity).method_1021(.5f));
    }

    public String getAddress() {
        return box.method_58694(AllDataComponents.PACKAGE_ADDRESS);
    }

    @Override
    public void method_5773() {
        if (field_5953) {
            verifyInitialEntity();
            originalEntity = null;
        }

        //        if (getWorld() instanceof PonderLevel) {
        //            setVelocity(getVelocity().add(0, -0.06, 0));
        //            if (getPos().y < 0.125)
        //                discard();
        //        }

        insertionDelay = Math.min(insertionDelay + 1, 30);
        super.method_5773();

        if (!PackageItem.isPackage(box))
            method_31472();
    }

    /*
     * Forge created package entities even when an ItemEntity is spawned as 'fake'.
     * See: GiveCommand#giveItem. This method discards the package if it originated
     * from such a fake item
     */
    protected void verifyInitialEntity() {
        if (!(originalEntity instanceof class_1542 itemEntity))
            return;
        try (class_8942.class_11340 logging = new class_8942.class_11340(method_71370(), Create.LOGGER)) {
            class_11362 view = class_11362.method_71459(logging, method_56673());
            itemEntity.method_5652(view);
            if (view.method_71475().method_68083("PickupDelay", 0) != 32767) // See: ItemEntity#setDespawnImmediately
                return;
            method_31472();
        }
    }

    @Override
    protected class_4048 method_55694(class_4050 pose) {
        if (box == null)
            return super.method_55694(pose);
        return class_4048.method_18385(PackageItem.getWidth(box), PackageItem.getHeight(box));
    }

    public class_1799 getBox() {
        return box;
    }

    public static boolean centerPackage(class_1297 entity, class_243 target) {
        if (!(entity instanceof PackageEntity packageEntity))
            return true;
        return packageEntity.decreaseInsertionTimer(target);
    }

    public boolean decreaseInsertionTimer(@Nullable class_243 targetSpot) {
        if (targetSpot != null) {
            method_18799(method_18798().method_1021(.75f).method_18805(1, .25f, 1));
            class_243 pos = method_73189().method_1019(targetSpot.method_1020(method_73189()).method_1021(.2f));
            method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            float yawTarget = ((int) method_36454()) / 90 * 90;
            method_36456(AngleHelper.angleLerp(.5f, method_36454(), yawTarget));
        }
        insertionDelay = Math.max(insertionDelay - 3, 0);
        return insertionDelay == 0;
    }

    public void setBox(class_1799 box) {
        this.box = box.method_7972();
        method_18382();
    }

    @Override
    public boolean method_5810() {
        return true;
    }

    @Override
    public boolean method_30949(class_1297 pEntity) {
        return pEntity instanceof PackageEntity && pEntity.method_5829().field_1325 < method_5829().field_1322 + .125f;
    }

    @Override
    public class_1269 method_5688(class_1657 pPlayer, class_1268 pHand) {
        if (!pPlayer.method_5998(pHand).method_7960())
            return super.method_5688(pPlayer, pHand);
        if (pPlayer.method_73183().method_8608())
            return class_1269.field_5812;
        pPlayer.method_6122(pHand, box);
        method_73183().method_8396(null, method_24515(), class_3417.field_15197, class_3419.field_15248, .2f, .75f + method_73183().field_9229.method_43057());
        method_5650(class_5529.field_26999);
        return class_1269.field_5812;
    }

    @Override
    public void method_5697(class_1297 entityIn) {
        boolean isOtherPackage = entityIn instanceof PackageEntity;

        if (!isOtherPackage && tossedBy.get() != null)
            tossedBy = new WeakReference<>(null); // no nudging

        if (isOtherPackage) {
            if (entityIn.method_5829().field_1322 < this.method_5829().field_1325)
                super.method_5697(entityIn);
        } else if (entityIn.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entityIn);
        }
    }

    @Override
    public class_243 method_52538(class_1297 entity) {
        return method_73189().method_1031(0, entity.method_18377(method_18376()).comp_2186(), 0);
    }

    @Override
    protected class_243 method_52533(class_1297 entity, class_4048 dimensions, float partialTick) {
        return super.method_52533(entity, dimensions, partialTick).method_1031(0, 2 / 16f, 0);
    }

    @Override
    protected void method_5622(class_2680 state) {
        super.method_5622(state);
        if (!method_5805())
            return;
        if (state.method_26204() == class_2246.field_10382 || (state.method_28498(class_2741.field_12508) && state.method_11654(class_2741.field_12508))) {
            destroy(method_48923().method_48824());
            method_5650(class_5529.field_26998);
        }
    }

    @Override
    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (method_73183().method_8608() || !this.method_5805())
            return false;

        if (source.method_48789(class_8103.field_42242)) {
            this.method_5650(class_5529.field_26998);
            return false;
        }

        if (source.equals(method_48923().method_48822()) && (method_5765() || insertionDelay < 20))
            return false;

        if (source.method_48789(class_8103.field_42250))
            return false;

        if (this.method_5679((class_3218) method_73183(), source))
            return false;

        if (source.method_48789(class_8103.field_42249)) {
            this.destroy(source);
            this.method_5650(class_5529.field_26998);
            return false;
        }

        if (source.method_48789(class_8103.field_42246)) {
            if (this.method_5809()) {
                this.takeDamage(source, 0.15F);
            } else {
                this.method_20803(100); // 5 seconds
            }
            return false;
        }

        boolean shotCanPierce;
        if (source.method_5526() instanceof class_1665 persistentProjectileEntity) {
            shotCanPierce = persistentProjectileEntity.method_7447() > 0;
        } else {
            shotCanPierce = false;
        }

        if (source.method_5529() instanceof class_1657 player && !player.method_31549().field_7476)
            return false;

        this.destroy(source);
        this.method_5650(class_5529.field_26998);
        return shotCanPierce;
    }

    private void takeDamage(class_1282 source, float amount) {
        float hp = this.method_6032();
        hp = hp - amount;
        if (hp <= 0.5F) {
            this.destroy(source);
            this.method_5650(class_5529.field_26998);
        } else {
            this.method_6033(hp);
        }
    }

    private void destroy(class_1282 source) {
        AllSoundEvents.PACKAGE_POP.playOnServer(method_73183(), method_24515());
        if (method_73183() instanceof class_3218 serverLevel) {
            this.method_16080(serverLevel, source);
            serverLevel.method_14178().method_18754(this, new PackageDestroyPacket(method_5829().method_1005(), box));
        }
    }

    @Override
    protected void method_16080(class_3218 level, class_1282 pDamageSource) {
        super.method_16080(level, pDamageSource);
        ItemStackHandler contents = PackageItem.getContents(box);
        for (int i = 0, size = contents.method_5439(); i < size; i++) {
            class_1799 itemstack = contents.method_5438(i);

            if (itemstack.method_7909() instanceof class_1826 sei) {
                class_1299<?> entitytype = sei.method_8015(itemstack);
                class_1297 entity = entitytype.method_5894(level, itemstack, null, method_24515(), class_3730.field_16465, false, false);
                if (entity != null)
                    itemstack.method_7934(1);
            }

            if (itemstack.method_7960())
                continue;
            class_1542 entityIn = new class_1542(level, method_23317(), method_23318(), method_23321(), itemstack);
            level.method_8649(entityIn);
        }
    }

    @Override
    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        box = view.method_71426("Box", class_1799.field_24671).orElse(class_1799.field_8037);
        method_18382();
    }

    @Override
    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        if (!box.method_7960()) {
            view.method_71468("Box", class_1799.field_24671, box);
        }
    }

    @Override
    public class_1799 method_6118(class_1304 pSlot) {
        if (pSlot == class_1304.field_6173)
            return getBox();
        return class_1799.field_8037;
    }

    @Override
    public void method_5673(class_1304 pSlot, class_1799 pStack) {
        if (pSlot == class_1304.field_6173)
            setBox(pStack);
    }

    @Override
    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    @Override
    public class_1268 method_6058() {
        return class_1268.field_5808;
    }

    @Override
    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new PackageSpawnPacket(this, entityTrackerEntry);
    }

    @Override
    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        PackageSpawnPacket spawnPacket = (PackageSpawnPacket) packet;
        setBox(spawnPacket.getBox());
    }

    @Override
    public float method_6017() {
        return 1.5f;
    }

    @Override
    public class_6823 method_39760() {
        return new class_6823(class_3417.field_40968, class_3417.field_40968);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return null;
    }

    @Nullable
    protected class_3414 method_6002() {
        return null;
    }

    @Override
    public boolean method_6086() {
        return false;
    }

    @Override
    public boolean method_5753() {
        return box.method_57826(class_9334.field_54273) || super.method_5753();
    }
}