package com.zurrtum.create.content.logistics.chute;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour.TransportedResult;
import com.zurrtum.create.content.kinetics.fan.AirCurrent;
import com.zurrtum.create.content.kinetics.fan.EncasedFanBlock;
import com.zurrtum.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.item.ItemHelper.ExtractionCountMode;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.particle.AirParticleData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class ChuteBlockEntity extends SmartBlockEntity {
    public float pull;
    public float push;

    class_1799 item;
    public LerpedFloat itemPosition;
    public ChuteItemHandler itemHandler;
    boolean canPickUpItems;

    public float bottomPullDistance;
    float beltBelowOffset;
    TransportedItemStackHandlerBehaviour beltBelow;
    boolean updateAirFlow;
    int airCurrentUpdateCooldown;
    int entitySearchCooldown;

    VersionedInventoryTrackerBehaviour invVersionTracker;

    private final EnumMap<class_2350, Supplier<class_1263>> capCaches = new EnumMap<>(class_2350.class);

    public ChuteBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        item = class_1799.field_8037;
        itemPosition = LerpedFloat.linear();
        itemHandler = new ChuteItemHandler(this);
        canPickUpItems = false;
        bottomPullDistance = 0;
        updateAirFlow = true;
    }

    public ChuteBlockEntity(class_2338 pos, class_2680 state) {
        this(AllBlockEntityTypes.CHUTE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen((d) -> canDirectlyInsertCached()));
        behaviours.add(invVersionTracker = new VersionedInventoryTrackerBehaviour(this));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CHUTE);
    }

    // Cached per-tick, useful when a lot of items are waiting on top of it
    public boolean canDirectlyInsertCached() {
        return canPickUpItems;
    }

    private boolean canDirectlyInsert() {
        class_2680 blockState = method_11010();
        class_2680 blockStateAbove = field_11863.method_8320(field_11867.method_10084());
        if (!AbstractChuteBlock.isChute(blockState))
            return false;
        if (AbstractChuteBlock.getChuteFacing(blockStateAbove) == class_2350.field_11033)
            return false;
        if (getItemMotion() > 0 && getInputChutes().isEmpty())
            return false;
        return AbstractChuteBlock.isOpenChute(blockState);
    }

    @Override
    public void initialize() {
        super.initialize();
        onAdded();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(field_11867).method_1012(0, -3, 0);
    }

    @Override
    public void tick() {
        super.tick();

        if (!field_11863.method_8608())
            canPickUpItems = canDirectlyInsert();

        boolean clientSide = field_11863 != null && field_11863.method_8608() && !isVirtual();
        float itemMotion = getItemMotion();
        if (itemMotion != 0 && field_11863 != null && field_11863.method_8608())
            spawnParticles(itemMotion);
        tickAirStreams(itemMotion);

        if (item.method_7960() && !clientSide) {
            if (itemMotion < 0)
                handleInputFromAbove();
            if (itemMotion > 0)
                handleInputFromBelow();
            return;
        }

        float nextOffset = itemPosition.getValue() + itemMotion;

        if (itemMotion < 0) {
            if (nextOffset < .5f) {
                if (!handleDownwardOutput(true))
                    nextOffset = .5f;
                else if (nextOffset < 0) {
                    handleDownwardOutput(clientSide);
                    nextOffset = itemPosition.getValue();
                }
            }
        } else if (itemMotion > 0) {
            if (nextOffset > .5f) {
                if (!handleUpwardOutput(true))
                    nextOffset = .5f;
                else if (nextOffset > 1) {
                    handleUpwardOutput(clientSide);
                    nextOffset = itemPosition.getValue();
                }
            }
        }

        itemPosition.setValue(nextOffset);
    }

    private void updateAirFlow(float itemSpeed) {
        updateAirFlow = false;
        if (itemSpeed > 0 && field_11863 != null && !field_11863.method_8608()) {
            float speed = pull - push;
            beltBelow = null;

            float maxPullDistance;
            if (speed >= 128)
                maxPullDistance = 3;
            else if (speed >= 64)
                maxPullDistance = 2;
            else if (speed >= 32)
                maxPullDistance = 1;
            else
                maxPullDistance = class_3532.method_48781(speed / 32, 0, 1);

            if (AbstractChuteBlock.isChute(field_11863.method_8320(field_11867.method_10074())))
                maxPullDistance = 0;
            float flowLimit = maxPullDistance;
            if (flowLimit > 0)
                flowLimit = AirCurrent.getFlowLimit(field_11863, field_11867, maxPullDistance, class_2350.field_11033);

            for (int i = 1; i <= flowLimit + 1; i++) {
                TransportedItemStackHandlerBehaviour behaviour = BlockEntityBehaviour.get(
                    field_11863,
                    field_11867.method_10087(i),
                    TransportedItemStackHandlerBehaviour.TYPE
                );
                if (behaviour == null)
                    continue;
                beltBelow = behaviour;
                beltBelowOffset = i - 1;
                break;
            }
            this.bottomPullDistance = Math.max(0, flowLimit);
        }
        sendData();
    }

    private void findEntities(float itemSpeed) {
        if (bottomPullDistance <= 0 && !getItem().method_7960() || itemSpeed <= 0 || field_11863 == null || field_11863.method_8608())
            return;
        if (!canActivate())
            return;
        class_243 center = VecHelper.getCenterOf(field_11867);
        class_238 searchArea = new class_238(center.method_1031(0, -bottomPullDistance - 0.5, 0), center.method_1031(0, -0.5, 0)).method_1014(.45f);
        for (class_1542 itemEntity : field_11863.method_18467(class_1542.class, searchArea)) {
            if (!itemEntity.method_5805())
                continue;
            class_1799 entityItem = itemEntity.method_6983();
            if (!canAcceptItem(entityItem))
                continue;
            setItem(entityItem.method_7972(), (float) (itemEntity.method_5829().method_1005().field_1351 - field_11867.method_10264()));
            itemEntity.method_31472();
            break;
        }
    }

    private void extractFromBelt(float itemSpeed) {
        if (itemSpeed <= 0 || field_11863 == null || field_11863.method_8608())
            return;
        if (getItem().method_7960() && beltBelow != null) {
            beltBelow.handleCenteredProcessingOnAllItems(
                .5f, ts -> {
                    if (canAcceptItem(ts.stack)) {
                        setItem(ts.stack.method_7972(), -beltBelowOffset);
                        return TransportedResult.removeItem();
                    }
                    return TransportedResult.doNothing();
                }
            );
        }
    }

    private void tickAirStreams(float itemSpeed) {
        if (!field_11863.method_8608() && airCurrentUpdateCooldown-- <= 0) {
            airCurrentUpdateCooldown = AllConfigs.server().kinetics.fanBlockCheckRate.get();
            updateAirFlow = true;
        }

        if (updateAirFlow) {
            updateAirFlow(itemSpeed);
        }

        if (entitySearchCooldown-- <= 0 && item.method_7960()) {
            entitySearchCooldown = 5;
            findEntities(itemSpeed);
        }

        extractFromBelt(itemSpeed);
    }

    public void blockBelowChanged() {
        updateAirFlow = true;
    }

    private void spawnParticles(float itemMotion) {
        // todo: reduce the amount of particles
        if (field_11863 == null)
            return;
        class_2680 blockState = method_11010();
        boolean up = itemMotion > 0;
        float absMotion = up ? itemMotion : -itemMotion;
        if (blockState == null || !AbstractChuteBlock.isChute(blockState))
            return;
        if (push == 0 && pull == 0)
            return;

        if (up && AbstractChuteBlock.isOpenChute(blockState) && BlockHelper.noCollisionInSpace(field_11863, field_11867.method_10084()))
            spawnAirFlow(1, 2, absMotion, .5f);

        if (AbstractChuteBlock.getChuteFacing(blockState) != class_2350.field_11033)
            return;

        if (AbstractChuteBlock.isTransparentChute(blockState))
            spawnAirFlow(up ? 0 : 1, up ? 1 : 0, absMotion, 1);

        if (!up && BlockHelper.noCollisionInSpace(field_11863, field_11867.method_10074()))
            spawnAirFlow(0, -1, absMotion, .5f);

        if (up && canActivate() && bottomPullDistance > 0) {
            spawnAirFlow(-bottomPullDistance, 0, absMotion, 2);
            spawnAirFlow(-bottomPullDistance, 0, absMotion, 2);
        }
    }

    private void spawnAirFlow(float verticalStart, float verticalEnd, float motion, float drag) {
        if (field_11863 == null)
            return;
        AirParticleData airParticleData = new AirParticleData(drag, motion);
        class_243 origin = class_243.method_24954(field_11867);
        float xOff = field_11863.field_9229.method_43057() * .5f + .25f;
        float zOff = field_11863.field_9229.method_43057() * .5f + .25f;
        class_243 v = origin.method_1031(xOff, verticalStart, zOff);
        class_243 d = origin.method_1031(xOff, verticalEnd, zOff).method_1020(v);
        if (field_11863.field_9229.method_43057() < 2 * motion)
            field_11863.method_8494(airParticleData, v.field_1352, v.field_1351, v.field_1350, d.field_1352, d.field_1351, d.field_1350);
    }

    private void handleInputFromAbove() {
        handleInput(grabCapability(class_2350.field_11036), 1);
    }

    private void handleInputFromBelow() {
        handleInput(grabCapability(class_2350.field_11033), 0);
    }

    private void handleInput(@Nullable class_1263 inv, float startLocation) {
        if (inv == null)
            return;
        if (!canActivate())
            return;
        if (invVersionTracker.stillWaiting(inv))
            return;
        Predicate<class_1799> canAccept = this::canAcceptItem;
        class_1799 extracted;
        if (getExtractionMode() == ExtractionCountMode.UPTO) {
            extracted = inv.extract(canAccept, getExtractionAmount());
        } else {
            extracted = inv.preciseExtract(canAccept, getExtractionAmount());
        }
        if (!extracted.method_7960()) {
            setItem(extracted, startLocation);
            return;
        }
        invVersionTracker.awaitNewVersion(inv);
    }

    private boolean handleDownwardOutput(boolean simulate) {
        class_2680 blockState = method_11010();
        ChuteBlockEntity targetChute = getTargetChute(blockState);
        class_2350 direction = AbstractChuteBlock.getChuteFacing(blockState);

        if (field_11863 == null || direction == null || !this.canActivate())
            return false;
        class_1263 capBelow = grabCapability(class_2350.field_11033);
        if (capBelow != null) {
            if (field_11863.method_8608() && !isVirtual())
                return false;
            if (invVersionTracker.stillWaiting(capBelow))
                return false;
            if (!simulate) {
                int insert = capBelow.insertExist(item, class_2350.field_11036);
                if (insert != 0) {
                    int count = item.method_7947();
                    if (insert == count) {
                        setItem(class_1799.field_8037, itemPosition.getValue(0));
                    } else {
                        item.method_7939(count - insert);
                        setItem(item, itemPosition.getValue(0));
                    }
                    return true;
                }
            } else if (capBelow.countSpace(item, 1, class_2350.field_11036) != 0) {
                return true;
            }
            invVersionTracker.awaitNewVersion(capBelow);
            if (direction == class_2350.field_11033)
                return false;
        }

        if (targetChute != null) {
            boolean canInsert = targetChute.canAcceptItem(item);
            if (!simulate && canInsert) {
                targetChute.setItem(item, direction == class_2350.field_11033 ? 1 : .51f);
                setItem(class_1799.field_8037);
            }
            return canInsert;
        }

        // Diagonal chutes cannot drop items
        if (direction.method_10166().method_10179())
            return false;

        if (FunnelBlock.getFunnelFacing(field_11863.method_8320(field_11867.method_10074())) == class_2350.field_11033)
            return false;
        if (class_2248.method_16361(field_11863, field_11867.method_10074()))
            return false;

        if (!simulate) {
            class_243 dropVec = VecHelper.getCenterOf(field_11867).method_1031(0, -12 / 16f, 0);
            class_1542 dropped = new class_1542(field_11863, dropVec.field_1352, dropVec.field_1351, dropVec.field_1350, item.method_7972());
            dropped.method_6988();
            dropped.method_18800(0, -.25f, 0);
            field_11863.method_8649(dropped);
            setItem(class_1799.field_8037);
        }

        return true;
    }

    private boolean handleUpwardOutput(boolean simulate) {
        class_2680 stateAbove = field_11863.method_8320(field_11867.method_10084());

        if (field_11863 == null || !this.canActivate())
            return false;

        if (AbstractChuteBlock.isOpenChute(method_11010())) {
            class_1263 capAbove = grabCapability(class_2350.field_11036);
            if (capAbove != null) {
                if (field_11863.method_8608() && !isVirtual() && !ChuteBlock.isChute(stateAbove))
                    return false;
                if (invVersionTracker.stillWaiting(capAbove))
                    return false;
                if (!simulate) {
                    int insert = capAbove.insertExist(item, class_2350.field_11036);
                    if (insert != 0) {
                        int count = item.method_7947();
                        if (insert == count) {
                            item = class_1799.field_8037;
                        } else {
                            item.method_7939(count - insert);
                        }
                        return true;
                    }
                } else if (capAbove.countSpace(item, 1, class_2350.field_11036) != 0) {
                    return true;
                }
                invVersionTracker.awaitNewVersion(capAbove);
                return false;
            }
        }

        ChuteBlockEntity bestOutput = null;
        List<ChuteBlockEntity> inputChutes = getInputChutes();
        for (ChuteBlockEntity targetChute : inputChutes) {
            if (!targetChute.canAcceptItem(item))
                continue;
            float itemMotion = targetChute.getItemMotion();
            if (itemMotion < 0)
                continue;
            if (bestOutput == null || bestOutput.getItemMotion() < itemMotion) {
                bestOutput = targetChute;
            }
        }

        if (bestOutput != null) {
            if (!simulate) {
                bestOutput.setItem(item, 0);
                setItem(class_1799.field_8037);
            }
            return true;
        }

        if (FunnelBlock.getFunnelFacing(field_11863.method_8320(field_11867.method_10084())) == class_2350.field_11036)
            return false;
        if (BlockHelper.hasBlockSolidSide(stateAbove, field_11863, field_11867.method_10084(), class_2350.field_11033))
            return false;
        if (!inputChutes.isEmpty())
            return false;

        if (!simulate) {
            class_243 dropVec = VecHelper.getCenterOf(field_11867).method_1031(0, 8 / 16f, 0);
            class_1542 dropped = new class_1542(field_11863, dropVec.field_1352, dropVec.field_1351, dropVec.field_1350, item.method_7972());
            dropped.method_6988();
            dropped.method_18800(0, getItemMotion() * 2, 0);
            field_11863.method_8649(dropped);
            setItem(class_1799.field_8037);
        }
        return true;
    }

    protected boolean canAcceptItem(class_1799 stack) {
        return item.method_7960();
    }

    protected int getExtractionAmount() {
        return 16;
    }

    protected ExtractionCountMode getExtractionMode() {
        return ExtractionCountMode.UPTO;
    }

    protected boolean canActivate() {
        return true;
    }

    private boolean canAcceptBlockEntity(class_2586 be, @Nullable class_2350 opposite) {
        if (be instanceof ChuteBlockEntity) {
            return opposite == class_2350.field_11036 && be instanceof SmartChuteBlockEntity && !(getItemMotion() > 0);
        }
        return true;
    }

    private @Nullable class_1263 grabCapability(@NotNull class_2350 side) {
        class_2338 pos = this.field_11867.method_10093(side);
        if (field_11863 == null)
            return null;
        Supplier<class_1263> supplier = capCaches.get(side);
        if (supplier == null) {
            class_2350 opposite = side.method_10153();
            if (field_11863 instanceof class_3218 serverLevel) {
                Supplier<class_1263> cache = ItemHelper.getInventoryCache(serverLevel, pos, opposite, this::canAcceptBlockEntity);
                capCaches.put(side, cache);
                return cache.get();
            } else {
                class_2586 be = field_11863.method_8321(pos);
                if (canAcceptBlockEntity(be, side)) {
                    return ItemHelper.getInventory(field_11863, pos, null, be, opposite);
                }
                return null;
            }
        } else {
            return supplier.get();
        }
    }

    public void setItem(class_1799 stack) {
        setItem(stack, getItemMotion() < 0 ? 1 : 0);
    }

    public void setItem(class_1799 stack, float insertionPos) {
        item = stack;
        itemPosition.startWithValue(insertionPos);
        invVersionTracker.reset();
        if (!field_11863.method_8608()) {
            notifyUpdate();
            award(AllAdvancements.CHUTE);
        }
    }

    @Override
    public void invalidate() {
        capCaches.clear();
        super.invalidate();
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (!item.method_7960()) {
            view.method_71468("Item", class_1799.field_24671, item);
        }
        view.method_71464("ItemPosition", itemPosition.getValue());
        view.method_71464("Pull", pull);
        view.method_71464("Push", push);
        view.method_71464("BottomAirFlowDistance", bottomPullDistance);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        class_1799 previousItem = item;
        item = view.method_71426("Item", class_1799.field_24671).orElse(class_1799.field_8037);
        itemPosition.startWithValue(view.method_71423("ItemPosition", 0));
        pull = view.method_71423("Pull", 0);
        push = view.method_71423("Push", 0);
        bottomPullDistance = view.method_71423("BottomAirFlowDistance", 0);
        super.read(view, clientPacket);

        if (method_11002() && field_11863 != null && field_11863.method_8608() && !class_1799.method_7973(previousItem, item) && !item.method_7960()) {
            if (field_11863.field_9229.method_43048(3) != 0)
                return;
            class_243 p = VecHelper.getCenterOf(field_11867);
            p = VecHelper.offsetRandomly(p, field_11863.field_9229, .5f);
            class_243 m = class_243.field_1353;
            field_11863.method_8406(new class_2392(class_2398.field_11218, item), p.field_1352, p.field_1351, p.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public float getItemMotion() {
        // Chutes per second
        final float fanSpeedModifier = 1 / 64f;
        final float maxItemSpeed = 20f;
        final float gravity = 4f;

        float motion = (push + pull) * fanSpeedModifier;
        return (class_3532.method_15363(motion, -maxItemSpeed, maxItemSpeed) + (motion <= 0 ? -gravity : 0)) / 20f;
    }

    @Override
    public void destroy() {
        super.destroy();
        ChuteBlockEntity targetChute = getTargetChute(method_11010());
        List<ChuteBlockEntity> inputChutes = getInputChutes();
        if (!item.method_7960() && field_11863 != null)
            class_1264.method_5449(field_11863, field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), item);
        method_11012();
        if (targetChute != null) {
            targetChute.updatePull();
            targetChute.propagatePush();
        }
        inputChutes.forEach(c -> c.updatePush(inputChutes.size()));
    }

    public void onAdded() {
        refreshBlockState();
        updatePull();
        ChuteBlockEntity targetChute = getTargetChute(method_11010());
        if (targetChute != null)
            targetChute.propagatePush();
        else
            updatePush(1);
    }

    public void updatePull() {
        float totalPull = calculatePull();
        if (pull == totalPull)
            return;
        pull = totalPull;
        updateAirFlow = true;
        sendData();
        ChuteBlockEntity targetChute = getTargetChute(method_11010());
        if (targetChute != null)
            targetChute.updatePull();
    }

    public void updatePush(int branchCount) {
        float totalPush = calculatePush(branchCount);
        if (push == totalPush)
            return;
        updateAirFlow = true;
        push = totalPush;
        sendData();
        propagatePush();
    }

    public void propagatePush() {
        List<ChuteBlockEntity> inputs = getInputChutes();
        inputs.forEach(c -> c.updatePush(inputs.size()));
    }

    protected float calculatePull() {
        class_2680 blockStateAbove = field_11863.method_8320(field_11867.method_10084());
        if (blockStateAbove.method_27852(AllBlocks.ENCASED_FAN) && blockStateAbove.method_11654(EncasedFanBlock.FACING) == class_2350.field_11033) {
            class_2586 be = field_11863.method_8321(field_11867.method_10084());
            if (be instanceof EncasedFanBlockEntity fan && !be.method_11015()) {
                return fan.getSpeed();
            }
        }

        float totalPull = 0;
        for (class_2350 d : Iterate.directions) {
            ChuteBlockEntity inputChute = getInputChute(d);
            if (inputChute == null)
                continue;
            totalPull += inputChute.pull;
        }
        return totalPull;
    }

    protected float calculatePush(int branchCount) {
        if (field_11863 == null)
            return 0;
        class_2680 blockStateBelow = field_11863.method_8320(field_11867.method_10074());
        if (blockStateBelow.method_27852(AllBlocks.ENCASED_FAN) && blockStateBelow.method_11654(EncasedFanBlock.FACING) == class_2350.field_11036) {
            class_2586 be = field_11863.method_8321(field_11867.method_10074());
            if (be instanceof EncasedFanBlockEntity fan && !be.method_11015()) {
                return fan.getSpeed();
            }
        }

        ChuteBlockEntity targetChute = getTargetChute(method_11010());
        if (targetChute == null)
            return 0;
        return targetChute.push / branchCount;
    }

    @Nullable
    private ChuteBlockEntity getTargetChute(class_2680 state) {
        if (field_11863 == null)
            return null;
        class_2350 targetDirection = AbstractChuteBlock.getChuteFacing(state);
        if (targetDirection == null)
            return null;
        class_2338 chutePos = field_11867.method_10074();
        if (targetDirection.method_10166().method_10179())
            chutePos = chutePos.method_10093(targetDirection.method_10153());
        class_2680 chuteState = field_11863.method_8320(chutePos);
        if (!AbstractChuteBlock.isChute(chuteState))
            return null;
        class_2586 be = field_11863.method_8321(chutePos);
        if (be instanceof ChuteBlockEntity)
            return (ChuteBlockEntity) be;
        return null;
    }

    private List<ChuteBlockEntity> getInputChutes() {
        List<ChuteBlockEntity> inputs = new LinkedList<>();
        for (class_2350 d : Iterate.directions) {
            ChuteBlockEntity inputChute = getInputChute(d);
            if (inputChute == null)
                continue;
            inputs.add(inputChute);
        }
        return inputs;
    }

    @Nullable
    private ChuteBlockEntity getInputChute(class_2350 direction) {
        if (field_11863 == null || direction == class_2350.field_11033)
            return null;
        direction = direction.method_10153();
        class_2338 chutePos = field_11867.method_10084();
        if (direction.method_10166().method_10179())
            chutePos = chutePos.method_10093(direction);
        class_2680 chuteState = field_11863.method_8320(chutePos);
        class_2350 chuteFacing = AbstractChuteBlock.getChuteFacing(chuteState);
        if (chuteFacing != direction)
            return null;
        class_2586 be = field_11863.method_8321(chutePos);
        if (be instanceof ChuteBlockEntity && !be.method_11015())
            return (ChuteBlockEntity) be;
        return null;
    }

    public class_1799 getItem() {
        return item;
    }
}
