package com.zurrtum.create.content.logistics.factoryBoard;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.zurrtum.create.*;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.codecs.CatnipCodecs;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour.RequestType;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsManager;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromise;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrder;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.FactoryPanelEffectPacket;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11372.class_11373;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_4844;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7708;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9694;
import net.minecraft.core.*;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

import java.lang.ref.WeakReference;
import java.util.*;
import java.util.stream.Collectors;

public class ServerFactoryPanelBehaviour extends ServerFilteringBehaviour implements MenuProvider {
    private static final Codec<Set<FactoryPanelPosition>> TARGET_CODEC = CatnipCodecs.set(FactoryPanelPosition.CODEC);
    private static final Codec<List<BigItemStack>> CRAFTING_LIST_CODEC = BigItemStack.CODEC.listOf();

    public static final BehaviourType<ServerFactoryPanelBehaviour> TOP_LEFT = new BehaviourType<>();
    public static final BehaviourType<ServerFactoryPanelBehaviour> TOP_RIGHT = new BehaviourType<>();
    public static final BehaviourType<ServerFactoryPanelBehaviour> BOTTOM_LEFT = new BehaviourType<>();
    public static final BehaviourType<ServerFactoryPanelBehaviour> BOTTOM_RIGHT = new BehaviourType<>();

    public Map<FactoryPanelPosition, FactoryPanelConnection> targetedBy;
    public Map<class_2338, FactoryPanelConnection> targetedByLinks;
    public Set<FactoryPanelPosition> targeting;
    public List<class_1799> activeCraftingArrangement;
    public List<BigItemStack> craftingList;

    public boolean satisfied;
    public boolean promisedSatisfied;
    public boolean waitingForNetwork;
    public String recipeAddress;
    public int recipeOutput;
    public LerpedFloat bulb;
    public PanelSlot slot;
    public int promiseClearingInterval;
    public boolean forceClearPromises;
    public UUID network;
    public boolean active;

    public boolean redstonePowered;

    public RequestPromiseQueue restockerPromises;
    private boolean promisePrimedForMarkDirty;

    private int lastReportedUnloadedLinks;
    private int lastReportedLevelInStorage;
    private int lastReportedPromises;
    private int timer;

    public ServerFactoryPanelBehaviour(FactoryPanelBlockEntity be, PanelSlot slot) {
        super(be);
        this.slot = slot;
        this.targetedBy = new HashMap<>();
        this.targetedByLinks = new HashMap<>();
        this.targeting = new HashSet<>();
        this.count = 0;
        this.satisfied = false;
        this.promisedSatisfied = false;
        this.waitingForNetwork = false;
        this.activeCraftingArrangement = List.of();
        this.recipeAddress = "";
        this.recipeOutput = 1;
        this.active = false;
        this.forceClearPromises = false;
        this.redstonePowered = false;
        this.promiseClearingInterval = -1;
        this.bulb = LerpedFloat.linear().startWithValue(0).chase(0, 0.175, Chaser.EXP);
        this.restockerPromises = new RequestPromiseQueue(be::method_5431);
        this.promisePrimedForMarkDirty = true;
        this.network = UUID.randomUUID();
        setLazyTickRate(40);
    }

    public void setNetwork(UUID network) {
        this.network = network;
    }

    @Nullable
    public static ServerFactoryPanelBehaviour at(class_1920 world, FactoryPanelConnection connection) {
        Object cached = connection.cachedSource.get();
        if (cached instanceof ServerFactoryPanelBehaviour fbe && !fbe.blockEntity.method_11015())
            return fbe;
        ServerFactoryPanelBehaviour result = at(world, connection.from);
        connection.cachedSource = new WeakReference<>(result);
        return result;
    }

    @Nullable
    public static ServerFactoryPanelBehaviour at(class_1920 world, FactoryPanelPosition pos) {
        if (world instanceof class_1937 l && !l.method_8477(pos.pos()))
            return null;
        if (!(world.method_8321(pos.pos()) instanceof FactoryPanelBlockEntity fpbe))
            return null;
        ServerFactoryPanelBehaviour behaviour = fpbe.panels.get(pos.slot());
        if (!behaviour.active)
            return null;
        return behaviour;
    }

    @Nullable
    public static FactoryPanelSupportBehaviour linkAt(class_1920 world, FactoryPanelConnection connection) {
        Object cached = connection.cachedSource.get();
        if (cached instanceof FactoryPanelSupportBehaviour fpsb && !fpsb.blockEntity.method_11015())
            return fpsb;
        FactoryPanelSupportBehaviour result = linkAt(world, connection.from);
        connection.cachedSource = new WeakReference<>(result);
        return result;
    }

    @Nullable
    public static FactoryPanelSupportBehaviour linkAt(class_1920 world, FactoryPanelPosition pos) {
        if (world instanceof class_1937 l && !l.method_8477(pos.pos()))
            return null;
        return BlockEntityBehaviour.get(world, pos.pos(), FactoryPanelSupportBehaviour.TYPE);
    }

    public void moveTo(FactoryPanelPosition newPos, class_3222 player) {
        class_1937 level = getLevel();
        class_2680 existingState = level.method_8320(newPos.pos());

        // Check if target pos is valid
        if (ServerFactoryPanelBehaviour.at(level, newPos) != null)
            return;
        boolean isAddedToOtherGauge = existingState.method_27852(AllBlocks.FACTORY_GAUGE);
        if (!existingState.method_26215() && !isAddedToOtherGauge)
            return;
        if (isAddedToOtherGauge && existingState != blockEntity.method_11010())
            return;
        if (!isAddedToOtherGauge)
            level.method_8652(newPos.pos(), blockEntity.method_11010(), class_2248.field_31036);

        for (class_2338 blockPos : targetedByLinks.keySet())
            if (!blockPos.method_19771(newPos.pos(), 24))
                return;
        for (FactoryPanelPosition blockPos : targetedBy.keySet())
            if (!blockPos.pos().method_19771(newPos.pos(), 24))
                return;
        for (FactoryPanelPosition blockPos : targeting)
            if (!blockPos.pos().method_19771(newPos.pos(), 24))
                return;

        // Disconnect links
        for (class_2338 pos : targetedByLinks.keySet()) {
            FactoryPanelSupportBehaviour at = linkAt(level, new FactoryPanelPosition(pos, slot));
            if (at != null)
                at.disconnect(this);
        }

        SmartBlockEntity oldBE = blockEntity;
        FactoryPanelPosition oldPos = getPanelPosition();
        moveToSlot(newPos.slot());

        // Add to new BE
        if (level.method_8321(newPos.pos()) instanceof FactoryPanelBlockEntity fpbe) {
            fpbe.attachBehaviourLate(this);
            fpbe.panels.put(slot, this);
            fpbe.redraw = true;
            fpbe.lastShape = null;
            fpbe.notifyUpdate();
        }

        // Remove from old BE
        if (oldBE instanceof FactoryPanelBlockEntity fpbe) {
            ServerFactoryPanelBehaviour newBehaviour = new ServerFactoryPanelBehaviour(fpbe, oldPos.slot());
            fpbe.attachBehaviourLate(newBehaviour);
            fpbe.panels.put(oldPos.slot(), newBehaviour);
            fpbe.redraw = true;
            fpbe.lastShape = null;
            fpbe.notifyUpdate();
        }

        // Rewire connections
        for (FactoryPanelPosition position : targeting) {
            ServerFactoryPanelBehaviour at = at(level, position);
            if (at != null) {
                FactoryPanelConnection connection = at.targetedBy.remove(oldPos);
                connection.from = newPos;
                at.targetedBy.put(newPos, connection);
                at.blockEntity.sendData();
            }
        }

        for (FactoryPanelPosition position : targetedBy.keySet()) {
            ServerFactoryPanelBehaviour at = at(level, position);
            if (at != null) {
                at.targeting.remove(oldPos);
                at.targeting.add(newPos);
            }
        }

        // Reconnect links
        for (class_2338 pos : targetedByLinks.keySet()) {
            FactoryPanelSupportBehaviour at = linkAt(level, new FactoryPanelPosition(pos, slot));
            if (at != null)
                at.connect(this);
        }

        // Tell player
        player.method_7353(class_2561.method_43471("create.factory_panel.relocated").method_27692(class_124.field_1060), true);
        player.method_51469().method_8396(null, newPos.pos(), class_3417.field_26960, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void moveToSlot(PanelSlot slot) {
        this.slot = slot;
        if (getLevel().method_8608()) {
            AllClientHandle.INSTANCE.factoryPanelMoveToSlot(blockEntity, slot);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        notifyRedstoneOutputs();
    }

    @Override
    public void tick() {
        super.tick();
        if (getLevel().method_8608()) {
            if (blockEntity.isVirtual())
                tickStorageMonitor();
            bulb.updateChaseTarget(redstonePowered || satisfied ? 1 : 0);
            bulb.tickChaser();
            return;
        }

        if (!promisePrimedForMarkDirty) {
            restockerPromises.setOnChanged(blockEntity::method_5431);
            promisePrimedForMarkDirty = true;
        }

        tickStorageMonitor();
        tickRequests();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (getLevel().method_8608())
            return;
        checkForRedstoneInput();
    }

    public void checkForRedstoneInput() {
        if (!active)
            return;

        boolean shouldPower = false;
        for (FactoryPanelConnection connection : targetedByLinks.values()) {
            if (!getLevel().method_8477(connection.from.pos()))
                return;
            FactoryPanelSupportBehaviour linkAt = linkAt(getLevel(), connection);
            if (linkAt == null)
                return;
            shouldPower |= linkAt.shouldPanelBePowered();
        }

        if (shouldPower == redstonePowered)
            return;

        redstonePowered = shouldPower;
        blockEntity.notifyUpdate();
        timer = 1;
    }

    private void notifyRedstoneOutputs() {
        for (FactoryPanelConnection connection : targetedByLinks.values()) {
            if (!getLevel().method_8477(connection.from.pos()))
                return;
            FactoryPanelSupportBehaviour linkAt = linkAt(getLevel(), connection);
            if (linkAt == null || linkAt.isOutput())
                return;
            linkAt.notifyLink();
        }
    }

    private void tickStorageMonitor() {
        class_1799 filter = getFilter();
        int unloadedLinkCount = getUnloadedLinks();
        FactoryPanelBlockEntity panelBE = panelBE();
        if (!panelBE.restocker && unloadedLinkCount == 0 && lastReportedUnloadedLinks != 0) {
            // All links have been loaded, invalidate cache so we can get an accurate summary!
            // Otherwise, we will have to wait for 20 ticks and unnecessary packages will be sent!
            LogisticsManager.SUMMARIES.invalidate(network);
        }
        int inStorage = getLevelInStorage();
        int promised = getPromised();
        int demand = getAmount() * (upTo ? 1 : filter.method_7914());
        boolean shouldSatisfy = filter.method_7960() || inStorage >= demand;
        boolean shouldPromiseSatisfy = filter.method_7960() || inStorage + promised >= demand;
        boolean shouldWait = unloadedLinkCount > 0;

        if (lastReportedLevelInStorage == inStorage && lastReportedPromises == promised && lastReportedUnloadedLinks == unloadedLinkCount && satisfied == shouldSatisfy && promisedSatisfied == shouldPromiseSatisfy && waitingForNetwork == shouldWait)
            return;

        if (!satisfied && shouldSatisfy && demand > 0) {
            AllSoundEvents.CONFIRM.playOnServer(getLevel(), getPos(), 0.075f, 1f);
            AllSoundEvents.CONFIRM_2.playOnServer(getLevel(), getPos(), 0.125f, 0.575f);
        }

        boolean notifyOutputs = satisfied != shouldSatisfy;
        lastReportedLevelInStorage = inStorage;
        satisfied = shouldSatisfy;
        lastReportedPromises = promised;
        promisedSatisfied = shouldPromiseSatisfy;
        lastReportedUnloadedLinks = unloadedLinkCount;
        waitingForNetwork = shouldWait;
        if (!getLevel().method_8608())
            blockEntity.sendData();
        if (notifyOutputs)
            notifyRedstoneOutputs();
    }

    public static class ItemStackConnections extends ArrayList<FactoryPanelConnection> {
        public class_1799 item;
        public int totalAmount;

        public ItemStackConnections(class_1799 item) {
            this.item = item;
        }
    }

    private void tickRequests() {
        FactoryPanelBlockEntity panelBE = panelBE();
        if (targetedBy.isEmpty() && !panelBE.restocker)
            return;
        if (panelBE.restocker)
            restockerPromises.tick();
        if (satisfied || promisedSatisfied || waitingForNetwork || redstonePowered)
            return;
        if (timer > 0) {
            timer = Math.min(timer, getConfigRequestIntervalInTicks());
            timer--;
            return;
        }

        resetTimer();

        if (recipeAddress.isBlank())
            return;

        if (panelBE.restocker) {
            tryRestock();
            return;
        }

        boolean failed = false;

        Map<UUID, Map<class_1799, ItemStackConnections>> consolidated = new HashMap<>();

        for (FactoryPanelConnection connection : targetedBy.values()) {
            ServerFactoryPanelBehaviour source = at(getLevel(), connection);
            if (source == null)
                return;

            class_1799 item = source.getFilter();

            Map<class_1799, ItemStackConnections> networkItemCounts = consolidated.computeIfAbsent(
                source.network,
                $ -> new Object2ObjectOpenCustomHashMap<>(class_7708.field_40212)
            );
            networkItemCounts.computeIfAbsent(item, $ -> new ItemStackConnections(item));
            ItemStackConnections existingConnections = networkItemCounts.get(item);
            existingConnections.add(connection);
            existingConnections.totalAmount += connection.amount;
        }

        Multimap<UUID, BigItemStack> toRequest = HashMultimap.create();

        for (Map.Entry<UUID, Map<class_1799, ItemStackConnections>> entry : consolidated.entrySet()) {
            UUID network = entry.getKey();
            InventorySummary summary = LogisticsManager.getSummaryOfNetwork(network, true);

            for (ItemStackConnections connections : entry.getValue().values()) {
                if (connections.totalAmount == 0 || connections.item.method_7960() || summary.getCountOf(connections.item) < connections.totalAmount) {
                    for (FactoryPanelConnection connection : connections)
                        sendEffect(connection.from, false);
                    failed = true;
                    continue;
                }

                BigItemStack stack = new BigItemStack(connections.item, connections.totalAmount);
                toRequest.put(network, stack);
                for (FactoryPanelConnection connection : connections)
                    sendEffect(connection.from, true);
            }
        }

        if (failed)
            return;

        // Input items may come from differing networks
        Map<UUID, Collection<BigItemStack>> asMap = toRequest.asMap();
        PackageOrderWithCrafts craftingContext = PackageOrderWithCrafts.empty();
        List<Multimap<PackagerBlockEntity, PackagingRequest>> requests = new ArrayList<>();

        // Panel may enforce item arrangement
        if (!activeCraftingArrangement.isEmpty())
            craftingContext = PackageOrderWithCrafts.singleRecipe(activeCraftingArrangement.stream()
                .map(stack -> new BigItemStack(stack.method_46651(1))).toList());

        // Collect request distributions
        for (Map.Entry<UUID, Collection<BigItemStack>> entry : asMap.entrySet()) {
            PackageOrderWithCrafts order = new PackageOrderWithCrafts(
                new PackageOrder(new ArrayList<>(entry.getValue())),
                craftingContext.orderedCrafts()
            );
            Multimap<PackagerBlockEntity, PackagingRequest> request = LogisticsManager.findPackagersForRequest(
                entry.getKey(),
                order,
                null,
                recipeAddress
            );
            requests.add(request);
        }

        // Check if any packager is busy - cancel all
        for (Multimap<PackagerBlockEntity, PackagingRequest> entry : requests)
            for (PackagerBlockEntity packager : entry.keySet())
                if (packager.isTooBusyFor(RequestType.RESTOCK))
                    return;

        // Send it
        for (Multimap<PackagerBlockEntity, PackagingRequest> entry : requests)
            LogisticsManager.performPackageRequests(entry);

        // Keep the output promise
        RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(network);
        if (promises != null)
            promises.add(new RequestPromise(new BigItemStack(getFilter(), recipeOutput)));

        panelBE.award(AllAdvancements.FACTORY_GAUGE);
    }

    private void tryRestock() {
        class_1799 item = getFilter();
        if (item.method_7960())
            return;

        FactoryPanelBlockEntity panelBE = panelBE();
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null || !packager.targetInventory.hasInventory())
            return;

        int availableOnNetwork = LogisticsManager.getStockOf(network, item, packager.targetInventory.getIdentifiedInventory());
        if (availableOnNetwork == 0) {
            sendEffect(getPanelPosition(), false);
            return;
        }

        int inStorage = getLevelInStorage();
        int promised = getPromised();
        int maxStackSize = item.method_7914();
        int demand = getAmount() * (upTo ? 1 : maxStackSize);
        int amountToOrder = Math.clamp(demand - promised - inStorage, 0, maxStackSize * 9);

        BigItemStack orderedItem = new BigItemStack(item, Math.min(amountToOrder, availableOnNetwork));
        PackageOrderWithCrafts order = PackageOrderWithCrafts.simple(List.of(orderedItem));

        sendEffect(getPanelPosition(), true);

        if (!LogisticsManager.broadcastPackageRequest(
            network,
            RequestType.RESTOCK,
            order,
            packager.targetInventory.getIdentifiedInventory(),
            recipeAddress
        ))
            return;

        restockerPromises.add(new RequestPromise(orderedItem));
    }

    private void sendEffect(FactoryPanelPosition fromPos, boolean success) {
        if (getLevel() instanceof class_3218 serverLevel) {
            class_2338 pos = getPos();
            serverLevel.method_8503().method_3760().method_14605(
                null,
                pos.method_10263(),
                pos.method_10264(),
                pos.method_10260(),
                64,
                serverLevel.method_27983(),
                new FactoryPanelEffectPacket(fromPos, getPanelPosition(), success)
            );
        }
    }

    public void addConnection(FactoryPanelPosition fromPos) {
        FactoryPanelSupportBehaviour link = linkAt(getLevel(), fromPos);
        if (link != null) {
            targetedByLinks.put(fromPos.pos(), new FactoryPanelConnection(fromPos, 1));
            link.connect(this);
            blockEntity.notifyUpdate();
            return;
        }

        if (panelBE().restocker)
            return;
        if (targetedBy.size() >= 9)
            return;

        ServerFactoryPanelBehaviour source = at(getLevel(), fromPos);
        if (source == null)
            return;

        source.targeting.add(getPanelPosition());
        targetedBy.put(fromPos, new FactoryPanelConnection(fromPos, 1));
        searchForCraftingRecipe();
        blockEntity.notifyUpdate();
    }

    public FactoryPanelPosition getPanelPosition() {
        return new FactoryPanelPosition(getPos(), slot);
    }

    public FactoryPanelBlockEntity panelBE() {
        return (FactoryPanelBlockEntity) blockEntity;
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        // Network is protected
        if (!Create.LOGISTICS.mayInteract(network, player)) {
            player.method_7353(class_2561.method_43471("create.logistically_linked.protected").method_27692(class_124.field_1061), true);
            return;
        }

        boolean isClientSide = player.method_73183().method_8608();

        // Wrench cycles through arrow bending
        class_1799 heldItem = player.method_5998(hand);
        if (targeting.size() + targetedByLinks.size() > 0 && heldItem.method_31573(AllItemTags.TOOLS_WRENCH)) {
            int sharedMode = -1;
            boolean notifySelf = false;

            for (FactoryPanelPosition target : targeting) {
                ServerFactoryPanelBehaviour at = at(getLevel(), target);
                if (at == null)
                    continue;
                FactoryPanelConnection connection = at.targetedBy.get(getPanelPosition());
                if (connection == null)
                    continue;
                if (sharedMode == -1)
                    sharedMode = (connection.arrowBendMode + 1) % 4;
                connection.arrowBendMode = sharedMode;
                if (!isClientSide)
                    at.blockEntity.notifyUpdate();
            }

            for (FactoryPanelConnection connection : targetedByLinks.values()) {
                if (sharedMode == -1)
                    sharedMode = (connection.arrowBendMode + 1) % 4;
                connection.arrowBendMode = sharedMode;
                if (!isClientSide)
                    notifySelf = true;
            }

            if (sharedMode == -1)
                return;

            char[] boxes = "□□□□".toCharArray();
            boxes[sharedMode] = '■';
            player.method_7353(class_2561.method_43469("create.factory_panel.cycled_arrow_path", new String(boxes)), true);
            if (notifySelf)
                blockEntity.notifyUpdate();

            return;
        }

        // Client might be in the process of connecting a panel
        if (isClientSide)
            if (AllClientHandle.INSTANCE.factoryPanelClicked(getLevel(), player, this))
                return;

        if (getFilter().method_7960()) {
            // Open screen for setting an item through JEI
            if (heldItem.method_7960()) {
                if (!isClientSide && player instanceof class_3222 sp)
                    openHandledScreen(sp);
                return;
            }

            // Use regular filter interaction for setting the item
            super.onShortInteract(player, hand, side, hitResult);
            return;
        }

        // Bind logistics items to this panels' frequency
        if (heldItem.method_7909() instanceof LogisticallyLinkedBlockItem) {
            if (!isClientSide)
                LogisticallyLinkedBlockItem.assignFrequency(heldItem, player, network);
            return;
        }

        // Open configuration screen
        if (isClientSide)
            AllClientHandle.INSTANCE.openFactoryPanelScreen(this, player);
    }

    public void enable() {
        active = true;
        blockEntity.notifyUpdate();
    }

    public void disable() {
        destroy();
        active = false;
        targetedBy = new HashMap<>();
        targeting = new HashSet<>();
        count = 0;
        satisfied = false;
        promisedSatisfied = false;
        recipeAddress = "";
        recipeOutput = 1;
        setFilter(class_1799.field_8037);
        blockEntity.notifyUpdate();
    }

    @Override
    public boolean isActive() {
        return active;
    }

    public boolean isMissingAddress() {
        return (!targetedBy.isEmpty() || panelBE().restocker) && count != 0 && recipeAddress.isBlank();
    }

    @Override
    public void destroy() {
        disconnectAll();
        super.destroy();
    }

    public void disconnectAll() {
        FactoryPanelPosition panelPosition = getPanelPosition();
        disconnectAllLinks();
        for (FactoryPanelConnection connection : targetedBy.values()) {
            ServerFactoryPanelBehaviour source = at(getLevel(), connection);
            if (source != null) {
                source.targeting.remove(panelPosition);
                source.blockEntity.sendData();
            }
        }
        for (FactoryPanelPosition position : targeting) {
            ServerFactoryPanelBehaviour target = at(getLevel(), position);
            if (target != null) {
                target.targetedBy.remove(panelPosition);
                target.searchForCraftingRecipe();
                target.blockEntity.sendData();
            }
        }
        targetedBy.clear();
        targeting.clear();
    }

    public void disconnectAllLinks() {
        for (FactoryPanelConnection connection : targetedByLinks.values()) {
            FactoryPanelSupportBehaviour source = linkAt(getLevel(), connection);
            if (source != null)
                source.disconnect(this);
        }
        targetedByLinks.clear();
    }

    public int getUnloadedLinks() {
        if (getLevel().method_8608())
            return lastReportedUnloadedLinks;
        if (panelBE().restocker)
            return panelBE().getRestockedPackager() == null ? 1 : 0;
        return Create.LOGISTICS.getUnloadedLinkCount(network);
    }

    public int getLevelInStorage() {
        if (blockEntity.isVirtual())
            return 1;
        if (getLevel().method_8608())
            return lastReportedLevelInStorage;
        if (getFilter().method_7960())
            return 0;

        InventorySummary summary = getRelevantSummary();
        return summary.getCountOf(getFilter());
    }

    private InventorySummary getRelevantSummary() {
        FactoryPanelBlockEntity panelBE = panelBE();
        if (!panelBE.restocker)
            return LogisticsManager.getSummaryOfNetwork(network, false);
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null)
            return InventorySummary.EMPTY;
        return packager.getAvailableItems();
    }

    public int getPromised() {
        if (getLevel().method_8608())
            return lastReportedPromises;
        class_1799 item = getFilter();
        if (item.method_7960())
            return 0;

        if (panelBE().restocker) {
            if (forceClearPromises) {
                restockerPromises.forceClear(item);
                resetTimerSlightly();
            }
            forceClearPromises = false;
            return restockerPromises.getTotalPromisedAndRemoveExpired(item, getPromiseExpiryTimeInTicks());
        }

        RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(network);
        if (promises == null)
            return 0;

        if (forceClearPromises) {
            promises.forceClear(item);
            resetTimerSlightly();
        }
        forceClearPromises = false;

        return promises.getTotalPromisedAndRemoveExpired(item, getPromiseExpiryTimeInTicks());
    }

    public void resetTimer() {
        timer = getConfigRequestIntervalInTicks();
    }

    public void resetTimerSlightly() {
        timer = getConfigRequestIntervalInTicks() / 2;
    }

    private int getConfigRequestIntervalInTicks() {
        return AllConfigs.server().logistics.factoryGaugeTimer.get();
    }

    private int getPromiseExpiryTimeInTicks() {
        if (promiseClearingInterval == -1)
            return -1;
        if (promiseClearingInterval == 0)
            return 20 * 30;

        return promiseClearingInterval * 20 * 60;
    }

    @Override
    public void writeSafe(class_11372 view) {
        if (!active)
            return;

        class_11372 panelTag = view.method_71461(slot.name().toLowerCase(Locale.ROOT));
        panelTag.method_71468("Filter", FilterItemStack.CODEC, filter);
        panelTag.method_71472("UpTo", upTo);
        panelTag.method_71465("FilterAmount", count);
        panelTag.method_71468("Freq", class_4844.field_25122, network);
        panelTag.method_71469("RecipeAddress", recipeAddress);
        panelTag.method_71465("PromiseClearingInterval", -1);
        panelTag.method_71465("RecipeOutput", 1);

        if (panelBE().restocker)
            panelTag.method_71468("Promises", RequestPromiseQueue.CODEC, restockerPromises);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (!active)
            return;

        class_11372 panelTag = view.method_71461(slot.name().toLowerCase(Locale.ROOT));
        super.write(panelTag, clientPacket);

        panelTag.method_71465("Timer", timer);
        panelTag.method_71465("LastLevel", lastReportedLevelInStorage);
        panelTag.method_71465("LastPromised", lastReportedPromises);
        panelTag.method_71465("LastUnloadedLinks", lastReportedUnloadedLinks);
        panelTag.method_71472("Satisfied", satisfied);
        panelTag.method_71472("PromisedSatisfied", promisedSatisfied);
        panelTag.method_71472("Waiting", waitingForNetwork);
        panelTag.method_71472("RedstonePowered", redstonePowered);
        panelTag.method_71468("Targeting", TARGET_CODEC, targeting);
        class_11373<FactoryPanelConnection> targetedByList = panelTag.method_71467("TargetedBy", FactoryPanelConnection.CODEC);
        targetedBy.values().forEach(targetedByList::method_71484);
        class_11373<FactoryPanelConnection> targetedByLinkList = panelTag.method_71467("TargetedByLinks", FactoryPanelConnection.CODEC);
        targetedByLinks.values().forEach(targetedByLinkList::method_71484);
        panelTag.method_71469("RecipeAddress", recipeAddress);
        panelTag.method_71465("RecipeOutput", recipeOutput);
        panelTag.method_71465("PromiseClearingInterval", promiseClearingInterval);
        panelTag.method_71468("Freq", class_4844.field_25122, network);
        panelTag.method_71468("Craft", CreateCodecs.ITEM_LIST_CODEC, activeCraftingArrangement);
        if (craftingList != null) {
            panelTag.method_71468("CraftingList", CRAFTING_LIST_CODEC, craftingList);
        }

        if (panelBE().restocker && !clientPacket)
            panelTag.method_71468("Promises", RequestPromiseQueue.CODEC, restockerPromises);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        Optional<class_11368> slotView = view.method_71420(slot.name().toLowerCase(Locale.ROOT));
        if (slotView.isEmpty()) {
            active = false;
            return;
        }
        class_11368 panelTag = slotView.get();

        active = true;
        filter = panelTag.method_71426("Filter", FilterItemStack.CODEC).orElseGet(FilterItemStack::empty);
        count = panelTag.method_71424("FilterAmount", 0);
        upTo = panelTag.method_71433("UpTo", false);
        timer = panelTag.method_71424("Timer", 0);
        lastReportedLevelInStorage = panelTag.method_71424("LastLevel", 0);
        lastReportedPromises = panelTag.method_71424("LastPromised", 0);
        lastReportedUnloadedLinks = panelTag.method_71424("LastUnloadedLinks", 0);
        satisfied = panelTag.method_71433("Satisfied", false);
        promisedSatisfied = panelTag.method_71433("PromisedSatisfied", false);
        waitingForNetwork = panelTag.method_71433("Waiting", false);
        redstonePowered = panelTag.method_71433("RedstonePowered", false);
        promiseClearingInterval = panelTag.method_71424("PromiseClearingInterval", 0);
        panelTag.method_71426("Freq", class_4844.field_25122).ifPresent(uuid -> network = uuid);

        targeting.clear();
        panelTag.method_71426("Targeting", TARGET_CODEC).ifPresent(targeting::addAll);

        targetedBy.clear();
        panelTag.method_71437("TargetedBy", FactoryPanelConnection.CODEC).forEach(c -> targetedBy.put(c.from, c));

        targetedByLinks.clear();
        panelTag.method_71437("TargetedByLinks", FactoryPanelConnection.CODEC).forEach(c -> targetedByLinks.put(c.from.pos(), c));

        activeCraftingArrangement = panelTag.method_71426("Craft", CreateCodecs.ITEM_LIST_CODEC).orElseGet(List::of);
        recipeAddress = panelTag.method_71428("RecipeAddress", "");
        recipeOutput = panelTag.method_71424("RecipeOutput", 0);

        if (view.method_71433("Restocker", false) && !clientPacket) {
            Optional<RequestPromiseQueue> queue = panelTag.method_71426("Promises", RequestPromiseQueue.CODEC);
            if (queue.isPresent()) {
                restockerPromises = queue.get();
                restockerPromises.setOnChanged(() -> {
                });
            } else {
                restockerPromises = new RequestPromiseQueue(() -> {
                });
            }
            promisePrimedForMarkDirty = false;
        }

        craftingList = panelTag.method_71426("CraftingList", CRAFTING_LIST_CODEC).orElse(null);
    }

    @Override
    public boolean setFilter(class_1799 stack) {
        class_1799 filter = stack.method_7972();
        if (stack.method_7909() instanceof FilterItem)
            return false;
        this.filter = FilterItemStack.of(filter);
        searchForCraftingRecipe();
        blockEntity.method_5431();
        blockEntity.sendData();
        return true;
    }

    public void searchForCraftingRecipe() {
        if (!(getLevel() instanceof class_3218 serverWorld)) {
            return;
        }
        class_1799 output = filter.item();
        if (output.method_7960() || targetedBy.isEmpty()) {
            craftingList = null;
            return;
        }
        List<BigItemStack> inputConfig = targetedBy.values().stream().map(c -> {
            ServerFactoryPanelBehaviour b = ServerFactoryPanelBehaviour.at(serverWorld, c.from);
            return b == null ? new BigItemStack(class_1799.field_8037, 0) : new BigItemStack(b.getFilter(), c.amount);
        }).toList();

        Set<class_1792> itemsToUse = inputConfig.stream().map(b -> b.stack).filter(i -> !i.method_7960()).map(class_1799::method_7909).collect(Collectors.toSet());

        class_1792 item = output.method_7909();
        class_5455 registryManager = serverWorld.method_30349();
        class_3955 availableCraftingRecipe = serverWorld.method_64577().field_54638.method_64698(class_3956.field_17545).parallelStream().filter(entry -> {
            class_3955 recipe = entry.comp_1933();
            List<class_1856> ingredients;
            if (recipe instanceof class_1869 shapedRecipe) {
                class_1799 result;
                try {
                    result = recipe.method_8116(class_9694.field_51631, registryManager);
                } catch (Exception ignore) {
                    result = class_1799.field_8037;
                }
                if (result.method_7960()) {
                    result = shapedRecipe.field_9053;
                    if (result == null || result.method_7960()) {
                        return false;
                    }
                }
                if (result.method_7909() != item) {
                    return false;
                }
                ingredients = shapedRecipe.method_61693().stream().flatMap(Optional::stream).toList();
            } else if (recipe instanceof class_1867 shapelessRecipe) {
                class_1799 result;
                try {
                    result = recipe.method_8116(class_9694.field_51631, registryManager);
                } catch (Exception ignore) {
                    result = class_1799.field_8037;
                }
                if (result.method_7960()) {
                    result = shapelessRecipe.field_9050;
                    if (result == null || result.method_7960()) {
                        return false;
                    }
                }
                if (result.method_7909() != item) {
                    return false;
                }
                ingredients = shapelessRecipe.field_9047;
            } else {
                return false;
            }
            if (AllRecipeTypes.shouldIgnoreInAutomation(entry))
                return false;

            Set<class_1792> itemsUsed = new HashSet<>();
            for (class_1856 ingredient : ingredients) {
                if (ingredient.method_65799())
                    continue;
                boolean available = false;
                for (BigItemStack bis : inputConfig) {
                    if (!bis.stack.method_7960() && ingredient.method_8093(bis.stack)) {
                        available = true;
                        itemsUsed.add(bis.stack.method_7909());
                        break;
                    }
                }
                if (!available)
                    return false;
            }

            return itemsUsed.size() >= itemsToUse.size();
        }).findAny().map(class_8786::comp_1933).orElse(null);
        if (availableCraftingRecipe == null) {
            craftingList = null;
            return;
        }
        craftingList = convertRecipeToPackageOrderContext(availableCraftingRecipe, registryManager, inputConfig, false);
    }

    @Nullable
    public static List<BigItemStack> convertRecipeToPackageOrderContext(
        class_3955 availableCraftingRecipe,
        class_5455 registryManager,
        List<BigItemStack> inputs,
        boolean respectAmounts
    ) {
        List<class_1856> ingredients;
        if (availableCraftingRecipe instanceof class_1869 shapedRecipe) {
            ingredients = shapedRecipe.method_61693().stream().map(o -> o.orElse(null)).toList();
        } else if (availableCraftingRecipe instanceof class_1867 shapelessRecipe) {
            ingredients = shapelessRecipe.field_9047;
        } else {
            return null;
        }

        List<BigItemStack> craftingList = new ArrayList<>();
        class_1799 output = availableCraftingRecipe.method_8116(class_9694.field_51631, registryManager);
        int count = output.method_7947();
        output.method_7939(1);
        craftingList.add(new BigItemStack(output, count));

        BigItemStack emptyIngredient = new BigItemStack(class_1799.field_8037, 1);
        List<BigItemStack> mutableInputs = BigItemStack.duplicateWrappers(inputs);

        int width = Math.min(3, ingredients.size());
        int height = Math.min(3, ingredients.size() / 3 + 1);

        if (availableCraftingRecipe instanceof class_1869 shaped) {
            width = shaped.method_8150();
            height = shaped.method_8158();
        }

        if (height == 1)
            for (int i = 0; i < 3; i++)
                craftingList.add(emptyIngredient);
        if (width == 1)
            craftingList.add(emptyIngredient);

        for (int i = 0; i < ingredients.size(); i++) {
            class_1856 ingredient = ingredients.get(i);
            BigItemStack craftingIngredient = emptyIngredient;

            if (ingredient != null && !ingredient.method_65799())
                for (BigItemStack bigItemStack : mutableInputs)
                    if (bigItemStack.count > 0 && ingredient.method_8093(bigItemStack.stack)) {
                        craftingIngredient = new BigItemStack(bigItemStack.stack, 1);
                        if (respectAmounts)
                            bigItemStack.count -= 1;
                        break;
                    }

            craftingList.add(craftingIngredient);

            if (width < 3 && (i + 1) % width == 0)
                for (int j = 0; j < 3 - width; j++)
                    if (craftingList.size() < 10)
                        craftingList.add(emptyIngredient);
        }

        while (craftingList.size() < 10)
            craftingList.add(emptyIngredient);

        return craftingList;
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings settings, boolean ctrlDown) {
        if (getValueSettings().equals(settings))
            return;
        count = Math.max(0, settings.value());
        upTo = settings.row() == 0;
        panelBE().redraw = true;
        blockEntity.method_5431();
        blockEntity.sendData();
        playFeedbackSound(this);
        resetTimerSlightly();
        if (!getLevel().method_8608())
            notifyRedstoneOutputs();
    }

    @Override
    public ValueSettings getValueSettings() {
        return new ValueSettings(upTo ? 0 : 1, count);
    }

    @Override
    public int netId() {
        return 2 + slot.ordinal();
    }

    @Override
    public boolean isCountVisible() {
        return !getFilter().method_7960();
    }

    @Override
    public BehaviourType<?> getType() {
        return getTypeForSlot(slot);
    }

    public static BehaviourType<ServerFactoryPanelBehaviour> getTypeForSlot(PanelSlot slot) {
        return switch (slot) {
            case BOTTOM_LEFT -> BOTTOM_LEFT;
            case TOP_LEFT -> TOP_LEFT;
            case TOP_RIGHT -> TOP_RIGHT;
            case BOTTOM_RIGHT -> BOTTOM_RIGHT;
        };
    }

    public int getIngredientStatusColor() {
        return count == 0 || isMissingAddress() || redstonePowered ? 0x888898 : waitingForNetwork ? 0x5B3B3B : satisfied ? 0x9EFF7F : promisedSatisfied ? 0x22AFAF : 0x3D6EBD;
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return isActive() ? new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllBlocks.FACTORY_GAUGE.method_8389()) : ItemRequirement.NONE;
    }

    @Override
    public boolean canShortInteract(class_1799 toApply) {
        return true;
    }

    @Override
    public boolean readFromClipboard(class_11368 view, class_1657 player, class_2350 side, boolean simulate) {
        return false;
    }

    @Override
    public boolean canWrite(class_7225.class_7874 registries, class_2350 side) {
        return false;
    }

    @Override
    public boolean writeToClipboard(class_11372 view, class_2350 side) {
        return false;
    }

    @Override
    public FactoryPanelSetItemMenu createMenu(int containerId, class_1661 playerInventory, class_1657 player, class_9129 extraData) {
        FactoryPanelPosition.PACKET_CODEC.encode(extraData, getPanelPosition());
        return new FactoryPanelSetItemMenu(containerId, playerInventory, this);
    }

    @Override
    public class_2561 getDisplayName() {
        return blockEntity.method_11010().method_26204().method_9518();
    }

    public String getFrogAddress() {
        PackagerBlockEntity packager = panelBE().getRestockedPackager();
        if (packager == null)
            return null;
        if (packager.method_10997().method_8321(packager.method_11016().method_10084()) instanceof FrogportBlockEntity fpbe)
            if (fpbe.addressFilter != null && !fpbe.addressFilter.isBlank())
                return fpbe.addressFilter + "";
        return null;
    }

}
