package com.zurrtum.create.content.logistics.funnel;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.math.VoxelShaper;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;

import java.util.Locale;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2754;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class BeltFunnelBlock extends AbstractHorizontalFunnelBlock implements SpecialBlockItemRequirement {

    private final FunnelBlock parent;

    public static final class_2754<Shape> SHAPE = class_2754.method_11850("shape", Shape.class);

    public enum Shape implements class_3542 {
        RETRACTED(AllShapes.BELT_FUNNEL_RETRACTED),
        EXTENDED(AllShapes.BELT_FUNNEL_EXTENDED),
        PUSHING(AllShapes.BELT_FUNNEL_PERPENDICULAR),
        PULLING(AllShapes.BELT_FUNNEL_PERPENDICULAR);

        final VoxelShaper shaper;

        Shape(VoxelShaper shaper) {
            this.shaper = shaper;
        }

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public BeltFunnelBlock(FunnelBlock parent, class_2251 p_i48377_1_) {
        super(p_i48377_1_);
        this.parent = parent;
        method_9590(method_9564().method_11657(SHAPE, Shape.RETRACTED));
    }

    public static BeltFunnelBlock andesite(class_2251 settings) {
        return new BeltFunnelBlock(AllBlocks.ANDESITE_FUNNEL, settings);
    }

    public static BeltFunnelBlock brass(class_2251 settings) {
        return new BeltFunnelBlock(AllBlocks.BRASS_FUNNEL, settings);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> p_206840_1_) {
        super.method_9515(p_206840_1_.method_11667(SHAPE));
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public boolean isOfSameType(FunnelBlock otherFunnel) {
        return parent == otherFunnel;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return state.method_11654(SHAPE).shaper.get(state.method_11654(HORIZONTAL_FACING));
    }

    @Override
    public class_265 method_9549(class_2680 p_220071_1_, class_1922 p_220071_2_, class_2338 p_220071_3_, class_3726 p_220071_4_) {
        if (p_220071_4_ instanceof class_3727 && ((class_3727) p_220071_4_).method_32480() instanceof class_1542 && (p_220071_1_.method_11654(
            SHAPE) == Shape.PULLING || p_220071_1_.method_11654(SHAPE) == Shape.PUSHING))
            return AllShapes.FUNNEL_COLLISION.get(getFacing(p_220071_1_));
        return method_9530(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 stateForPlacement = super.method_9605(ctx);
        class_2338 pos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        class_2350 facing = ctx.method_8038().method_10166().method_10179() ? ctx.method_8038() : ctx.method_8042();

        class_2680 state = stateForPlacement.method_11657(HORIZONTAL_FACING, facing);
        boolean sneaking = ctx.method_8036() != null && ctx.method_8036().method_5715();
        return state.method_11657(SHAPE, getShapeForPosition(world, pos, facing, !sneaking));
    }

    public static Shape getShapeForPosition(class_1922 world, class_2338 pos, class_2350 facing, boolean extracting) {
        class_2338 posBelow = pos.method_10074();
        class_2680 stateBelow = world.method_8320(posBelow);
        Shape perpendicularState = extracting ? Shape.PUSHING : Shape.PULLING;
        if (!stateBelow.method_27852(AllBlocks.BELT))
            return perpendicularState;
        class_2350 movementFacing = stateBelow.method_11654(BeltBlock.HORIZONTAL_FACING);
        return movementFacing.method_10166() != facing.method_10166() ? perpendicularState : Shape.RETRACTED;
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return new class_1799(parent);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 p_196271_6_,
        class_2680 neighbour,
        class_5819 random
    ) {
        updateWater(world, tickView, state, pos);
        if (!isOnValidBelt(state, world, pos)) {
            class_2680 parentState = ProperWaterloggedBlock.withWater(world, parent.method_9564(), pos);
            if (state.method_61767(POWERED, false))
                parentState = parentState.method_11657(POWERED, true);
            if (state.method_11654(SHAPE) == Shape.PUSHING)
                parentState = parentState.method_11657(FunnelBlock.EXTRACTING, true);
            return parentState.method_11657(FunnelBlock.FACING, state.method_11654(HORIZONTAL_FACING));
        }
        Shape updatedShape = getShapeForPosition(world, pos, state.method_11654(HORIZONTAL_FACING), state.method_11654(SHAPE) == Shape.PUSHING);
        Shape currentShape = state.method_11654(SHAPE);
        if (updatedShape == currentShape)
            return state;

        // Don't revert wrenched states
        if (updatedShape == Shape.PUSHING && currentShape == Shape.PULLING)
            return state;
        if (updatedShape == Shape.RETRACTED && currentShape == Shape.EXTENDED)
            return state;

        return state.method_11657(SHAPE, updatedShape);
    }

    public static boolean isOnValidBelt(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 stateBelow = world.method_8320(pos.method_10074());
        if ((stateBelow.method_26204() instanceof BeltBlock))
            return BeltBlock.canTransportObjects(stateBelow);
        DirectBeltInputBehaviour directBeltInputBehaviour = BlockEntityBehaviour.get(world, pos.method_10074(), DirectBeltInputBehaviour.TYPE);
        if (directBeltInputBehaviour == null)
            return false;
        return directBeltInputBehaviour.canSupportBeltFunnels();
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        if (world.method_8608())
            return class_1269.field_5812;

        Shape shape = state.method_11654(SHAPE);
        Shape newShape = shape;
        if (shape == Shape.PULLING)
            newShape = Shape.PUSHING;
        else if (shape == Shape.PUSHING)
            newShape = Shape.PULLING;
        else if (shape == Shape.EXTENDED)
            newShape = Shape.RETRACTED;
        else if (shape == Shape.RETRACTED) {
            class_2680 belt = world.method_8320(context.method_8037().method_10074());
            if (!(belt.method_26204() instanceof BeltBlock && belt.method_11654(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL))
                newShape = Shape.EXTENDED;
        }

        if (newShape == shape)
            return class_1269.field_5812;

        world.method_8501(context.method_8037(), state.method_11657(SHAPE, newShape));

        if (newShape == Shape.EXTENDED) {
            class_2350 facing = state.method_11654(HORIZONTAL_FACING);
            class_2680 opposite = world.method_8320(context.method_8037().method_10093(facing));
            if (opposite.method_26204() instanceof BeltFunnelBlock && opposite.method_11654(SHAPE) == Shape.EXTENDED && opposite.method_11654(HORIZONTAL_FACING) == facing.method_10153())
                AllAdvancements.FUNNEL_KISS.trigger((class_3222) context.method_8036());
        }
        return class_1269.field_5812;
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, parent.method_8389());
    }

}
