package com.zurrtum.create.content.logistics.packagePort;

import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class PackagePortMenu extends MenuBase<PackagePortBlockEntity> {
    public PackagePortMenu(int id, class_1661 inv, PackagePortBlockEntity be) {
        super(AllMenuTypes.PACKAGE_PORT, id, inv, be);
        BlockEntityBehaviour.get(be, AnimatedContainerBehaviour.TYPE).startOpen(player);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        // based on the impl from chests.
        class_1735 slot = this.field_7761.get(index);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }

        // we need to copy the stack here since it may be modified by moveItemStackTo, but the
        // stack may be taken directly from a SlotItemHandler, which just defers to an IItemHandler.
        // modifying the original stack would violate the class's contract and cause problems.
        class_1799 stack = slot.method_7677().method_7972();
        // we return the stack that was moved out of the slot, so make a copy of that now too.
        class_1799 moved = stack.method_7972();

        int size = contentHolder.inventory.method_5439();
        if (index < size) {
            // move into player inventory
            if (!method_7616(stack, size, this.field_7761.size(), true)) {
                return class_1799.field_8037;
            }
        } else {
            // move into port inventory
            if (!method_7616(stack, 0, size, false)) {
                return class_1799.field_8037;
            }
        }

        if (stack.method_7960()) {
            slot.method_53512(class_1799.field_8037);
        } else {
            // setByPlayer instead of just setChanged, since we made a copy
            // setByPlayer instead of set because, I don't know, that's what the other branch does
            slot.method_53512(stack.method_7972());
        }

        return moved;
    }

    @Override
    protected void initAndReadInventory(PackagePortBlockEntity contentHolder) {
    }

    @Override
    protected void addSlots() {
        class_1263 inventory = contentHolder.inventory;
        int x = 27;
        int y = 9;

        for (int row = 0; row < 2; row++)
            for (int col = 0; col < 9; col++)
                method_7621(new MenuSlot(inventory, row * 9 + col, x + col * 18, y + row * 18));

        addPlayerSlots(38, 108);
    }

    @Override
    protected void saveData(PackagePortBlockEntity contentHolder) {
    }

    @Override
    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        if (!playerIn.method_73183().method_8608())
            BlockEntityBehaviour.get(contentHolder, AnimatedContainerBehaviour.TYPE).stopOpen(playerIn);
    }

    @Override
    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        // unfortunately, we kinda need to copy this entire method to make two tiny changes. I'm surprised
        // there's no forge patch for this considering it violates the contract of IItemHandler.getStackInSlot.

        boolean success = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }

        if (stack.method_7946()) {
            while (!stack.method_7960()) {
                if (reverseDirection) {
                    if (i < startIndex) {
                        break;
                    }
                } else if (i >= endIndex) {
                    break;
                }

                class_1735 slot = this.field_7761.get(i);
                class_1799 stackInSlot = slot.method_7677();
                if (!stackInSlot.method_7960() && class_1799.method_31577(stack, stackInSlot)) {
                    int totalCount = stackInSlot.method_7947() + stack.method_7947();
                    // note: forge patches this variable in, vanilla just uses stack.getMaxStackSize 4 times
                    int maxSize = Math.min(slot.method_7675(), stack.method_7914());
                    if (totalCount <= maxSize) {
                        stack.method_7939(0);
                        // change #1: set a new stack instead of modifying it directly
                        slot.method_53512(stackInSlot.method_46651(totalCount));
                        success = true;
                    } else if (stackInSlot.method_7947() < maxSize) {
                        stack.method_7934(maxSize - stackInSlot.method_7947());
                        // change #2: set a new stack instead of modifying it directly
                        slot.method_53512(stackInSlot.method_46651(maxSize));
                        success = true;
                    }
                }

                if (reverseDirection) {
                    --i;
                } else {
                    ++i;
                }
            }
        }

        if (!stack.method_7960()) {
            if (reverseDirection) {
                i = endIndex - 1;
            } else {
                i = startIndex;
            }

            while (true) {
                if (reverseDirection) {
                    if (i < startIndex) {
                        break;
                    }
                } else if (i >= endIndex) {
                    break;
                }

                class_1735 slot = this.field_7761.get(i);
                class_1799 stackInSlot = slot.method_7677();
                if (stackInSlot.method_7960() && slot.method_7680(stack)) {
                    if (stack.method_7947() > slot.method_7675()) {
                        slot.method_53512(stack.method_7971(slot.method_7675()));
                    } else {
                        slot.method_53512(stack.method_7971(stack.method_7947()));
                    }

                    slot.method_7668();
                    success = true;
                    break;
                }

                if (reverseDirection) {
                    --i;
                } else {
                    ++i;
                }
            }
        }

        return success;
    }
}
