package com.zurrtum.create.content.logistics.stockTicker;

import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour.RequestType;
import com.zurrtum.create.content.logistics.tableCloth.ShoppingListItem;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.ShoppingList;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class StockTickerInteractionHandler {
    public static class_1269 interactWithLogisticsManager(class_1297 entity, class_1657 player, class_1268 hand) {
        class_2338 targetPos = getStockTickerPosition(entity);
        if (targetPos == null)
            return null;

        if (interactWithLogisticsManagerAt(player, player.method_73183(), targetPos)) {
            return class_1269.field_5812;
        }
        return null;
    }

    public static boolean interactWithLogisticsManagerAt(class_1657 player, class_1937 level, class_2338 targetPos) {
        class_1799 mainHandItem = player.method_6047();

        if (mainHandItem.method_31574(AllItems.SHOPPING_LIST)) {
            interactWithShop(player, level, targetPos, mainHandItem);
            return true;
        }

        if (level.method_8608())
            return true;
        if (!(level.method_8321(targetPos) instanceof StockTickerBlockEntity stbe))
            return false;

        if (!stbe.behaviour.mayInteract(player)) {
            player.method_7353(class_2561.method_43471("create.stock_keeper.locked").method_27692(class_124.field_1061), true);
            return true;
        }

        if (player instanceof class_3222 sp) {
            MenuProvider.openHandledScreen(sp, stbe::createRequestMenu);
            stbe.getRecentSummary().divideAndSendTo(sp, targetPos);
        }

        return true;
    }

    private static void interactWithShop(class_1657 player, class_1937 level, class_2338 targetPos, class_1799 mainHandItem) {
        if (level.method_8608())
            return;
        if (!(level.method_8321(targetPos) instanceof StockTickerBlockEntity tickerBE))
            return;

        ShoppingList list = ShoppingListItem.getList(mainHandItem);
        if (list == null)
            return;

        if (!tickerBE.behaviour.freqId.equals(list.shopNetwork())) {
            AllSoundEvents.DENY.playOnServer(level, player.method_24515());
            player.method_7353(class_2561.method_43471("create.stock_keeper.wrong_network").method_27692(class_124.field_1061), true);
            return;
        }

        Couple<InventorySummary> bakeEntries = list.bakeEntries(level, null);
        InventorySummary paymentEntries = bakeEntries.getSecond();
        InventorySummary orderEntries = bakeEntries.getFirst();
        PackageOrder order = new PackageOrder(orderEntries.getStacksByCount());

        // Must be up-to-date
        tickerBE.getAccurateSummary();

        // Check stock levels
        InventorySummary recentSummary = tickerBE.getRecentSummary();
        for (BigItemStack entry : order.stacks()) {
            if (recentSummary.getCountOf(entry.stack) >= entry.count)
                continue;

            AllSoundEvents.DENY.playOnServer(level, player.method_24515());
            player.method_7353(class_2561.method_43471("create.stock_keeper.stock_level_too_low").method_27692(class_124.field_1061), true);
            return;
        }

        // Check space in stock ticker
        int occupiedSlots = 0;
        for (BigItemStack entry : paymentEntries.getStacksByCount())
            occupiedSlots += class_3532.method_15386(entry.count / (float) entry.stack.method_7914());
        class_1263 receivedPayments = tickerBE.receivedPayments;
        for (int i = 0, size = receivedPayments.method_5439(); i < size; i++)
            if (receivedPayments.method_5438(i).method_7960())
                occupiedSlots--;

        if (occupiedSlots > 0) {
            AllSoundEvents.DENY.playOnServer(level, player.method_24515());
            player.method_7353(class_2561.method_43471("create.stock_keeper.cash_register_full").method_27692(class_124.field_1061), true);
            return;
        }

        // Transfer payment to stock ticker
        class_1661 playerInventory = player.method_31548();
        for (boolean simulate : Iterate.trueAndFalse) {
            InventorySummary tally = paymentEntries.copy();
            List<class_1799> toTransfer = new ArrayList<>();

            for (int i = 0; i < class_1661.field_30638; i++) {
                class_1799 item = playerInventory.method_5438(i);
                if (item.method_7960())
                    continue;
                int countOf = tally.getCountOf(item);
                if (countOf == 0)
                    continue;
                int toRemove = Math.min(item.method_7947(), countOf);
                tally.add(item, -toRemove);

                if (simulate)
                    continue;

                int newStackSize = item.method_7947() - toRemove;
                playerInventory.method_5447(i, newStackSize == 0 ? class_1799.field_8037 : item.method_46651(newStackSize));
                toTransfer.add(item.method_46651(toRemove));
            }

            if (simulate && tally.getTotalCount() != 0) {
                AllSoundEvents.DENY.playOnServer(level, player.method_24515());
                player.method_7353(class_2561.method_43471("create.stock_keeper.too_broke").method_27692(class_124.field_1061), true);
                return;
            }

            if (simulate)
                continue;

            receivedPayments.insert(toTransfer);
        }

        tickerBE.broadcastPackageRequest(RequestType.PLAYER, order, null, ShoppingListItem.getAddress(mainHandItem));
        player.method_6122(class_1268.field_5808, class_1799.field_8037);
        if (!order.isEmpty())
            AllSoundEvents.STOCK_TICKER_TRADE.playOnServer(level, tickerBE.method_11016());
    }

    public static class_2338 getStockTickerPosition(class_1297 entity) {
        class_1297 rootVehicle = entity.method_5668();
        if (!(rootVehicle instanceof SeatEntity))
            return null;
        if (!(entity instanceof class_1309))
            return null;
        if (entity.method_5864() == AllEntityTypes.PACKAGE)
            return null;

        class_2338 pos = entity.method_24515();
        int stations = 0;
        class_2338 targetPos = null;

        class_1937 world = entity.method_73183();
        for (class_2350 d : Iterate.horizontalDirections) {
            for (int y : Iterate.zeroAndOne) {
                class_2338 workstationPos = pos.method_10093(d).method_10086(y);
                if (!(world.method_8320(workstationPos).method_26204() instanceof StockTickerBlock))
                    continue;
                targetPos = workstationPos;
                stations++;
            }
        }

        if (stations != 1)
            return null;
        return targetPos;
    }

}