package com.zurrtum.create.content.logistics.tableCloth;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.foundation.item.TooltipWorldContext;
import com.zurrtum.create.infrastructure.component.ShoppingList;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3417;

public class ShoppingListItem extends class_1792 {
    public ShoppingListItem(class_1793 pProperties) {
        super(pProperties);
    }

    public static ShoppingList getList(class_1799 stack) {
        return stack.method_58694(AllDataComponents.SHOPPING_LIST);
    }

    public static class_1799 saveList(class_1799 stack, ShoppingList list, String address) {
        stack.method_57379(AllDataComponents.SHOPPING_LIST, list);
        stack.method_57379(AllDataComponents.SHOPPING_LIST_ADDRESS, address);
        return stack;
    }

    public static String getAddress(class_1799 stack) {
        return stack.method_58695(AllDataComponents.SHOPPING_LIST_ADDRESS, "");
    }

    @Override
    public void method_67187(
        class_1799 stack,
        class_9635 context,
        class_10712 displayComponent,
        Consumer<class_2561> textConsumer,
        class_1836 type
    ) {
        ShoppingList list = getList(stack);

        if (list != null && context instanceof TooltipWorldContext worldContext) {
            Couple<InventorySummary> lists = list.bakeEntries(worldContext.create$getWorld(), null);

            for (InventorySummary items : lists) {
                List<BigItemStack> entries = items.getStacksByCount();
                boolean cost = items == lists.getSecond();

                if (cost)
                    textConsumer.accept(class_2561.method_43473());

                if (entries.size() == 1) {
                    BigItemStack entry = entries.getFirst();
                    textConsumer.accept((cost ? class_2561.method_43471("create.table_cloth.total_cost") : class_2561.method_43470("")).method_27692(
                        class_124.field_1065).method_10852(entry.stack.method_7964().method_27662().method_27693(" x").method_27693(String.valueOf(entry.count))
                        .method_27692(cost ? class_124.field_1054 : class_124.field_1080)));

                } else {
                    if (cost)
                        textConsumer.accept(class_2561.method_43471("create.table_cloth.total_cost").method_27692(class_124.field_1065));
                    for (BigItemStack entry : entries) {
                        textConsumer.accept(entry.stack.method_7964().method_27662().method_27693(" x").method_27693(String.valueOf(entry.count))
                            .method_27692(cost ? class_124.field_1054 : class_124.field_1080));
                    }
                }
            }
        }

        textConsumer.accept(class_2561.method_43471("create.table_cloth.hand_to_shop_keeper").method_27692(class_124.field_1080));

        textConsumer.accept(class_2561.method_43471("create.table_cloth.sneak_click_discard").method_27692(class_124.field_1063));
    }

    @Override
    public class_1269 method_7836(class_1937 pLevel, class_1657 pPlayer, class_1268 pUsedHand) {
        if (pUsedHand == class_1268.field_5810 || pPlayer == null || !pPlayer.method_5715())
            return class_1269.field_5811;

        pPlayer.method_7353(class_2561.method_43471("create.table_cloth.shopping_list_discarded"), true);
        pPlayer.method_56078(class_3417.field_17481);
        return class_1269.field_5812.method_61393(class_1799.field_8037);
    }

    @Override
    public class_1269 method_7884(class_1838 pContext) {
        class_1268 pUsedHand = pContext.method_20287();
        class_1657 pPlayer = pContext.method_8036();
        if (pUsedHand == class_1268.field_5810 || pPlayer == null || !pPlayer.method_5715())
            return class_1269.field_5811;
        pPlayer.method_6122(pUsedHand, class_1799.field_8037);

        pPlayer.method_7353(class_2561.method_43471("create.table_cloth.shopping_list_discarded"), true);
        pPlayer.method_56078(class_3417.field_17481);
        return class_1269.field_5812;
    }
}