package com.zurrtum.create.content.processing.recipe;

import com.mojang.serialization.Codec;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class SizedIngredient {
    public static class_9139<class_9129, SizedIngredient> PACKET_CODEC = class_9139.method_56435(
        class_1856.field_48355,
        i -> i.ingredient,
        class_9135.field_49675,
        i -> i.count,
        SizedIngredient::new
    );

    public static Codec<List<SizedIngredient>> getListCodec(int min, int max) {
        return class_1856.field_46095.listOf(min, max).xmap(SizedIngredient::of, SizedIngredient::unpack);
    }

    private final class_1856 ingredient;
    private int count;

    public SizedIngredient(class_1856 ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    public class_1856 getIngredient() {
        return ingredient;
    }

    public int getCount() {
        return count;
    }

    public boolean test(class_1799 stack) {
        return ingredient.method_8093(stack);
    }

    public static List<SizedIngredient> of(class_1867 recipe) {
        return of(recipe.field_9047);
    }

    public static List<SizedIngredient> of(List<class_1856> ingredients) {
        int size = ingredients.size();
        if (size == 0) {
            return List.of();
        }
        List<SizedIngredient> result = new ArrayList<>();
        result.add(new SizedIngredient(ingredients.getFirst(), 1));
        if (size == 1) {
            return result;
        }
        Find:
        for (int i = 1; i < size; i++) {
            class_1856 ingredient = ingredients.get(i);
            for (SizedIngredient sizedIngredient : result) {
                if (sizedIngredient.ingredient.equals(ingredient)) {
                    sizedIngredient.count++;
                    continue Find;
                }
            }
            result.add(new SizedIngredient(ingredient, 1));
        }
        return result;
    }

    public static List<SizedIngredient> of(class_1869 recipe) {
        List<Optional<class_1856>> ingredients = recipe.method_61693();
        List<SizedIngredient> result = new ArrayList<>();
        if (ingredients.isEmpty()) {
            return result;
        }
        Find:
        for (Optional<class_1856> placement : ingredients) {
            if (placement.isEmpty()) {
                continue;
            }
            class_1856 ingredient = placement.get();
            for (SizedIngredient sizedIngredient : result) {
                if (sizedIngredient.ingredient.equals(ingredient)) {
                    sizedIngredient.count++;
                    continue Find;
                }
            }
            result.add(new SizedIngredient(ingredient, 1));
        }
        return result;
    }

    public static List<class_1856> unpack(List<SizedIngredient> ingredients) {
        List<class_1856> result = new ArrayList<>();
        for (SizedIngredient sizedIngredient : ingredients) {
            for (int i = 0; i < sizedIngredient.count; i++) {
                result.add(sizedIngredient.ingredient);
            }
        }
        return result;
    }
}
