package com.zurrtum.create.content.processing.sequenced;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.*;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllAssemblyRecipeNames;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import com.zurrtum.create.foundation.recipe.ComponentsIngredient;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.infrastructure.component.SequencedAssemblyJunk;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5244;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9696;
import net.minecraft.world.item.crafting.*;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.util.TriConsumer;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public record SequencedAssemblyRecipe(
    class_1856 ingredient, class_1799 transitionalItem, ChanceOutput result, List<ChanceOutput> junks, int loops, List<class_1860<?>> sequence
) implements CreateRecipe<class_9696> {
    @Override
    public class_3956<SequencedAssemblyRecipe> method_17716() {
        return AllRecipeTypes.SEQUENCED_ASSEMBLY;
    }

    @Override
    public boolean matches(class_9696 input, class_1937 world) {
        return ingredient.method_8093(input.comp_2676());
    }

    @Override
    public class_1799 assemble(class_9696 input, class_7225.class_7874 registries) {
        return result.stack().method_7972();
    }

    @Override
    public class_1865<? extends class_1860<class_9696>> method_8119() {
        return AllRecipeSerializers.SEQUENCED_ASSEMBLY;
    }

    public static class Serializer implements class_1865<SequencedAssemblyRecipe> {
        private static final Codec<List<ChanceOutput>> JUNKS_CODEC = ChanceOutput.CODEC.listOf();
        private static final Codec<List<class_1860<?>>> RECIPE_CODEC = class_1860.field_47319.listOf();
        private static final MapCodec<SequencedAssemblyRecipe> RAW_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_1856.field_46095.fieldOf("ingredient").forGetter(SequencedAssemblyRecipe::ingredient),
            class_1799.field_24671.fieldOf("transitional_item").forGetter(SequencedAssemblyRecipe::transitionalItem),
            ChanceOutput.CODEC.fieldOf("result").forGetter(SequencedAssemblyRecipe::result),
            JUNKS_CODEC.optionalFieldOf("junks", List.of()).forGetter(SequencedAssemblyRecipe::junks),
            Codec.INT.optionalFieldOf("loops", 1).forGetter(SequencedAssemblyRecipe::loops),
            RECIPE_CODEC.fieldOf("sequence").forGetter(SequencedAssemblyRecipe::sequence)
        ).apply(instance, SequencedAssemblyRecipe::new));
        private static final String INGREDIENT_ID = "$ingredient";
        private static final String RESULT_ID = "$result";
        private static final AtomicInteger idGenerator = new AtomicInteger();
        public static final Map<class_2960, class_1860<?>> GENERATE_RECIPES = new HashMap<>();
        public static final MapCodec<SequencedAssemblyRecipe> CODEC = new MapCodec<>() {
            @Override
            public <T> RecordBuilder<T> encode(SequencedAssemblyRecipe input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                prefix.add("raw", ops.createBoolean(true));
                return RAW_CODEC.encode(input, ops, prefix);
            }

            @Override
            @SuppressWarnings("unchecked")
            public <T> DataResult<SequencedAssemblyRecipe> decode(DynamicOps<T> dynamicOps, MapLike<T> input) {
                if (input.get("raw") == null) {
                    if (!(input.get("sequence") instanceof JsonArray sequenceJson)) {
                        throw new UnsupportedOperationException("ops must be a JsonOps");
                    }
                    DynamicOps<JsonElement> ops = (DynamicOps<JsonElement>) dynamicOps;
                    int loops = Optional.ofNullable(input.get("loops")).map(value -> dynamicOps.getNumberValue(value, 1).intValue()).orElse(1);
                    int sequenceSize = sequenceJson.size();
                    int size = sequenceSize * loops;
                    if (size <= 1) {
                        throw new UnsupportedOperationException("sequence must have at least two steps");
                    }

                    class_1799 transitionalItem = class_1799.field_24671.parse(dynamicOps, input.get("transitional_item")).getOrThrow();
                    ChanceOutput result = ChanceOutput.CODEC.parse(dynamicOps, input.get("result")).getOrThrow();
                    List<ChanceOutput> junks = JUNKS_CODEC.parse(dynamicOps, input.get("junks")).result().orElse(List.of());

                    List<class_2561> RecipeName = new ArrayList<>(sequenceSize);
                    for (int i = 0; i < sequenceSize; i++) {
                        JsonObject object = (JsonObject) sequenceJson.get(i);
                        RecipeName.add(AllAssemblyRecipeNames.get(ops, object));
                    }

                    class_1799 transitional = transitionalItem.method_7972();
                    class_1856 transitionalIngredient = class_1856.method_8101(transitionalItem.method_7909());
                    Supplier<JsonElement> transitionalJsonIngredient = () -> ComponentsIngredient.CODEC.encodeStart(
                        ops,
                        new ComponentsIngredient(transitionalIngredient, transitional.method_57380())
                    ).getOrThrow();

                    List<BiFunction<JsonElement, JsonElement, JsonObject>> sequenceJsonFactory = new ArrayList<>(size);
                    for (int i = 0; i < sequenceSize; i++) {
                        JsonObject object = (JsonObject) sequenceJson.get(i);
                        Consumer<JsonElement> replaceIngredient = getReplace(object, INGREDIENT_ID);
                        Consumer<JsonElement> replaceResult = getReplace(object, RESULT_ID);
                        sequenceJsonFactory.add((ingredientJson, resultJson) -> {
                            if (replaceIngredient != null) {
                                replaceIngredient.accept(ingredientJson);
                            }
                            if (replaceResult != null) {
                                replaceResult.accept(resultJson);
                            }
                            return object;
                        });
                    }
                    MutableInt step = new MutableInt(1);
                    Supplier<JsonElement> transitionalJsonResult = () -> {
                        int index = step.getAndIncrement();
                        List<class_2561> lore = new ArrayList<>(6);
                        lore.add(class_5244.field_39003);
                        lore.add(class_2561.method_43471("create.recipe.sequenced_assembly").method_27692(class_124.field_1080)
                            .method_27694(style -> style.method_10978(false)));
                        lore.add(class_2561.method_43469("create.recipe.assembly.progress", index, size).method_27692(class_124.field_1063)
                            .method_27694(style -> style.method_10978(false)));
                        lore.add(class_2561.method_43469("create.recipe.assembly.next", RecipeName.get(index % sequenceSize))
                            .method_27692(class_124.field_1075).method_27694(style -> style.method_10978(false)));
                        for (int i = index + 1, end = Math.min(i + 2, size); i < end; i++) {
                            lore.add(class_2561.method_43470("-> ").method_10852(RecipeName.get(i % sequenceSize)).method_27692(class_124.field_1062)
                                .method_27694(style -> style.method_10978(false)));
                        }
                        transitional.method_57379(AllDataComponents.SEQUENCED_ASSEMBLY_PROGRESS, (float) index / size);
                        transitional.method_57379(class_9334.field_49632, new class_9290(lore, lore));
                        return class_1799.field_24671.encodeStart(ops, transitional).getOrThrow();
                    };
                    Supplier<JsonElement> transitionalJsonChanceResult = () -> {
                        transitional.method_57379(AllDataComponents.SEQUENCED_ASSEMBLY_JUNK, new SequencedAssemblyJunk(result.chance(), junks));
                        JsonElement element = transitionalJsonResult.get();
                        transitional.method_57381(AllDataComponents.SEQUENCED_ASSEMBLY_JUNK);
                        return element;
                    };
                    JsonElement jsonResult = class_1799.field_24671.encodeStart(ops, result.stack()).getOrThrow();

                    class_2960 id = class_2960.method_60654(AllRecipeTypes.SEQUENCED_ASSEMBLY.toString())
                        .method_48331("_" + idGenerator.incrementAndGet() + "_" + class_7923.field_41178.method_10221(result.stack().method_7909())
                            .method_12832() + "_");
                    List<class_1860<?>> sequence = new ArrayList<>(size);
                    TriConsumer<Integer, JsonElement, JsonElement> recipeAdd = (i, ingredientJson, resultJson) -> {
                        JsonObject object = sequenceJsonFactory.get(i % sequenceSize).apply(ingredientJson, resultJson);
                        class_1860<?> recipe = class_1860.field_47319.parse(ops, object).getOrThrow();
                        sequence.add(recipe);
                        GENERATE_RECIPES.put(id.method_48331(String.valueOf(sequence.size())), recipe);
                    };

                    JsonElement ingredientJson = (JsonElement) input.get("ingredient");
                    recipeAdd.accept(0, ingredientJson, size == 2 ? transitionalJsonChanceResult.get() : transitionalJsonResult.get());
                    for (int i = 1, end = size - 2; i < end; i++) {
                        recipeAdd.accept(i, transitionalJsonIngredient.get(), transitionalJsonResult.get());
                    }
                    if (size > 2) {
                        recipeAdd.accept(size - 2, transitionalJsonIngredient.get(), transitionalJsonChanceResult.get());
                    }
                    recipeAdd.accept(size - 1, transitionalJsonIngredient.get(), jsonResult);
                    return DataResult.success(new SequencedAssemblyRecipe(
                        class_1856.field_46095.parse(ops, ingredientJson).getOrThrow(),
                        transitionalItem,
                        result,
                        junks,
                        loops,
                        sequence
                    ));
                } else {
                    return RAW_CODEC.decode(dynamicOps, input);
                }
            }

            private static Consumer<JsonElement> getReplace(JsonObject target, String id) {
                for (Map.Entry<String, JsonElement> entry : target.entrySet()) {
                    JsonElement value = entry.getValue();
                    Consumer<JsonElement> consumer = getReplace(value, id);
                    if (consumer != null) {
                        return consumer;
                    } else if (match(value, id)) {
                        String key = entry.getKey();
                        return data -> target.add(key, data);
                    }
                }
                return null;
            }

            private static Consumer<JsonElement> getReplace(JsonArray target, String id) {
                for (int i = 0, size = target.size(); i < size; i++) {
                    JsonElement value = target.get(i);
                    Consumer<JsonElement> consumer = getReplace(value, id);
                    if (consumer != null) {
                        return consumer;
                    } else if (match(value, id)) {
                        int index = i;
                        return data -> target.set(index, data);
                    }
                }
                return null;
            }

            private static Consumer<JsonElement> getReplace(JsonElement target, String id) {
                if (target instanceof JsonObject object) {
                    return getReplace(object, id);
                } else if (target instanceof JsonArray array) {
                    return getReplace(array, id);
                }
                return null;
            }

            private static boolean match(JsonElement target, String id) {
                return target instanceof JsonPrimitive primitive && primitive.isString() && primitive.getAsString().equals(id);
            }

            @Override
            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(
                    ops.createString("ingredient"),
                    ops.createString("transitional_item"),
                    ops.createString("result"),
                    ops.createString("junks"),
                    ops.createString("loops"),
                    ops.createString("sequence")
                );
            }
        };
        public static final class_9139<class_9129, SequencedAssemblyRecipe> PACKET_CODEC = class_9139.method_58025(
            class_1856.field_48355,
            SequencedAssemblyRecipe::ingredient,
            class_1799.field_48349,
            SequencedAssemblyRecipe::transitionalItem,
            ChanceOutput.PACKET_CODEC,
            SequencedAssemblyRecipe::result,
            ChanceOutput.PACKET_CODEC.method_56433(class_9135.method_56363()),
            SequencedAssemblyRecipe::junks,
            class_9135.field_49675,
            SequencedAssemblyRecipe::loops,
            class_1860.field_48356.method_56433(class_9135.method_56363()),
            SequencedAssemblyRecipe::sequence,
            SequencedAssemblyRecipe::new
        );

        @Override
        public MapCodec<SequencedAssemblyRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, SequencedAssemblyRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}
