package com.zurrtum.create.content.redstone.deskBell;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class DeskBellBlockEntity extends SmartBlockEntity {

    public LerpedFloat animation = LerpedFloat.linear().startWithValue(0);

    public boolean ding;

    int blockStateTimer;
    public float animationOffset;

    public DeskBellBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.DESK_BELL, pos, state);
        blockStateTimer = 0;
    }

    @Override
    public void tick() {
        super.tick();
        animation.tickChaser();

        if (field_11863.method_8608())
            return;
        if (blockStateTimer == 0)
            return;

        blockStateTimer--;

        if (blockStateTimer > 0)
            return;
        class_2680 blockState = method_11010();
        if (blockState.method_11654(DeskBellBlock.POWERED))
            AllBlocks.DESK_BELL.unPress(blockState, field_11863, field_11867);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket && ding)
            view.method_71472("Ding", true);
        ding = false;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket && view.method_71433("Ding", false))
            ding();
    }

    public void ding() {
        if (!field_11863.method_8608()) {
            blockStateTimer = 20;
            ding = true;
            sendData();
            return;
        }

        animationOffset = field_11863.field_9229.method_43057() * 2 * class_3532.field_29844;
        animation.startWithValue(1).chase(0, 0.05, Chaser.LINEAR);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

}