package com.zurrtum.create.content.redstone.diodes;

import net.minecraft.class_1269;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class PoweredLatchBlock extends ToggleLatchBlock {

    public static class_2746 POWERED_SIDE = class_2746.method_11825("powered_side");

    public PoweredLatchBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(POWERED_SIDE, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(POWERED_SIDE));
    }

    @Override
    protected void method_9998(class_1937 worldIn, class_2338 pos, class_2680 state) {
        boolean back = state.method_11654(field_10911);
        boolean shouldBack = method_9990(worldIn, pos, state);
        boolean side = state.method_11654(POWERED_SIDE);
        boolean shouldSide = isPoweredOnSides(worldIn, pos, state);

        class_1953 tickpriority = class_1953.field_9310;
        if (method_9988(worldIn, pos, state))
            tickpriority = class_1953.field_9315;
        else if (side || back)
            tickpriority = class_1953.field_9313;

        if (worldIn.method_8397().method_8677(pos, this))
            return;
        if (back != shouldBack || side != shouldSide)
            worldIn.method_64311(pos, this, method_9992(state), tickpriority);
    }

    protected boolean isPoweredOnSides(class_1937 worldIn, class_2338 pos, class_2680 state) {
        class_2350 direction = state.method_11654(field_11177);
        class_2350 left = direction.method_10170();
        class_2350 right = direction.method_10160();

        for (class_2350 d : new class_2350[]{left, right}) {
            class_2338 blockpos = pos.method_10093(d);
            int i = worldIn.method_49808(blockpos, d);
            if (i > 0)
                return true;
            class_2680 blockstate = worldIn.method_8320(blockpos);
            if (blockstate.method_26204() == class_2246.field_10091 && blockstate.method_11654(class_2457.field_11432) > 0)
                return true;
        }
        return false;
    }

    @Override
    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        boolean back = state.method_11654(field_10911);
        boolean shouldBack = method_9990(worldIn, pos, state);
        boolean side = state.method_11654(POWERED_SIDE);
        boolean shouldSide = isPoweredOnSides(worldIn, pos, state);
        class_2680 stateIn = state;

        if (back != shouldBack) {
            state = state.method_11657(field_10911, shouldBack);
            if (shouldBack)
                state = state.method_11657(POWERING, true);
            else if (side)
                state = state.method_11657(POWERING, false);
        }

        if (side != shouldSide) {
            state = state.method_11657(POWERED_SIDE, shouldSide);
            if (shouldSide)
                state = state.method_11657(POWERING, false);
            else if (back)
                state = state.method_11657(POWERING, true);
        }

        if (state != stateIn)
            worldIn.method_8652(pos, state, class_2248.field_31028);
    }

    @Override
    protected class_1269 activated(class_1937 worldIn, class_2338 pos, class_2680 state) {
        if (state.method_11654(field_10911) != state.method_11654(POWERED_SIDE))
            return class_1269.field_52423;
        if (!worldIn.method_8608()) {
            float f = !state.method_11654(POWERING) ? 0.6F : 0.5F;
            worldIn.method_8396(null, pos, class_3417.field_14962, class_3419.field_15245, 0.3F, f);
            worldIn.method_8652(pos, state.method_28493(POWERING), class_2248.field_31028);
        }
        return class_1269.field_5812;
    }

    @Override
    public boolean canConnectRedstone(class_2680 state, class_2350 side) {
        if (side == null)
            return false;
        return side.method_10166().method_10179();
    }

}
