package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.kinetics.clock.CuckooClockBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;

public class TimeOfDayDisplaySource extends SingleLineDisplaySource {

    public static final class_5250 EMPTY_TIME;

    static {
        EMPTY_TIME = class_2561.method_43470("--:--");
    }

    @Override
    protected class_5250 provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        if (!(context.level() instanceof class_3218 sLevel))
            return EMPTY_TIME;
        if (!(context.getSourceBlockEntity() instanceof CuckooClockBlockEntity ccbe))
            return EMPTY_TIME;
        if (ccbe.getSpeed() == 0)
            return EMPTY_TIME;

        boolean c12 = context.sourceConfig().method_68083("Cycle", 0) == 0;

        int dayTime = (int) (sLevel.method_8532() % 24000);
        int hours = (dayTime / 1000 + 6) % 24;
        int minutes = (dayTime % 1000) * 60 / 1000;
        class_5250 suffix = class_2561.method_43471("create.generic.daytime." + (hours > 11 ? "pm" : "am"));

        minutes = minutes / 5 * 5;
        if (c12) {
            hours %= 12;
            if (hours == 0)
                hours = 12;
        }

        class_5250 component = class_2561.method_43470((hours < 10 ? " " : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + (c12 ? " " : ""));

        return c12 ? component.method_10852(suffix) : component;
    }

    @Override
    protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
        return "Instant";
    }

    @Override
    protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
        return new FlapDisplaySection(size * FlapDisplaySection.MONOSPACE, "instant", false, false);
    }

    @Override
    protected String getTranslationKey() {
        return "time_of_day";
    }

    @Override
    public boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }

}
