package com.zurrtum.create.content.schematics.table;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.utility.IInteractionChecker;
import com.zurrtum.create.infrastructure.items.ItemInventory;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_9129;

public class SchematicTableBlockEntity extends SmartBlockEntity implements MenuProvider, IInteractionChecker {

    public SchematicTableInventory inventory;
    public boolean isUploading;
    public String uploadingSchematic;
    public float uploadingProgress;
    public boolean sendUpdate;

    public class SchematicTableInventory implements ItemInventory {
        class_1799 left = class_1799.field_8037;
        class_1799 right = class_1799.field_8037;

        @Override
        public int method_5439() {
            return 2;
        }

        @Override
        public class_1799 method_5438(int slot) {
            if (slot >= 2) {
                return class_1799.field_8037;
            }
            return slot == 0 ? left : right;
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            if (slot >= 2) {
                return;
            }
            if (slot == 0) {
                left = stack;
            } else {
                right = stack;
            }
        }

        public void write(class_11372 view) {
            class_11372.class_11373<class_1799> list = view.method_71467("Inventory", class_1799.field_49266);
            list.method_71484(left);
            list.method_71484(right);
        }

        public void read(class_11368 view) {
            java.util.Iterator<class_1799> iterator = view.method_71437("Inventory", class_1799.field_49266).iterator();
            if (iterator.hasNext()) {
                left = iterator.next();
                if (iterator.hasNext()) {
                    right = iterator.next();
                }
            }
        }

        @Override
        public void method_5431() {
            SchematicTableBlockEntity.this.method_5431();
        }
    }

    public SchematicTableBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SCHEMATIC_TABLE, pos, state);
        inventory = new SchematicTableInventory();
        uploadingSchematic = null;
        uploadingProgress = 0;
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1264.method_5451(field_11863, pos, inventory);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        inventory.read(view);
        super.read(view, clientPacket);
        if (!clientPacket)
            return;
        if (view.method_71433("Uploading", false)) {
            isUploading = true;
            uploadingSchematic = view.method_71428("Schematic", "");
            uploadingProgress = view.method_71423("Progress", 0);
        } else {
            isUploading = false;
            uploadingSchematic = null;
            uploadingProgress = 0;
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        inventory.write(view);
        super.write(view, clientPacket);
        if (clientPacket && isUploading) {
            view.method_71472("Uploading", true);
            view.method_71469("Schematic", uploadingSchematic);
            view.method_71464("Progress", uploadingProgress);
        }
    }

    @Override
    public void tick() {
        // Update Client block entity
        if (sendUpdate) {
            sendUpdate = false;
            field_11863.method_8413(field_11867, method_11010(), method_11010(), 6);
        }
    }

    public void startUpload(String schematic) {
        isUploading = true;
        uploadingProgress = 0;
        uploadingSchematic = schematic;
        sendUpdate = true;
        inventory.method_5447(0, class_1799.field_8037);
    }

    public void finishUpload() {
        isUploading = false;
        uploadingProgress = 0;
        uploadingSchematic = null;
        sendUpdate = true;
    }

    @Override
    public SchematicTableMenu createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        sendToMenu(extraData);
        return new SchematicTableMenu(id, inv, this);
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471("create.gui.schematicTable.title");
    }

    @Override
    public boolean canPlayerUse(class_1657 player) {
        if (field_11863 == null || field_11863.method_8321(field_11867) != this) {
            return false;
        }
        return player.method_5649(field_11867.method_10263() + 0.5D, field_11867.method_10264() + 0.5D, field_11867.method_10260() + 0.5D) <= 64.0D;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

}
