package com.zurrtum.create.content.trains.graph;

import com.mojang.serialization.Codec;
import com.zurrtum.create.content.trains.observer.TrackObserver;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.station.GlobalStation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

import static com.zurrtum.create.Create.MOD_ID;

public class EdgePointType<T extends TrackEdgePoint> {
    public static final Map<class_2960, EdgePointType<?>> TYPES = new HashMap<>();
    public static final Codec<EdgePointType<?>> CODEC = class_2960.field_25139.xmap(TYPES::get, EdgePointType::getId);
    private final class_2960 id;
    private final Supplier<T> factory;

    public static final EdgePointType<SignalBoundary> SIGNAL = register(class_2960.method_60655(MOD_ID, "signal"), SignalBoundary::new);
    public static final EdgePointType<GlobalStation> STATION = register(class_2960.method_60655(MOD_ID, "station"), GlobalStation::new);
    public static final EdgePointType<TrackObserver> OBSERVER = register(class_2960.method_60655(MOD_ID, "observer"), TrackObserver::new);

    public static <T extends TrackEdgePoint> EdgePointType<T> register(class_2960 id, Supplier<T> factory) {
        EdgePointType<T> type = new EdgePointType<>(id, factory);
        TYPES.put(id, type);
        return type;
    }

    public EdgePointType(class_2960 id, Supplier<T> factory) {
        this.id = id;
        this.factory = factory;
    }

    public T create() {
        T t = factory.get();
        t.setType(this);
        return t;
    }

    public class_2960 getId() {
        return id;
    }

    public static TrackEdgePoint read(class_2540 buffer, DimensionPalette dimensions) {
        class_2960 type = buffer.method_10810();
        EdgePointType<?> edgePointType = TYPES.get(type);
        TrackEdgePoint point = edgePointType.create();
        point.read(buffer, dimensions);
        return point;
    }

}
