package com.zurrtum.create.content.trains.graph;

import com.zurrtum.create.content.trains.track.BezierConnection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5321;

public class TrackGraphBounds {

    public class_238 box;
    public List<BezierConnection> beziers;

    public TrackGraphBounds(TrackGraph graph, class_5321<class_1937> dimension) {
        beziers = new ArrayList<>();
        box = null;

        for (TrackNode node : graph.nodes.values()) {
            if (node.location.dimension != dimension)
                continue;
            include(node);
            Map<TrackNode, TrackEdge> connections = graph.getConnectionsFrom(node);
            for (TrackEdge edge : connections.values())
                if (edge.turn != null && edge.turn.isPrimary())
                    beziers.add(edge.turn);
        }

        if (box != null)
            box = box.method_1014(2);
    }

    private void include(TrackNode node) {
        class_243 v = node.location.getLocation();
        class_238 aabb = new class_238(v, v);
        box = box == null ? aabb : box.method_991(aabb);
    }

}
