package com.zurrtum.create.content.trains.schedule;

import com.mojang.serialization.*;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class Schedule {
    public static final class_9139<class_9129, Schedule> STREAM_CODEC = class_9139.method_56436(
        CatnipStreamCodecBuilders.list(ScheduleEntry.STREAM_CODEC),
        schedule -> schedule.entries,
        class_9135.field_48547,
        schedule -> schedule.cyclic,
        class_9135.field_48550,
        schedule -> schedule.savedProgress,
        Schedule::new
    );

    public List<ScheduleEntry> entries;
    public boolean cyclic;
    public int savedProgress;

    public Schedule() {
        this(new ArrayList<>(), true, 0);
    }

    public Schedule(List<ScheduleEntry> entries, boolean cyclic, int savedProgress) {
        this.entries = entries;
        this.cyclic = cyclic;
        this.savedProgress = savedProgress;
    }

    public void write(class_11372 view) {
        class_11372.class_11374 list = view.method_71476("Entries");
        entries.forEach(entry -> entry.write(list.method_71480()));
        view.method_71472("Cyclic", cyclic);
        if (savedProgress > 0)
            view.method_71465("Progress", savedProgress);
    }

    public static <T> DataResult<T> encode(final Schedule input, final DynamicOps<T> ops, final T empty) {
        RecordBuilder<T> map = ops.mapBuilder();
        ListBuilder<T> list = ops.listBuilder();
        input.entries.forEach(entry -> list.add(ScheduleEntry.encode(entry, ops, empty)));
        map.add("Entries", list.build(empty));
        map.add("Cyclic", ops.createBoolean(input.cyclic));
        if (input.savedProgress > 0)
            map.add("Progress", ops.createInt(input.savedProgress));
        return map.build(empty);
    }

    public static Schedule read(class_11368 view) {
        Schedule schedule = new Schedule();
        schedule.entries = view.method_71438("Entries").method_71447().map(ScheduleEntry::read).collect(Collectors.toList());
        schedule.cyclic = view.method_71433("Cyclic", false);
        view.method_71439("Progress").ifPresent(value -> schedule.savedProgress = value);
        return schedule;
    }

    public static <T> Schedule decode(DynamicOps<T> ops, T input) {
        MapLike<T> map = ops.getMap(input).getOrThrow();
        Schedule schedule = new Schedule();
        schedule.entries = ops.getStream(map.get("Entries"))
            .mapOrElse(stream -> stream.map(entry -> ScheduleEntry.decode(ops, entry)).collect(Collectors.toList()), e -> new ArrayList<>());
        schedule.cyclic = ops.getBooleanValue(map.get("Cyclic")).result().orElse(false);
        Optional.ofNullable(map.get("Progress")).ifPresent(value -> schedule.savedProgress = ops.getNumberValue(value).getOrThrow().intValue());
        return schedule;
    }

}
