package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Train;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public abstract class LazyTickedScheduleCondition extends ScheduleWaitCondition {

    private final int tickRate;

    public LazyTickedScheduleCondition(class_2960 id, int tickRate) {
        super(id);
        this.tickRate = tickRate;
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        int time = context.method_68083("Time", 0);
        if (time % tickRate == 0) {
            if (lazyTickCompletion(level, train, context))
                return true;
            time = 0;
        }
        context.method_10569("Time", time + 1);
        return false;
    }

    protected abstract boolean lazyTickCompletion(class_1937 level, Train train, class_2487 context);

}
