package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.AllTrackMaterials;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation.DiscoveredLocation;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public interface ITrackBlock {

    class_243 getUpNormal(class_1922 world, class_2338 pos, class_2680 state);

    List<class_243> getTrackAxes(class_1922 world, class_2338 pos, class_2680 state);

    class_243 getCurveStart(class_1922 world, class_2338 pos, class_2680 state, class_243 axis);

    default int getYOffsetAt(class_1922 world, class_2338 pos, class_2680 state, class_243 end) {
        return 0;
    }

    class_2680 getBogeyAnchor(class_1922 world, class_2338 pos, class_2680 state); // should be on bogey side

    boolean trackEquals(class_2680 state1, class_2680 state2);

    default class_2680 overlay(class_1922 world, class_2338 pos, class_2680 existing, class_2680 placed) {
        return existing;
    }

    default double getElevationAtCenter(class_1922 world, class_2338 pos, class_2680 state) {
        return isSlope(world, pos, state) ? .5 : 0;
    }

    static Collection<DiscoveredLocation> walkConnectedTracks(class_1922 worldIn, TrackNodeLocation location, boolean linear) {
        class_1922 world = location != null && worldIn instanceof class_3218 sl ? sl.method_8503().method_3847(location.dimension) : worldIn;
        List<DiscoveredLocation> list = new ArrayList<>();
        for (class_2338 blockPos : location.allAdjacent()) {
            class_2680 blockState = world.method_8320(blockPos);
            if (blockState.method_26204() instanceof ITrackBlock track)
                list.addAll(track.getConnected(world, blockPos, blockState, linear, location));
        }
        return list;
    }

    default Collection<DiscoveredLocation> getConnected(
        class_1922 worldIn,
        class_2338 pos,
        class_2680 state,
        boolean linear,
        @Nullable TrackNodeLocation connectedTo
    ) {
        class_1922 world = connectedTo != null && worldIn instanceof class_3218 sl ? sl.method_8503().method_3847(connectedTo.dimension) : worldIn;
        class_243 center = class_243.method_24955(pos).method_1031(0, getElevationAtCenter(world, pos, state), 0);
        List<DiscoveredLocation> list = new ArrayList<>();
        TrackShape shape = state.method_11654(TrackBlock.SHAPE);
        List<class_243> trackAxes = getTrackAxes(world, pos, state);

        trackAxes.forEach(axis -> {
            BiFunction<Double, Boolean, class_243> offsetFactory = (d, b) -> axis.method_1021(b ? d : -d).method_1019(center);
            Function<Boolean, class_5321<class_1937>> dimensionFactory = b -> world instanceof class_1937 l ? l.method_27983() : class_1937.field_25179;
            Function<class_243, Integer> yOffsetFactory = v -> getYOffsetAt(world, pos, state, v);

            addToListIfConnected(
                connectedTo,
                list,
                offsetFactory,
                b -> shape.getNormal(),
                dimensionFactory,
                yOffsetFactory,
                axis,
                null,
                (b, v) -> getMaterialSimple(world, v)
            );
        });

        return list;
    }

    static TrackMaterial getMaterialSimple(class_1922 world, class_243 pos) {
        return getMaterialSimple(world, pos, AllTrackMaterials.ANDESITE);
    }

    static TrackMaterial getMaterialSimple(class_1922 world, class_243 pos, TrackMaterial defaultMaterial) {
        if (defaultMaterial == null)
            defaultMaterial = AllTrackMaterials.ANDESITE;
        if (world != null) {
            class_2248 block = world.method_8320(class_2338.method_49638(pos)).method_26204();
            if (block instanceof ITrackBlock track) {
                return track.getMaterial();
            }
        }
        return defaultMaterial;
    }

    static void addToListIfConnected(
        @Nullable TrackNodeLocation fromEnd,
        Collection<DiscoveredLocation> list,
        BiFunction<Double, Boolean, class_243> offsetFactory,
        Function<Boolean, class_243> normalFactory,
        Function<Boolean, class_5321<class_1937>> dimensionFactory,
        Function<class_243, Integer> yOffsetFactory,
        class_243 axis,
        BezierConnection viaTurn,
        BiFunction<Boolean, class_243, TrackMaterial> materialFactory
    ) {

        class_243 firstOffset = offsetFactory.apply(0.5d, true);
        DiscoveredLocation firstLocation = new DiscoveredLocation(dimensionFactory.apply(true), firstOffset).viaTurn(viaTurn)
            .materialA(materialFactory.apply(true, offsetFactory.apply(0.0d, true)))
            .materialB(materialFactory.apply(true, offsetFactory.apply(1.0d, true))).withNormal(normalFactory.apply(true)).withDirection(axis)
            .withYOffset(yOffsetFactory.apply(firstOffset));

        class_243 secondOffset = offsetFactory.apply(0.5d, false);
        DiscoveredLocation secondLocation = new DiscoveredLocation(dimensionFactory.apply(false), secondOffset).viaTurn(viaTurn)
            .materialA(materialFactory.apply(false, offsetFactory.apply(0.0d, false)))
            .materialB(materialFactory.apply(false, offsetFactory.apply(1.0d, false))).withNormal(normalFactory.apply(false)).withDirection(axis)
            .withYOffset(yOffsetFactory.apply(secondOffset));

        if (!firstLocation.dimension.equals(secondLocation.dimension)) {
            firstLocation.forceNode();
            secondLocation.forceNode();
        }

        boolean skipFirst = false;
        boolean skipSecond = false;

        if (fromEnd != null) {
            boolean equalsFirst = firstLocation.equals(fromEnd);
            boolean equalsSecond = secondLocation.equals(fromEnd);

            // not reachable from this end
            if (!equalsFirst && !equalsSecond)
                return;

            if (equalsFirst)
                skipFirst = true;
            if (equalsSecond)
                skipSecond = true;
        }

        if (!skipFirst)
            list.add(firstLocation);
        if (!skipSecond)
            list.add(secondLocation);
    }

    default boolean isSlope(class_1922 world, class_2338 pos, class_2680 state) {
        return getTrackAxes(world, pos, state).get(0).field_1351 != 0;
    }

    default Pair<class_243, class_2352> getNearestTrackAxis(class_1922 world, class_2338 pos, class_2680 state, class_243 lookVec) {
        class_243 best = null;
        double bestDiff = Double.MAX_VALUE;
        for (class_243 vec3 : getTrackAxes(world, pos, state)) {
            for (int opposite : Iterate.positiveAndNegative) {
                double distanceTo = vec3.method_1029().method_1022(lookVec.method_1021(opposite));
                if (distanceTo > bestDiff)
                    continue;
                bestDiff = distanceTo;
                best = vec3;
            }
        }
        return Pair.of(best, lookVec.method_1026(best.method_18805(1, 0, 1).method_1029()) < 0 ? class_2352.field_11056 : class_2352.field_11060);
    }

    TrackMaterial getMaterial();

}
