package com.zurrtum.create.foundation.blockEntity.behaviour.edgeInteraction;

import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;

import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class EdgeInteractionBehaviour extends BlockEntityBehaviour<SmartBlockEntity> {

    public static final BehaviourType<EdgeInteractionBehaviour> TYPE = new BehaviourType<>();

    ConnectionCallback connectionCallback;
    ConnectivityPredicate connectivityPredicate;
    public Predicate<class_1792> requiredItem;

    public EdgeInteractionBehaviour(SmartBlockEntity be, ConnectionCallback callback) {
        super(be);
        connectionCallback = callback;
        requiredItem = item -> true;
        connectivityPredicate = (world, pos, face, face2) -> true;
    }

    public EdgeInteractionBehaviour connectivity(ConnectivityPredicate pred) {
        connectivityPredicate = pred;
        return this;
    }

    public EdgeInteractionBehaviour require(class_1792 required) {
        return require(item -> item == required);
    }

    public EdgeInteractionBehaviour require(Predicate<class_1792> predicate) {
        requiredItem = predicate;
        return this;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @FunctionalInterface
    public interface ConnectionCallback {
        void apply(class_1937 world, class_2338 clicked, class_2338 neighbour);
    }

    @FunctionalInterface
    public interface ConnectivityPredicate {
        boolean test(class_1937 world, class_2338 pos, class_2350 selectedFace, class_2350 connectedFace);
    }

}
