package com.zurrtum.create.foundation.fluid;

import com.zurrtum.create.AllFluidItemInventory;
import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.fluids.transfer.GenericItemFilling;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;

public class FluidHelper {
    private static final Map<class_2338, FluidInventoryCache> INV_CACHE = new Object2ReferenceOpenHashMap<>();

    public enum FluidExchange {
        ITEM_TO_TANK,
        TANK_TO_ITEM;
    }

    public static boolean isWater(class_3611 fluid) {
        return convertToStill(fluid) == class_3612.field_15910;
    }

    public static boolean isLava(class_3611 fluid) {
        return convertToStill(fluid) == class_3612.field_15908;
    }

    public static boolean isSame(FluidStack fluidStack, FluidStack fluidStack2) {
        return fluidStack.getFluid() == fluidStack2.getFluid();
    }

    public static boolean isSame(FluidStack fluidStack, class_3611 fluid) {
        return fluidStack.getFluid() == fluid;
    }

    @SuppressWarnings("deprecation")
    public static boolean isTag(class_3611 fluid, class_6862<class_3611> tag) {
        return fluid.method_15791(tag);
    }

    public static boolean isTag(class_3610 fluid, class_6862<class_3611> tag) {
        return fluid.method_15767(tag);
    }

    public static boolean isTag(FluidStack fluid, class_6862<class_3611> tag) {
        return isTag(fluid.getFluid(), tag);
    }

    public static class_3414 getFillSound(FluidStack fluid) {
        //TODO
        class_3414 soundevent = null;//fluid.getFluid().getFluidType().getSound(fluid, SoundActions.BUCKET_FILL);
        if (soundevent == null)
            soundevent = FluidHelper.isTag(fluid, class_3486.field_15518) ? class_3417.field_15202 : class_3417.field_15126;
        return soundevent;
    }

    public static class_3414 getEmptySound(FluidStack fluid) {
        //TODO
        class_3414 soundevent = null;//fluid.getFluid().getFluidType().getSound(fluid, SoundActions.BUCKET_EMPTY);
        if (soundevent == null)
            soundevent = FluidHelper.isTag(fluid, class_3486.field_15518) ? class_3417.field_15010 : class_3417.field_14834;
        return soundevent;
    }

    public static boolean hasBlockState(class_3611 fluid) {
        class_2680 blockState = fluid.method_15785().method_15759();
        return blockState != null && blockState != class_2246.field_10124.method_9564();
    }

    public static FluidStack copyStackWithAmount(FluidStack fs, int amount) {
        if (amount <= 0)
            return FluidStack.EMPTY;
        if (fs.isEmpty())
            return FluidStack.EMPTY;
        FluidStack copy = fs.copy();
        copy.setAmount(amount);
        return copy;
    }

    public static class_3611 convertToFlowing(class_3611 fluid) {
        if (fluid instanceof class_3609 flowableFluid)
            return flowableFluid.method_15750();
        return fluid;
    }

    public static class_3611 convertToStill(class_3611 fluid) {
        if (fluid instanceof class_3609 flowableFluid)
            return flowableFluid.method_15751();
        return fluid;
    }

    public static FluidInventory getFluidInventory(class_1937 world, class_2338 pos, class_2350 direction) {
        return getFluidInventory(world, pos, null, null, direction);
    }

    public static FluidInventory getFluidInventory(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity, class_2350 direction) {
        if (state == null) {
            state = blockEntity != null ? blockEntity.method_11010() : world.method_8320(pos);
        }
        if (state.method_26204() instanceof FluidInventoryProvider<?> provider) {
            return provider.getFluidInventory(state, world, pos, blockEntity, direction);
        }
        return AllTransfer.getFluidInventory(world, pos, state, blockEntity, direction);
    }

    public static boolean hasFluidInventory(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity, class_2350 direction) {
        if (state == null) {
            state = blockEntity != null ? blockEntity.method_11010() : world.method_8320(pos);
        }
        if (state.method_26204() instanceof FluidInventoryProvider<?>) {
            return true;
        }
        return AllTransfer.hasFluidInventory(world, pos, state, blockEntity, direction);
    }

    public static FluidItemInventory getFluidInventory(class_1799 stack) {
        FluidItemInventory inventory = AllFluidItemInventory.of(stack);
        if (inventory != null) {
            return inventory;
        }
        return AllTransfer.getFluidInventory(stack);
    }

    public static boolean hasFluidInventory(class_1799 stack) {
        return AllFluidItemInventory.has(stack) || AllTransfer.hasFluidInventory(stack);
    }

    public static boolean tryEmptyItemIntoBE(class_1937 worldIn, class_1657 player, class_1268 handIn, class_1799 heldItem, SmartBlockEntity be) {
        if (!GenericItemEmptying.canItemBeEmptied(worldIn, heldItem))
            return false;

        FluidInventory capability = getFluidInventory(worldIn, be.method_11016(), null, be, null);
        if (capability == null) {
            return false;
        }
        if (worldIn.method_8608())
            return true;
        Pair<FluidStack, class_1799> emptyingResult = GenericItemEmptying.emptyItem(worldIn, heldItem, true);
        FluidStack fluidStack = emptyingResult.getFirst();
        if (!capability.preciseInsert(fluidStack, null)) {
            return false;
        }

        class_1799 copyOfHeld = heldItem.method_7972();
        emptyingResult = GenericItemEmptying.emptyItem(worldIn, copyOfHeld, false);

        if (!player.method_68878() && !(be instanceof CreativeFluidTankBlockEntity)) {
            if (copyOfHeld.method_7960())
                player.method_6122(handIn, emptyingResult.getSecond());
            else {
                player.method_6122(handIn, copyOfHeld);
                player.method_31548().method_7398(emptyingResult.getSecond());
            }
        }
        return true;
    }

    public static boolean tryFillItemFromBE(class_1937 world, class_1657 player, class_1268 handIn, class_1799 heldItem, SmartBlockEntity be) {
        if (!GenericItemFilling.canItemBeFilled(world, heldItem))
            return false;

        FluidInventory capability = FluidHelper.getFluidInventory(world, be.method_11016(), null, be, null);

        if (capability == null)
            return false;

        for (FluidStack fluid : capability) {
            if (fluid.isEmpty())
                continue;
            int requiredAmountForItem = GenericItemFilling.getRequiredAmountForItem(world, heldItem, fluid.copy());
            if (requiredAmountForItem == -1)
                continue;
            if (requiredAmountForItem > fluid.getAmount())
                continue;

            if (world.method_8608())
                return true;

            if (player.method_68878() || be instanceof CreativeFluidTankBlockEntity)
                heldItem = heldItem.method_7972();
            class_1799 out = GenericItemFilling.fillItem(world, requiredAmountForItem, heldItem, fluid.copy());

            FluidStack copy = fluid.copy();
            copy.setAmount(requiredAmountForItem);
            capability.extract(copy, null);

            if (!player.method_68878())
                player.method_31548().method_7398(out);
            be.notifyUpdate();
            return true;
        }

        return false;
    }

    //TODO
    //    @Nullable
    //    public static FluidExchange exchange(IFluidHandler fluidTank, IFluidHandlerItem fluidItem, FluidExchange preferred, int maxAmount) {
    //        return exchange(fluidTank, fluidItem, preferred, true, maxAmount);
    //    }
    //
    //    @Nullable
    //    public static FluidExchange exchangeAll(IFluidHandler fluidTank, IFluidHandlerItem fluidItem, FluidExchange preferred) {
    //        return exchange(fluidTank, fluidItem, preferred, false, Integer.MAX_VALUE);
    //    }
    //
    //    @Nullable
    //    private static FluidExchange exchange(
    //        IFluidHandler fluidTank,
    //        IFluidHandlerItem fluidItem,
    //        FluidExchange preferred,
    //        boolean singleOp,
    //        int maxTransferAmountPerTank
    //    ) {
    //
    //        // Locks in the transfer direction of this operation
    //        FluidExchange lockedExchange = null;
    //
    //        for (int tankSlot = 0; tankSlot < fluidTank.getTanks(); tankSlot++) {
    //            for (int slot = 0; slot < fluidItem.getTanks(); slot++) {
    //
    //                FluidStack fluidInTank = fluidTank.getFluidInTank(tankSlot);
    //                int tankCapacity = fluidTank.getTankCapacity(tankSlot) - fluidInTank.getAmount();
    //                boolean tankEmpty = fluidInTank.isEmpty();
    //
    //                FluidStack fluidInItem = fluidItem.getFluidInTank(tankSlot);
    //                int itemCapacity = fluidItem.getTankCapacity(tankSlot) - fluidInItem.getAmount();
    //                boolean itemEmpty = fluidInItem.isEmpty();
    //
    //                boolean undecided = lockedExchange == null;
    //                boolean canMoveToTank = (undecided || lockedExchange == FluidExchange.ITEM_TO_TANK) && tankCapacity > 0;
    //                boolean canMoveToItem = (undecided || lockedExchange == FluidExchange.TANK_TO_ITEM) && itemCapacity > 0;
    //
    //                // Incompatible Liquids
    //                if (!tankEmpty && !itemEmpty && !FluidStack.isSameFluidSameComponents(fluidInItem, fluidInTank))
    //                    continue;
    //
    //                // Transfer liquid to tank
    //                if (((tankEmpty || itemCapacity <= 0) && canMoveToTank) || undecided && preferred == FluidExchange.ITEM_TO_TANK) {
    //
    //                    int amount = fluidTank.fill(
    //                        fluidItem.drain(Math.min(maxTransferAmountPerTank, tankCapacity), FluidAction.EXECUTE),
    //                        FluidAction.EXECUTE
    //                    );
    //                    if (amount > 0) {
    //                        lockedExchange = FluidExchange.ITEM_TO_TANK;
    //                        if (singleOp)
    //                            return lockedExchange;
    //                        continue;
    //                    }
    //                }
    //
    //                // Transfer liquid from tank
    //                if (((itemEmpty || tankCapacity <= 0) && canMoveToItem) || undecided && preferred == FluidExchange.TANK_TO_ITEM) {
    //
    //                    int amount = fluidItem.fill(
    //                        fluidTank.drain(Math.min(maxTransferAmountPerTank, itemCapacity), FluidAction.EXECUTE),
    //                        FluidAction.EXECUTE
    //                    );
    //                    if (amount > 0) {
    //                        lockedExchange = FluidExchange.TANK_TO_ITEM;
    //                        if (singleOp)
    //                            return lockedExchange;
    //                        continue;
    //                    }
    //
    //                }
    //
    //            }
    //        }
    //
    //        return null;
    //    }

    public static Supplier<FluidInventory> getFluidInventoryCache(class_3218 world, class_2338 pos, class_2350 direction) {
        FluidInventoryCache cache = new FluidInventoryCache(world, pos, direction);
        INV_CACHE.put(pos, cache);
        return cache;
    }

    public static void invalidateInventoryCache(class_2338 pos) {
        FluidInventoryCache cache = INV_CACHE.get(pos);
        if (cache != null) {
            cache.invalidate();
        }
    }
}
