package com.zurrtum.create.foundation.fluid;

import com.mojang.serialization.Codec;
import com.zurrtum.create.infrastructure.fluids.FluidStack;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_3611;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface FluidIngredient extends Predicate<FluidStack> {
    Codec<FluidIngredient> CODEC = FluidIngredientSerializer.CODEC.dispatch(FluidIngredient::getSerializer, FluidIngredientSerializer::codec);
    class_9139<class_9129, FluidIngredient> PACKET_CODEC = FluidIngredientSerializer.PACKET_CODEC.method_56440(
        FluidIngredient::getSerializer,
        FluidIngredientSerializer::packetCodec
    );

    int amount();

    boolean test(FluidStack stack);

    List<class_3611> getMatchingFluids();

    List<FluidStack> getMatchingFluidStacks();

    FluidIngredientSerializer getSerializer();
}