package com.zurrtum.create.foundation.fluid;

import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;

import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class FluidInventoryCache implements Supplier<FluidInventory> {
    public final class_3218 world;
    public final class_2350 direction;
    public final class_2338 pos;
    public boolean cached;
    public FluidInventory inventory;
    public Supplier<FluidInventory> getter = this::refresh;

    public FluidInventoryCache(class_3218 world, class_2338 pos, class_2350 direction) {
        this.world = world;
        this.direction = direction;
        this.pos = pos;
    }

    @Override
    public FluidInventory get() {
        if (cached) {
            return inventory;
        }
        return inventory = getter.get();
    }

    public void invalidate() {
        cached = false;
        getter = this::refresh;
    }

    private FluidInventory refresh() {
        cached = true;
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof FluidInventoryProvider<?> provider) {
            return provider.getFluidInventory(state, world, pos, null, direction);
        }
        getter = AllTransfer.getCacheFluidInventory(world, pos, direction);
        if (getter == null) {
            return null;
        }
        cached = false;
        return getter.get();
    }
}

