package com.zurrtum.create.foundation.fluid;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.infrastructure.fluids.FluidStack;

import java.util.List;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;

public record FluidStackIngredient(class_3611 fluid, class_9326 components, int amount) implements FluidIngredient {
    @Override
    public boolean test(FluidStack stack) {
        if (stack.getFluid() != fluid)
            return false;
        if (components.method_57848())
            return true;
        return stack.getComponentChanges().field_49591.reference2ObjectEntrySet().containsAll(components.field_49591.reference2ObjectEntrySet());
    }

    @Override
    public List<class_3611> getMatchingFluids() {
        return List.of(fluid);
    }

    @Override
    public List<FluidStack> getMatchingFluidStacks() {
        return List.of(new FluidStack(fluid, amount, components));
    }

    @Override
    public FluidIngredientSerializer getSerializer() {
        return FluidIngredientSerializer.FLUID_STACK;
    }

    public record Serializer(String type) implements FluidIngredientSerializer {
        public static final MapCodec<FluidStackIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_7923.field_41173.method_39673().fieldOf("fluid").forGetter(FluidStackIngredient::fluid),
            class_9326.field_49589.optionalFieldOf("components", class_9326.field_49588).forGetter(FluidStackIngredient::components),
            Codec.INT.optionalFieldOf("amount", 81000).forGetter(FluidStackIngredient::amount)
        ).apply(instance, FluidStackIngredient::new));
        public static final class_9139<class_9129, FluidStackIngredient> PACKET_CODEC = class_9139.method_56436(
            class_9135.method_56365(class_7924.field_41270),
            FluidStackIngredient::fluid,
            class_9326.field_49590,
            FluidStackIngredient::components,
            class_9135.field_49675,
            FluidStackIngredient::amount,
            FluidStackIngredient::new
        );

        @Override
        public MapCodec<FluidStackIngredient> codec() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, FluidStackIngredient> packetCodec() {
            return PACKET_CODEC;
        }
    }
}
