package com.zurrtum.create.foundation.item;

import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;

import java.util.*;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5250;

public class CountedItemStackList {

    Map<class_1792, Set<ItemStackEntry>> items = new HashMap<>();

    public CountedItemStackList(class_1263 inventory, ServerFilteringBehaviour filteringBehaviour) {
        for (int slot = 0, size = inventory.method_5439(); slot < size; slot++) {
            class_1799 extractItem = inventory.method_5438(slot);
            if (filteringBehaviour.test(extractItem))
                add(extractItem);
        }
    }

    public Stream<IntAttached<class_5250>> getTopNames(int limit) {
        return items.values().stream().flatMap(Collection::stream).sorted(IntAttached.comparator()).limit(limit)
            .map(entry -> IntAttached.with(entry.count(), entry.stack().method_7964().method_27661()));
    }

    public void add(class_1799 stack) {
        add(stack, stack.method_7947());
    }

    public void add(class_1799 stack, int amount) {
        if (stack.method_7960())
            return;

        Set<ItemStackEntry> stackSet = getOrCreateItemSet(stack);
        for (ItemStackEntry entry : stackSet) {
            if (!entry.matches(stack))
                continue;
            entry.grow(amount);
            return;
        }
        stackSet.add(new ItemStackEntry(stack, amount));
    }

    private Set<ItemStackEntry> getOrCreateItemSet(class_1799 stack) {
        if (!items.containsKey(stack.method_7909()))
            items.put(stack.method_7909(), new HashSet<>());
        return getItemSet(stack);
    }

    private Set<ItemStackEntry> getItemSet(class_1799 stack) {
        return items.get(stack.method_7909());
    }

    public static class ItemStackEntry extends IntAttached<class_1799> {

        public ItemStackEntry(class_1799 stack) {
            this(stack, stack.method_7947());
        }

        public ItemStackEntry(class_1799 stack, int amount) {
            super(amount, stack);
        }

        public boolean matches(class_1799 other) {
            return class_1799.method_31577(other, stack());
        }

        public class_1799 stack() {
            return getSecond();
        }

        public void grow(int amount) {
            setFirst(getFirst() + amount);
        }

        public int count() {
            return getFirst();
        }

    }

}
